/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.assignment.AssignProcedure;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionTransitionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MetaProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.ServerCrashException;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@InterfaceAudience.Private
public class RecoverMetaProcedure
extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.RecoverMetaState>
implements MetaProcedureInterface {
    private static final Logger LOG = LoggerFactory.getLogger(RecoverMetaProcedure.class);
    private ServerName failedMetaServer;
    private boolean shouldSplitWal;
    private int replicaId;
    private final ProcedurePrepareLatch syncLatch;
    private MasterServices master;

    public RecoverMetaProcedure(ServerName failedMetaServer, boolean shouldSplitLog) {
        this(failedMetaServer, shouldSplitLog, null);
    }

    public RecoverMetaProcedure(ServerName failedMetaServer, boolean shouldSplitLog, ProcedurePrepareLatch latch) {
        this.failedMetaServer = failedMetaServer;
        this.shouldSplitWal = shouldSplitLog;
        this.replicaId = 0;
        this.syncLatch = latch;
    }

    public RecoverMetaProcedure() {
        this(null, false);
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.RecoverMetaState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        this.prepare(env);
        if (!this.isRunRequired()) {
            LOG.info(this + "; Meta already initialized. Skipping run");
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        try {
            switch (state) {
                case RECOVER_META_PREPARE: {
                    if (!this.master.isClusterUp()) {
                        String msg = "Cluster not up! Skipping hbase:meta assign.";
                        LOG.warn(msg);
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    if (this.master.isStopping() || this.master.isStopped()) {
                        String msg = "Master stopping=" + this.master.isStopping() + ", stopped=" + this.master.isStopped() + "; skipping hbase:meta assign.";
                        LOG.warn(msg);
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    this.setNextState(MasterProcedureProtos.RecoverMetaState.RECOVER_META_SPLIT_LOGS);
                    break;
                }
                case RECOVER_META_SPLIT_LOGS: {
                    LOG.info("Start " + this);
                    if (this.shouldSplitWal) {
                        AssignmentManager am = env.getMasterServices().getAssignmentManager();
                        if (this.failedMetaServer != null) {
                            am.getRegionStates().metaLogSplitting(this.failedMetaServer);
                            this.master.getMasterWalManager().splitMetaLog(this.failedMetaServer);
                            am.getRegionStates().metaLogSplit(this.failedMetaServer);
                        } else {
                            ServerName serverName = this.master.getMetaTableLocator().getMetaRegionLocation(this.master.getZooKeeper());
                            Set<ServerName> previouslyFailedServers = this.master.getMasterWalManager().getFailedServersFromLogFolders();
                            if (serverName != null && previouslyFailedServers.contains(serverName)) {
                                am.getRegionStates().metaLogSplitting(serverName);
                                this.master.getMasterWalManager().splitMetaLog(serverName);
                                am.getRegionStates().metaLogSplit(serverName);
                            }
                        }
                    }
                    this.setNextState(MasterProcedureProtos.RecoverMetaState.RECOVER_META_ASSIGN_REGIONS);
                    break;
                }
                case RECOVER_META_ASSIGN_REGIONS: {
                    AssignProcedure metaAssignProcedure;
                    RegionInfo hri = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (int)this.replicaId);
                    AssignmentManager am = this.master.getAssignmentManager();
                    if (this.failedMetaServer != null) {
                        this.handleRIT(env, hri, this.failedMetaServer);
                        LOG.info(this + "; Assigning meta with new plan; previous server=" + this.failedMetaServer);
                        metaAssignProcedure = am.createAssignProcedure(hri);
                    } else {
                        ServerName metaServer = MetaTableLocator.getMetaRegionState((ZKWatcher)this.master.getZooKeeper()).getServerName();
                        LOG.info(this + "; Retaining meta assignment to server=" + metaServer);
                        metaAssignProcedure = am.createAssignProcedure(hri, metaServer);
                    }
                    this.addChildProcedure(new Procedure[]{metaAssignProcedure});
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException("unhandled state=" + state);
                }
            }
        }
        catch (IOException | KeeperException e) {
            LOG.warn(this + "; Failed state=" + state + ", retry " + this + "; cycles=" + this.getCycles(), e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private void handleRIT(MasterProcedureEnv env, RegionInfo ri, ServerName crashedServerName) {
        AssignmentManager am = env.getAssignmentManager();
        RegionTransitionProcedure rtp = am.getRegionStates().getRegionTransitionProcedure(ri);
        if (rtp == null) {
            return;
        }
        ServerName rtpServerName = rtp.getServer(env);
        if (rtpServerName == null) {
            LOG.warn("RIT with ServerName null! " + rtp);
        } else if (rtpServerName.equals((Object)crashedServerName)) {
            LOG.info("pid=" + this.getProcId() + " found RIT " + rtp + "; " + rtp.getRegionState(env).toShortString());
            rtp.remoteCallFailed(env, crashedServerName, (IOException)((Object)new ServerCrashException(this.getProcId(), crashedServerName)));
        }
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.RecoverMetaState recoverMetaState) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("unhandled state=" + recoverMetaState);
    }

    protected MasterProcedureProtos.RecoverMetaState getState(int stateId) {
        return MasterProcedureProtos.RecoverMetaState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.RecoverMetaState recoverMetaState) {
        return recoverMetaState.getNumber();
    }

    protected MasterProcedureProtos.RecoverMetaState getInitialState() {
        return MasterProcedureProtos.RecoverMetaState.RECOVER_META_PREPARE;
    }

    protected void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" failedMetaServer=");
        sb.append(this.failedMetaServer);
        sb.append(", splitWal=");
        sb.append(this.shouldSplitWal);
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.RecoverMetaStateData.Builder state = MasterProcedureProtos.RecoverMetaStateData.newBuilder().setShouldSplitWal(this.shouldSplitWal);
        if (this.failedMetaServer != null) {
            state.setFailedMetaServer(ProtobufUtil.toServerName((ServerName)this.failedMetaServer));
        }
        state.setReplicaId(this.replicaId);
        serializer.serialize((Message)state.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.RecoverMetaStateData state = (MasterProcedureProtos.RecoverMetaStateData)serializer.deserialize(MasterProcedureProtos.RecoverMetaStateData.class);
        this.shouldSplitWal = state.hasShouldSplitWal() && state.getShouldSplitWal();
        this.failedMetaServer = state.hasFailedMetaServer() ? ProtobufUtil.toServerName((HBaseProtos.ServerName)state.getFailedMetaServer()) : null;
        this.replicaId = state.hasReplicaId() ? state.getReplicaId() : 0;
    }

    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.getProcedureScheduler().waitMetaExclusiveLock((Procedure<?>)this)) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureScheduler().wakeMetaExclusiveLock((Procedure<?>)this);
    }

    protected void completionCleanup(MasterProcedureEnv env) {
        ProcedurePrepareLatch.releaseLatch(this.syncLatch, (Procedure)this);
    }

    private boolean isRunRequired() {
        return this.failedMetaServer != null || !this.master.getAssignmentManager().isMetaAssigned();
    }

    private void prepare(MasterProcedureEnv env) {
        if (this.master == null) {
            this.master = env.getMasterServices();
            Preconditions.checkArgument((this.master != null ? 1 : 0) != 0);
        }
    }
}

