/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
public class MemStoreSize {
    private final long dataSize;
    private final long heapSize;
    private final long offHeapSize;

    MemStoreSize() {
        this(0L, 0L, 0L);
    }

    MemStoreSize(long dataSize, long heapSize, long offHeapSize) {
        this.dataSize = dataSize;
        this.heapSize = heapSize;
        this.offHeapSize = offHeapSize;
    }

    MemStoreSize(MemStoreSize memStoreSize) {
        this.dataSize = memStoreSize.getDataSize();
        this.heapSize = memStoreSize.getHeapSize();
        this.offHeapSize = memStoreSize.getOffHeapSize();
    }

    public boolean isEmpty() {
        return this.dataSize == 0L && this.heapSize == 0L && this.offHeapSize == 0L;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public long getHeapSize() {
        return this.heapSize;
    }

    public long getOffHeapSize() {
        return this.offHeapSize;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemStoreSize)) {
            return false;
        }
        MemStoreSize other = (MemStoreSize)obj;
        return this.dataSize == other.dataSize && this.heapSize == other.heapSize && this.offHeapSize == other.offHeapSize;
    }

    public int hashCode() {
        long h = 31L * this.dataSize;
        h += 31L * this.heapSize;
        return (int)(h += 31L * this.offHeapSize);
    }

    public String toString() {
        return "dataSize=" + this.dataSize + ", getHeapSize=" + this.heapSize + ", getOffHeapSize=" + this.offHeapSize;
    }
}

