/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.read;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.parquet.ProjectionPusher;
import org.apache.hadoop.hive.ql.io.parquet.read.DataWritableReadSupport;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import parquet.filter2.predicate.FilterPredicate;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.ParquetInputSplit;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.FileMetaData;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.hadoop.util.ContextUtil;
import parquet.schema.MessageTypeParser;

public class ParquetRecordReaderWrapper
implements org.apache.hadoop.mapred.RecordReader<Void, ArrayWritable> {
    public static final Log LOG = LogFactory.getLog(ParquetRecordReaderWrapper.class);
    private final long splitLen;
    private RecordReader<Void, ArrayWritable> realReader;
    private ArrayWritable valueObj = null;
    private boolean firstRecord = false;
    private boolean eof = false;
    private int schemaSize;
    private final ProjectionPusher projectionPusher;

    public ParquetRecordReaderWrapper(ParquetInputFormat<ArrayWritable> newInputFormat, org.apache.hadoop.mapred.InputSplit oldSplit, JobConf oldJobConf, Reporter reporter) throws IOException, InterruptedException {
        this(newInputFormat, oldSplit, oldJobConf, reporter, new ProjectionPusher());
    }

    public ParquetRecordReaderWrapper(ParquetInputFormat<ArrayWritable> newInputFormat, org.apache.hadoop.mapred.InputSplit oldSplit, JobConf oldJobConf, Reporter reporter, ProjectionPusher pusher) throws IOException, InterruptedException {
        this.splitLen = oldSplit.getLength();
        this.projectionPusher = pusher;
        ParquetInputSplit split = this.getSplit(oldSplit, oldJobConf);
        TaskAttemptID taskAttemptID = TaskAttemptID.forName((String)oldJobConf.get("mapred.task.id"));
        if (taskAttemptID == null) {
            taskAttemptID = new TaskAttemptID();
        }
        this.setFilter(oldJobConf);
        TaskAttemptContext taskContext = ContextUtil.newTaskAttemptContext((Configuration)oldJobConf, taskAttemptID);
        if (split != null) {
            try {
                this.realReader = newInputFormat.createRecordReader((InputSplit)split, taskContext);
                this.realReader.initialize((InputSplit)split, taskContext);
                if (this.realReader.nextKeyValue()) {
                    this.firstRecord = true;
                    this.valueObj = (ArrayWritable)this.realReader.getCurrentValue();
                }
                this.eof = true;
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        } else {
            this.realReader = null;
            this.eof = true;
        }
        if (this.valueObj == null) {
            this.valueObj = new ArrayWritable(Writable.class, new Writable[this.schemaSize]);
        }
    }

    public void setFilter(JobConf conf) {
        String serializedPushdown = conf.get("hive.io.filter.expr.serialized");
        String columnNamesString = conf.get("hive.io.file.readcolumn.names");
        if (serializedPushdown == null || columnNamesString == null || serializedPushdown.isEmpty() || columnNamesString.isEmpty()) {
            return;
        }
        FilterPredicate p = SearchArgumentFactory.create(Utilities.deserializeExpression(serializedPushdown)).toFilterPredicate();
        if (p != null) {
            LOG.debug((Object)("Predicate filter for parquet is " + p.toString()));
            ParquetInputFormat.setFilterPredicate((Configuration)conf, p);
        } else {
            LOG.debug((Object)("No predicate filter can be generated for hive.io.filter.expr.serialized with the value of " + serializedPushdown));
        }
    }

    public void close() throws IOException {
        if (this.realReader != null) {
            this.realReader.close();
        }
    }

    public Void createKey() {
        return null;
    }

    public ArrayWritable createValue() {
        return this.valueObj;
    }

    public long getPos() throws IOException {
        return (long)((float)this.splitLen * this.getProgress());
    }

    public float getProgress() throws IOException {
        if (this.realReader == null) {
            return 1.0f;
        }
        try {
            return this.realReader.getProgress();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public boolean next(Void key, ArrayWritable value) throws IOException {
        if (this.eof) {
            return false;
        }
        try {
            if (this.firstRecord) {
                this.firstRecord = false;
            } else if (!this.realReader.nextKeyValue()) {
                this.eof = true;
                return false;
            }
            ArrayWritable tmpCurValue = (ArrayWritable)this.realReader.getCurrentValue();
            if (value != tmpCurValue) {
                Writable[] arrValue = value.get();
                Writable[] arrCurrent = tmpCurValue.get();
                if (value != null && arrValue.length == arrCurrent.length) {
                    System.arraycopy(arrCurrent, 0, arrValue, 0, arrCurrent.length);
                } else {
                    if (arrValue.length != arrCurrent.length) {
                        throw new IOException("DeprecatedParquetHiveInput : size of object differs. Value size :  " + arrValue.length + ", Current Object size : " + arrCurrent.length);
                    }
                    throw new IOException("DeprecatedParquetHiveInput can not support RecordReaders that don't return same key & value & value is null");
                }
            }
            return true;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    protected ParquetInputSplit getSplit(org.apache.hadoop.mapred.InputSplit oldSplit, JobConf conf) throws IOException {
        ParquetInputSplit split;
        if (oldSplit instanceof FileSplit) {
            Path finalPath = ((FileSplit)oldSplit).getPath();
            JobConf cloneJob = this.projectionPusher.pushProjectionsAndFilters(conf, finalPath.getParent());
            ParquetMetadata parquetMetadata = ParquetFileReader.readFooter((Configuration)cloneJob, finalPath);
            List<BlockMetaData> blocks = parquetMetadata.getBlocks();
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            ReadSupport.ReadContext readContext = new DataWritableReadSupport().init((Configuration)cloneJob, fileMetaData.getKeyValueMetaData(), fileMetaData.getSchema());
            this.schemaSize = MessageTypeParser.parseMessageType(readContext.getReadSupportMetadata().get("HIVE_TABLE_SCHEMA")).getFieldCount();
            ArrayList<BlockMetaData> splitGroup = new ArrayList<BlockMetaData>();
            long splitStart = ((FileSplit)oldSplit).getStart();
            long splitLength = ((FileSplit)oldSplit).getLength();
            for (BlockMetaData block : blocks) {
                long firstDataPage = block.getColumns().get(0).getFirstDataPageOffset();
                if (firstDataPage < splitStart || firstDataPage >= splitStart + splitLength) continue;
                splitGroup.add(block);
            }
            if (splitGroup.isEmpty()) {
                LOG.warn((Object)("Skipping split, could not find row group in: " + (FileSplit)oldSplit));
                split = null;
            } else {
                split = new ParquetInputSplit(finalPath, splitStart, splitLength, ((FileSplit)oldSplit).getLocations(), splitGroup, readContext.getRequestedSchema().toString(), fileMetaData.getSchema().toString(), fileMetaData.getKeyValueMetaData(), readContext.getReadSupportMetadata());
            }
        } else {
            throw new IllegalArgumentException("Unknown split type: " + oldSplit);
        }
        return split;
    }
}

