/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase.stats;

import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.hbase.stats.ColumnStatsAggregator;

public class LongColumnStatsAggregator
implements ColumnStatsAggregator {
    @Override
    public void aggregate(ColumnStatisticsObj aggregateColStats, ColumnStatisticsObj newColStats) {
        LongColumnStatsData aggregateData = aggregateColStats.getStatsData().getLongStats();
        LongColumnStatsData newData = newColStats.getStatsData().getLongStats();
        aggregateData.setLowValue(Math.min(aggregateData.getLowValue(), newData.getLowValue()));
        aggregateData.setHighValue(Math.max(aggregateData.getHighValue(), newData.getHighValue()));
        aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
        aggregateData.setNumDVs(Math.max(aggregateData.getNumDVs(), newData.getNumDVs()));
    }
}

