/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampUtils;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.IOPrepareCache;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hive.common.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorizedRowBatchCtx {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)VectorizedRowBatchCtx.class.getName());
    private String[] rowColumnNames;
    private TypeInfo[] rowColumnTypeInfos;
    private int dataColumnCount;
    private int partitionColumnCount;
    private String[] scratchColumnTypeNames;

    public VectorizedRowBatchCtx() {
    }

    public VectorizedRowBatchCtx(String[] rowColumnNames, TypeInfo[] rowColumnTypeInfos, int partitionColumnCount, String[] scratchColumnTypeNames) {
        this.rowColumnNames = rowColumnNames;
        this.rowColumnTypeInfos = rowColumnTypeInfos;
        this.partitionColumnCount = partitionColumnCount;
        this.scratchColumnTypeNames = scratchColumnTypeNames;
        this.dataColumnCount = rowColumnTypeInfos.length - partitionColumnCount;
    }

    public String[] getRowColumnNames() {
        return this.rowColumnNames;
    }

    public TypeInfo[] getRowColumnTypeInfos() {
        return this.rowColumnTypeInfos;
    }

    public int getDataColumnCount() {
        return this.dataColumnCount;
    }

    public int getPartitionColumnCount() {
        return this.partitionColumnCount;
    }

    public String[] getScratchColumnTypeNames() {
        return this.scratchColumnTypeNames;
    }

    public void init(StructObjectInspector structObjectInspector, String[] scratchColumnTypeNames) throws HiveException {
        this.rowColumnNames = VectorizedBatchUtil.columnNamesFromStructObjectInspector(structObjectInspector);
        this.rowColumnTypeInfos = VectorizedBatchUtil.typeInfosFromStructObjectInspector(structObjectInspector);
        this.partitionColumnCount = 0;
        this.dataColumnCount = this.rowColumnTypeInfos.length;
        this.scratchColumnTypeNames = scratchColumnTypeNames;
    }

    public static void getPartitionValues(VectorizedRowBatchCtx vrbCtx, Configuration hiveConf, FileSplit split, Object[] partitionValues) throws IOException {
        LinkedHashMap<String, PartitionDesc> pathToPartitionInfo = Utilities.getMapWork(hiveConf).getPathToPartitionInfo();
        PartitionDesc partDesc = HiveFileFormatUtils.getPartitionDescFromPathRecursively(pathToPartitionInfo, split.getPath(), IOPrepareCache.get().getPartitionDescMap());
        VectorizedRowBatchCtx.getPartitionValues(vrbCtx, partDesc, partitionValues);
    }

    public static void getPartitionValues(VectorizedRowBatchCtx vrbCtx, PartitionDesc partDesc, Object[] partitionValues) {
        LinkedHashMap<String, String> partSpec = partDesc.getPartSpec();
        for (int i = 0; i < vrbCtx.partitionColumnCount; ++i) {
            Object objectValue;
            if (partSpec == null) {
                objectValue = null;
            } else {
                String key = vrbCtx.rowColumnNames[vrbCtx.dataColumnCount + i];
                TypeInfo partColTypeInfo = vrbCtx.rowColumnTypeInfos[vrbCtx.dataColumnCount + i];
                ObjectInspector objectInspector = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(partColTypeInfo);
                objectValue = ObjectInspectorConverters.getConverter((ObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector, objectInspector).convert(partSpec.get(key));
                if (partColTypeInfo instanceof CharTypeInfo) {
                    objectValue = ((HiveChar)objectValue).getStrippedValue();
                }
            }
            partitionValues[i] = objectValue;
        }
    }

    public VectorizedRowBatch createVectorizedRowBatch() {
        int i;
        int totalColumnCount = this.rowColumnTypeInfos.length + this.scratchColumnTypeNames.length;
        VectorizedRowBatch result = new VectorizedRowBatch(totalColumnCount);
        LOG.info("createVectorizedRowBatch columnsToIncludeTruncated NONE");
        for (i = 0; i < this.rowColumnTypeInfos.length; ++i) {
            TypeInfo typeInfo = this.rowColumnTypeInfos[i];
            result.cols[i] = VectorizedBatchUtil.createColumnVector(typeInfo);
        }
        for (i = 0; i < this.scratchColumnTypeNames.length; ++i) {
            String typeName = this.scratchColumnTypeNames[i];
            result.cols[this.rowColumnTypeInfos.length + i] = VectorizedBatchUtil.createColumnVector(typeName);
        }
        result.setPartitionInfo(this.dataColumnCount, this.partitionColumnCount);
        result.reset();
        return result;
    }

    public VectorizedRowBatch createVectorizedRowBatch(boolean[] columnsToIncludeTruncated) {
        TypeInfo typeInfo;
        int i;
        if (columnsToIncludeTruncated == null) {
            return this.createVectorizedRowBatch();
        }
        LOG.info("createVectorizedRowBatch columnsToIncludeTruncated " + Arrays.toString(columnsToIncludeTruncated));
        int totalColumnCount = this.rowColumnTypeInfos.length + this.scratchColumnTypeNames.length;
        VectorizedRowBatch result = new VectorizedRowBatch(totalColumnCount);
        for (i = 0; i < columnsToIncludeTruncated.length; ++i) {
            if (!columnsToIncludeTruncated[i]) continue;
            typeInfo = this.rowColumnTypeInfos[i];
            result.cols[i] = VectorizedBatchUtil.createColumnVector(typeInfo);
        }
        for (i = this.dataColumnCount; i < this.dataColumnCount + this.partitionColumnCount; ++i) {
            typeInfo = this.rowColumnTypeInfos[i];
            result.cols[i] = VectorizedBatchUtil.createColumnVector(typeInfo);
        }
        for (i = 0; i < this.scratchColumnTypeNames.length; ++i) {
            String typeName = this.scratchColumnTypeNames[i];
            result.cols[this.rowColumnTypeInfos.length + i] = VectorizedBatchUtil.createColumnVector(typeName);
        }
        result.setPartitionInfo(this.dataColumnCount, this.partitionColumnCount);
        result.reset();
        return result;
    }

    public boolean[] getColumnsToIncludeTruncated(Configuration conf) {
        boolean[] columnsToIncludeTruncated = null;
        List<Integer> columnsToIncludeTruncatedList = ColumnProjectionUtils.getReadColumnIDs(conf);
        if (columnsToIncludeTruncatedList != null && columnsToIncludeTruncatedList.size() > 0) {
            boolean[] columnsToInclude = new boolean[this.dataColumnCount];
            Arrays.fill(columnsToInclude, false);
            for (int columnNum : columnsToIncludeTruncatedList) {
                if (columnNum >= this.dataColumnCount) continue;
                columnsToInclude[columnNum] = true;
            }
            int highestWantedColumnNum = -1;
            for (int i = this.dataColumnCount - 1; i >= 0; --i) {
                if (!columnsToInclude[i]) continue;
                highestWantedColumnNum = i;
                break;
            }
            if (highestWantedColumnNum == -1) {
                throw new RuntimeException("No columns to include?");
            }
            int newColumnCount = highestWantedColumnNum + 1;
            columnsToIncludeTruncated = newColumnCount == this.dataColumnCount ? columnsToInclude : Arrays.copyOf(columnsToInclude, newColumnCount);
        }
        return columnsToIncludeTruncated;
    }

    public void addPartitionColsToBatch(VectorizedRowBatch batch, Object[] partitionValues) {
        if (partitionValues != null) {
            block16: for (int i = 0; i < this.partitionColumnCount; ++i) {
                Object value = partitionValues[i];
                int colIndex = this.dataColumnCount + i;
                String partitionColumnName = this.rowColumnNames[colIndex];
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)this.rowColumnTypeInfos[colIndex];
                switch (primitiveTypeInfo.getPrimitiveCategory()) {
                    case BOOLEAN: {
                        LongColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            lcv.noNulls = false;
                            lcv.isNull[0] = true;
                            lcv.isRepeating = true;
                            continue block16;
                        }
                        lcv.fill((Boolean)value == true ? 1L : 0L);
                        lcv.isNull[0] = false;
                        continue block16;
                    }
                    case BYTE: {
                        LongColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            lcv.noNulls = false;
                            lcv.isNull[0] = true;
                            lcv.isRepeating = true;
                            continue block16;
                        }
                        lcv.fill(((Byte)value).byteValue());
                        lcv.isNull[0] = false;
                        continue block16;
                    }
                    case SHORT: {
                        LongColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            lcv.noNulls = false;
                            lcv.isNull[0] = true;
                            lcv.isRepeating = true;
                            continue block16;
                        }
                        lcv.fill(((Short)value).shortValue());
                        lcv.isNull[0] = false;
                        continue block16;
                    }
                    case INT: {
                        LongColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            lcv.noNulls = false;
                            lcv.isNull[0] = true;
                            lcv.isRepeating = true;
                            continue block16;
                        }
                        lcv.fill(((Integer)value).intValue());
                        lcv.isNull[0] = false;
                        continue block16;
                    }
                    case LONG: {
                        LongColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            lcv.noNulls = false;
                            lcv.isNull[0] = true;
                            lcv.isRepeating = true;
                            continue block16;
                        }
                        lcv.fill((Long)value);
                        lcv.isNull[0] = false;
                        continue block16;
                    }
                    case DATE: {
                        LongColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            lcv.noNulls = false;
                            lcv.isNull[0] = true;
                            lcv.isRepeating = true;
                            continue block16;
                        }
                        lcv.fill(DateWritable.dateToDays((Date)value));
                        lcv.isNull[0] = false;
                        continue block16;
                    }
                    case TIMESTAMP: {
                        LongColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            lcv.noNulls = false;
                            lcv.isNull[0] = true;
                            lcv.isRepeating = true;
                            continue block16;
                        }
                        lcv.fill(TimestampUtils.getTimeNanoSec((Timestamp)value));
                        lcv.isNull[0] = false;
                        continue block16;
                    }
                    case INTERVAL_YEAR_MONTH: {
                        LongColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            lcv.noNulls = false;
                            lcv.isNull[0] = true;
                            lcv.isRepeating = true;
                        } else {
                            lcv.fill(((HiveIntervalYearMonth)value).getTotalMonths());
                            lcv.isNull[0] = false;
                        }
                    }
                    case INTERVAL_DAY_TIME: {
                        LongColumnVector lcv = (LongColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            lcv.noNulls = false;
                            lcv.isNull[0] = true;
                            lcv.isRepeating = true;
                        } else {
                            lcv.fill(DateUtils.getIntervalDayTimeTotalNanos((HiveIntervalDayTime)value));
                            lcv.isNull[0] = false;
                        }
                    }
                    case FLOAT: {
                        DoubleColumnVector dcv = (DoubleColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            dcv.noNulls = false;
                            dcv.isNull[0] = true;
                            dcv.isRepeating = true;
                            continue block16;
                        }
                        dcv.fill(((Float)value).floatValue());
                        dcv.isNull[0] = false;
                        continue block16;
                    }
                    case DOUBLE: {
                        DoubleColumnVector dcv = (DoubleColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            dcv.noNulls = false;
                            dcv.isNull[0] = true;
                            dcv.isRepeating = true;
                            continue block16;
                        }
                        dcv.fill((Double)value);
                        dcv.isNull[0] = false;
                        continue block16;
                    }
                    case DECIMAL: {
                        DecimalColumnVector dv = (DecimalColumnVector)batch.cols[colIndex];
                        if (value == null) {
                            dv.noNulls = false;
                            dv.isNull[0] = true;
                            dv.isRepeating = true;
                            continue block16;
                        }
                        HiveDecimal hd = (HiveDecimal)value;
                        dv.set(0, hd);
                        dv.isRepeating = true;
                        dv.isNull[0] = false;
                        continue block16;
                    }
                    case BINARY: {
                        BytesColumnVector bcv = (BytesColumnVector)batch.cols[colIndex];
                        byte[] bytes = (byte[])value;
                        if (bytes == null) {
                            bcv.noNulls = false;
                            bcv.isNull[0] = true;
                            bcv.isRepeating = true;
                            continue block16;
                        }
                        bcv.fill(bytes);
                        bcv.isNull[0] = false;
                        continue block16;
                    }
                    case STRING: 
                    case CHAR: 
                    case VARCHAR: {
                        BytesColumnVector bcv = (BytesColumnVector)batch.cols[colIndex];
                        String sVal = value.toString();
                        if (sVal == null) {
                            bcv.noNulls = false;
                            bcv.isNull[0] = true;
                            bcv.isRepeating = true;
                            continue block16;
                        }
                        bcv.fill(sVal.getBytes());
                        bcv.isNull[0] = false;
                        continue block16;
                    }
                    default: {
                        throw new RuntimeException("Unable to recognize the partition type " + (Object)((Object)primitiveTypeInfo.getPrimitiveCategory()) + " for column " + partitionColumnName);
                    }
                }
            }
        }
    }

    public final boolean isPartitionCol(int colNum) {
        return colNum >= this.dataColumnCount && colNum < this.rowColumnTypeInfos.length;
    }
}

