/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.ppr;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.hive.metastore.Metastore;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.orc.OrcProto;
import org.apache.orc.StripeInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionExpressionForMetastore
implements PartitionExpressionProxy {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionExpressionForMetastore.class);

    @Override
    public String convertExprToFilter(byte[] exprBytes) throws MetaException {
        return this.deserializeExpr(exprBytes).getExprString();
    }

    @Override
    public boolean filterPartitionsByExpr(List<String> partColumnNames, List<PrimitiveTypeInfo> partColumnTypeInfos, byte[] exprBytes, String defaultPartitionName, List<String> partitionNames) throws MetaException {
        ExprNodeGenericFuncDesc expr = this.deserializeExpr(exprBytes);
        try {
            long startTime = System.nanoTime();
            long len = partitionNames.size();
            boolean result = PartitionPruner.prunePartitionNames(partColumnNames, partColumnTypeInfos, expr, defaultPartitionName, partitionNames);
            double timeMs = (double)(System.nanoTime() - startTime) / 1000000.0;
            LOG.debug("Pruning " + len + " partition names took " + timeMs + "ms");
            return result;
        }
        catch (HiveException ex) {
            LOG.error("Failed to apply the expression", (Throwable)ex);
            throw new MetaException(ex.getMessage());
        }
    }

    private ExprNodeGenericFuncDesc deserializeExpr(byte[] exprBytes) throws MetaException {
        ExprNodeGenericFuncDesc expr = null;
        try {
            expr = SerializationUtilities.deserializeExpressionFromKryo(exprBytes);
        }
        catch (Exception ex) {
            LOG.error("Failed to deserialize the expression", (Throwable)ex);
            throw new MetaException(ex.getMessage());
        }
        if (expr == null) {
            throw new MetaException("Failed to deserialize expression - ExprNodeDesc not present");
        }
        return expr;
    }

    @Override
    public SearchArgument createSarg(byte[] expr) {
        return ConvertAstToSearchArg.create(expr);
    }

    @Override
    public ByteBuffer applySargToFileMetadata(SearchArgument sarg, ByteBuffer byteBuffer) throws IOException {
        ReaderImpl.FooterInfo fi = ReaderImpl.extractMetaInfoFromFooter(byteBuffer, null);
        OrcProto.Footer footer = fi.getFooter();
        int stripeCount = footer.getStripesCount();
        boolean[] result = OrcInputFormat.pickStripesViaTranslatedSarg(sarg, fi.getFileMetaInfo().getWriterVersion(), footer.getTypesList(), fi.getMetadata(), stripeCount);
        Metastore.SplitInfos.Builder sb = Metastore.SplitInfos.newBuilder();
        List<StripeInformation> stripes = fi.getStripes();
        boolean isEliminated = true;
        for (int i = 0; i < result.length; ++i) {
            if (result != null && !result[i]) continue;
            isEliminated = false;
            StripeInformation si = stripes.get(i);
            sb.addInfos(Metastore.SplitInfo.newBuilder().setIndex(i).setOffset(si.getOffset()).setLength(si.getLength()));
        }
        return isEliminated ? null : ByteBuffer.wrap(sb.build().toByteArray());
    }
}

