/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.ptf;

import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;

public class WindowFrameDef {
    private BoundaryDef start;
    private BoundaryDef end;
    private final int windowSize;

    public WindowFrameDef(BoundaryDef start, BoundaryDef end) {
        this.start = start;
        this.end = end;
        this.windowSize = start.getDirection() == end.getDirection() ? Math.abs(end.getAmt() - start.getAmt()) + 1 : end.getAmt() + start.getAmt() + 1;
    }

    public BoundaryDef getStart() {
        return this.start;
    }

    public BoundaryDef getEnd() {
        return this.end;
    }

    public boolean isStartUnbounded() {
        return this.start.isUnbounded();
    }

    public boolean isEndUnbounded() {
        return this.end.isUnbounded();
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public String toString() {
        return this.start + "~" + this.end;
    }
}

