/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions.CssMenuItem;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.serviceactions.ServiceActionUtil;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class TertiaryActionsPanel
extends Panel {
    @Inject
    private PageClassRegistry pageClassRegistry;

    public TertiaryActionsPanel(String id, List<CssMenuItem> menuItems) {
        super(id);
        this.addLogoutLink((MarkupContainer)this);
        List<CssMenuItem> subMenuItems = this.flatten(menuItems);
        ListView<CssMenuItem> subMenuItemsView = new ListView<CssMenuItem>("subMenuItems", subMenuItems){

            protected void populateItem(ListItem<CssMenuItem> listItem) {
                CssMenuItem subMenuItem = (CssMenuItem)listItem.getModelObject();
                if (subMenuItem.hasSubMenuItems()) {
                    TertiaryActionsPanel.this.addFolderItem(subMenuItem, (ListItem<CssMenuItem>)listItem);
                } else {
                    ServiceActionUtil.addLeafItem(subMenuItem, listItem, (MarkupContainer)TertiaryActionsPanel.this);
                }
            }
        };
        WebComponent divider = new WebComponent("divider", (ListView)subMenuItemsView, subMenuItems){
            final /* synthetic */ ListView val$subMenuItemsView;
            final /* synthetic */ List val$subMenuItems;
            {
                this.val$subMenuItemsView = listView;
                this.val$subMenuItems = list;
                super(x0);
            }

            protected void onConfigure() {
                super.onConfigure();
                this.val$subMenuItemsView.configure();
                this.setVisible(!this.val$subMenuItems.isEmpty());
            }
        };
        this.add(new Component[]{subMenuItemsView, divider});
    }

    protected List<CssMenuItem> flatten(List<CssMenuItem> menuItems) {
        ArrayList subMenuItems = Lists.newArrayList();
        for (CssMenuItem menuItem : menuItems) {
            subMenuItems.addAll(menuItem.getSubMenuItems());
        }
        return subMenuItems;
    }

    private void addLogoutLink(MarkupContainer themeDiv) {
        Link logoutLink = new Link("logoutLink"){

            public void onClick() {
                this.getSession().invalidate();
                this.setResponsePage(TertiaryActionsPanel.this.getSignInPage());
            }
        };
        themeDiv.add(new Component[]{logoutLink});
    }

    private Class<? extends Page> getSignInPage() {
        return this.pageClassRegistry.getPageClass(PageType.SIGN_IN);
    }

    private void addFolderItem(CssMenuItem subMenuItem, ListItem<CssMenuItem> listItem) {
        TertiaryActionsPanel parent = this;
        ServiceActionUtil.addFolderItem(subMenuItem, listItem, (MarkupContainer)parent, ServiceActionUtil.SeparatorStrategy.WITHOUT_SEPARATORS);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new CssResourceReference(TertiaryActionsPanel.class, "TertiaryActionsPanel.css")));
    }
}

