/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import com.google.common.collect.Lists;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import java.io.Serializable;
import java.util.List;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.labelat.LabelAtFacet;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksPanel;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarModelSubscriber;
import org.apache.isis.viewer.wicket.ui.components.scalars.TextFieldValueModel;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.feedback.ComponentFeedbackMessageFilter;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class ScalarPanelAbstract
extends PanelAbstract<ScalarModel>
implements TextFieldValueModel.ScalarModelProvider {
    private static final long serialVersionUID = 1L;
    protected static final String ID_SCALAR_IF_REGULAR = "scalarIfRegular";
    protected static final String ID_SCALAR_NAME = "scalarName";
    protected static final String ID_SCALAR_VALUE = "scalarValue";
    protected static final String ID_SCALAR_IF_COMPACT = "scalarIfCompact";
    private static final String ID_ASSOCIATED_ACTION_LINKS_BELOW = "associatedActionLinksBelow";
    private static final String ID_ASSOCIATED_ACTION_LINKS_RIGHT = "associatedActionLinksRight";
    private static final String ID_FEEDBACK = "feedback";
    protected Component componentIfCompact;
    private Component componentIfRegular;
    protected final ScalarModel scalarModel;
    private boolean guiForceBuilt = false;
    private final List<ScalarModelSubscriber> subscribers = Lists.newArrayList();

    public ScalarPanelAbstract(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
        this.scalarModel = scalarModel;
    }

    protected Fragment getCompactFragment(CompactType type) {
        Fragment compactFragment;
        switch (type) {
            case INPUT_CHECKBOX: {
                compactFragment = new Fragment(ID_SCALAR_IF_COMPACT, "compactAsInputCheckbox", (MarkupContainer)this);
                break;
            }
            default: {
                compactFragment = new Fragment(ID_SCALAR_IF_COMPACT, "compactAsSpan", (MarkupContainer)this);
            }
        }
        return compactFragment;
    }

    protected Rendering getRendering() {
        return Rendering.renderingFor(((ScalarModel)this.getModel()).getRenderingHint());
    }

    protected Component getLabelForCompact() {
        return this.componentIfCompact;
    }

    public Component getComponentForRegular() {
        return this.componentIfRegular;
    }

    public void forceBuildGui() {
        this.buildGui();
        this.guiForceBuilt = true;
    }

    protected void onBeforeRender() {
        ScalarModel scalarModel;
        if (!this.hasBeenRendered() || this.alwaysRebuildGui()) {
            if (!this.guiForceBuilt) {
                this.buildGui();
            } else {
                this.guiForceBuilt = false;
            }
        }
        if ((scalarModel = (ScalarModel)this.getModel()).isViewMode()) {
            this.onBeforeRenderWhenViewMode();
        } else {
            String disableReasonIfAny = scalarModel.disable(this.getRendering().getWhere());
            if (disableReasonIfAny != null) {
                this.onBeforeRenderWhenDisabled(disableReasonIfAny);
            } else {
                this.onBeforeRenderWhenEnabled();
            }
        }
        super.onBeforeRender();
    }

    protected boolean alwaysRebuildGui() {
        return false;
    }

    private void buildGui() {
        this.componentIfCompact = this.addComponentForCompact();
        this.componentIfRegular = this.addComponentForRegular();
        this.getRendering().buildGui(this);
        this.addCssForMetaModel();
        if (!this.subscribers.isEmpty()) {
            this.addFormComponentBehavior((Behavior)new ScalarUpdatingBehavior());
        }
    }

    protected abstract void addFormComponentBehavior(Behavior var1);

    private void addCssForMetaModel() {
        ScalarModel model;
        CssClassFacet facet;
        String cssForMetaModel = ((ScalarModel)this.getModel()).getLongName();
        if (cssForMetaModel != null) {
            this.add(new Behavior[]{new AttributeAppender("class", (IModel)Model.of((Serializable)((Object)cssForMetaModel)), " ")});
        }
        if ((facet = (CssClassFacet)(model = (ScalarModel)this.getModel()).getFacet(CssClassFacet.class)) != null) {
            ObjectAdapter parentAdapter = model.getParentObjectAdapterMemento().getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK);
            String cssClass = facet.cssClass(parentAdapter);
            CssClassAppender.appendCssClassTo((MarkupContainer)this, cssClass);
        }
    }

    protected abstract MarkupContainer addComponentForRegular();

    protected abstract Component addComponentForCompact();

    protected void addFeedbackTo(MarkupContainer markupContainer, Component component) {
        markupContainer.addOrReplace(new Component[]{new NotificationPanel(ID_FEEDBACK, component, (IFeedbackMessageFilter)new ComponentFeedbackMessageFilter(component))});
    }

    protected void onBeforeRenderWhenViewMode() {
    }

    protected void onBeforeRenderWhenDisabled(String disableReason) {
    }

    protected void onBeforeRenderWhenEnabled() {
    }

    protected void addPositioningCssTo(MarkupContainer markupContainer, List<LinkAndLabel> entityActionLinks) {
        CssClassAppender.appendCssClassTo(markupContainer, ScalarPanelAbstract.determinePropParamLayoutCss((ScalarModel)this.getModel()));
        CssClassAppender.appendCssClassTo(markupContainer, ScalarPanelAbstract.determineActionLayoutPositioningCss(entityActionLinks));
    }

    protected void addEntityActionLinksBelowAndRight(MarkupContainer labelIfRegular, List<LinkAndLabel> entityActions) {
        List entityActionsBelow = LinkAndLabel.positioned(entityActions, (ActionLayout.Position)ActionLayout.Position.BELOW);
        AdditionalLinksPanel.addAdditionalLinks(labelIfRegular, ID_ASSOCIATED_ACTION_LINKS_BELOW, entityActionsBelow, AdditionalLinksPanel.Style.INLINE_LIST);
        List entityActionsRight = LinkAndLabel.positioned(entityActions, (ActionLayout.Position)ActionLayout.Position.RIGHT);
        AdditionalLinksPanel.addAdditionalLinks(labelIfRegular, ID_ASSOCIATED_ACTION_LINKS_RIGHT, entityActionsRight, AdditionalLinksPanel.Style.DROPDOWN);
    }

    private static String determinePropParamLayoutCss(ScalarModel model) {
        LabelAtFacet facet = (LabelAtFacet)model.getFacet(LabelAtFacet.class);
        if (facet != null) {
            switch (facet.label()) {
                case LEFT: {
                    return "label-left";
                }
                case RIGHT: {
                    return "label-right";
                }
                case NONE: {
                    return "label-none";
                }
                case TOP: {
                    return "label-top";
                }
            }
        }
        return "label-left";
    }

    private static String determineActionLayoutPositioningCss(List<LinkAndLabel> entityActionLinks) {
        boolean actionsPositionedOnRight = ScalarPanelAbstract.hasActionsPositionedOn(entityActionLinks, ActionLayout.Position.RIGHT);
        return actionsPositionedOnRight ? "actions-right" : null;
    }

    private static boolean hasActionsPositionedOn(List<LinkAndLabel> entityActionLinks, ActionLayout.Position position) {
        for (LinkAndLabel entityActionLink : entityActionLinks) {
            if (entityActionLink.getPosition() != position) continue;
            return true;
        }
        return false;
    }

    public void notifyOnChange(ScalarModelSubscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    public boolean updateChoices(ObjectAdapter[] pendingArguments) {
        return false;
    }

    protected DeploymentType getDeploymentType() {
        return IsisContext.getDeploymentType();
    }

    protected class ScalarUpdatingBehavior
    extends AjaxFormComponentUpdatingBehavior {
        private static final long serialVersionUID = 1L;

        private ScalarUpdatingBehavior() {
            super("change");
        }

        protected void onUpdate(AjaxRequestTarget target) {
            for (ScalarModelSubscriber subscriber : ScalarPanelAbstract.this.subscribers) {
                subscriber.onUpdate(target, ScalarPanelAbstract.this);
            }
        }

        protected void onError(AjaxRequestTarget target, RuntimeException e) {
            super.onError(target, e);
            for (ScalarModelSubscriber subscriber : ScalarPanelAbstract.this.subscribers) {
                subscriber.onError(target, ScalarPanelAbstract.this);
            }
        }
    }

    public static enum Rendering {
        COMPACT{

            @Override
            public String getLabelCaption(LabeledWebMarkupContainer labeledContainer) {
                return "";
            }

            @Override
            public void buildGui(ScalarPanelAbstract panel) {
                panel.getComponentForRegular().setVisible(false);
            }

            @Override
            public Where getWhere() {
                return Where.PARENTED_TABLES;
            }
        }
        ,
        REGULAR{

            @Override
            public String getLabelCaption(LabeledWebMarkupContainer labeledContainer) {
                return (String)labeledContainer.getLabel().getObject();
            }

            @Override
            public void buildGui(ScalarPanelAbstract panel) {
                panel.getLabelForCompact().setVisible(false);
            }

            @Override
            public Where getWhere() {
                return Where.OBJECT_FORMS;
            }
        };


        public abstract String getLabelCaption(LabeledWebMarkupContainer var1);

        public abstract void buildGui(ScalarPanelAbstract var1);

        public abstract Where getWhere();

        private static Rendering renderingFor(EntityModel.RenderingHint renderingHint) {
            return renderingHint.isInTable() ? COMPACT : REGULAR;
        }
    }

    public static enum CompactType {
        INPUT_CHECKBOX,
        SPAN;

    }
}

