/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.widgets.buttons;

import java.io.Serializable;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.buttons.ContainedButtonPanel;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;

public class ToggleButtonsPanel
extends PanelAbstract<EntityModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_BUTTON_1 = "button1";
    private static final String ID_BUTTON_2 = "button2";
    private boolean flag = false;
    private Toggler toggler;
    private ContainedButtonPanel button1;
    private ContainedButtonPanel button2;

    public ToggleButtonsPanel(String id, String button1Caption, String button2Caption) {
        super(id, null);
        this.buildGui(button1Caption, button2Caption);
        this.onInit();
    }

    private void buildGui(String button1Caption, String button2Caption) {
        this.button1 = new ContainedButtonPanel(ID_BUTTON_1, button1Caption){
            private static final long serialVersionUID = 1L;

            @Override
            public void onSubmit() {
                ToggleButtonsPanel.this.toggler.toggle();
            }
        };
        this.addOrReplace(new Component[]{this.button1});
        this.button2 = new ContainedButtonPanel(ID_BUTTON_2, button2Caption){
            private static final long serialVersionUID = 1L;

            @Override
            public void onSubmit() {
                ToggleButtonsPanel.this.toggler.toggle();
            }
        };
        this.toggler = new Toggler((Component)this.button1, (Component)this.button2);
        this.addOrReplace(new Component[]{this.button2});
    }

    public void addComponentToRerender(Component ... components) {
        for (Component component : components) {
            this.button1.addComponentToRerender(component);
            this.button2.addComponentToRerender(component);
        }
    }

    protected void onInit() {
    }

    protected void onButton1() {
    }

    protected void onButton2() {
    }

    protected final void hideButton1() {
        this.flag = true;
        this.toggler.syncButtonVisibility();
    }

    protected final void hideButton2() {
        this.flag = false;
        this.toggler.syncButtonVisibility();
    }

    private class Toggler
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Component component1;
        private final Component component2;

        public Toggler(Component component1, Component component2) {
            this.component1 = component1;
            this.component2 = component2;
            this.syncButtonVisibility();
        }

        public void toggle() {
            this.fireHooks();
            this.syncButtonVisibility();
        }

        private void fireHooks() {
            ToggleButtonsPanel.this.flag = !ToggleButtonsPanel.this.flag;
            if (ToggleButtonsPanel.this.flag) {
                ToggleButtonsPanel.this.onButton1();
            } else {
                ToggleButtonsPanel.this.onButton2();
            }
        }

        private void syncButtonVisibility() {
            this.component1.setVisible(!ToggleButtonsPanel.this.flag);
            this.component2.setVisible(ToggleButtonsPanel.this.flag);
        }
    }
}

