/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.metadata.storage;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.server.log.remote.metadata.storage.FileBasedRemoteLogMetadataCache;
import org.apache.kafka.server.log.remote.metadata.storage.RemoteLogMetadataCache;
import org.apache.kafka.server.log.remote.metadata.storage.RemotePartitionMetadataEventHandler;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadataUpdate;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteMetadata;
import org.apache.kafka.server.log.remote.storage.RemotePartitionDeleteState;
import org.apache.kafka.server.log.remote.storage.RemoteResourceNotFoundException;
import org.apache.kafka.server.log.remote.storage.RemoteStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemotePartitionMetadataStore
extends RemotePartitionMetadataEventHandler
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(RemotePartitionMetadataStore.class);
    private final Path logDir;
    private Map<TopicIdPartition, RemotePartitionDeleteMetadata> idToPartitionDeleteMetadata = new ConcurrentHashMap<TopicIdPartition, RemotePartitionDeleteMetadata>();
    private Map<TopicIdPartition, FileBasedRemoteLogMetadataCache> idToRemoteLogMetadataCache = new ConcurrentHashMap<TopicIdPartition, FileBasedRemoteLogMetadataCache>();

    public RemotePartitionMetadataStore(Path logDir) {
        this.logDir = logDir;
    }

    @Override
    public void handleRemoteLogSegmentMetadata(RemoteLogSegmentMetadata remoteLogSegmentMetadata) {
        log.debug("Adding remote log segment : [{}]", (Object)remoteLogSegmentMetadata);
        RemoteLogSegmentId remoteLogSegmentId = remoteLogSegmentMetadata.remoteLogSegmentId();
        TopicIdPartition topicIdPartition = remoteLogSegmentId.topicIdPartition();
        RemoteLogMetadataCache remoteLogMetadataCache = this.idToRemoteLogMetadataCache.get(topicIdPartition);
        if (remoteLogMetadataCache == null) {
            throw new IllegalStateException("No partition metadata found for : " + topicIdPartition);
        }
        remoteLogMetadataCache.addCopyInProgressSegment(remoteLogSegmentMetadata);
    }

    private Path partitionLogDirectory(TopicPartition topicPartition) {
        return new File(this.logDir.toFile(), topicPartition.topic() + "-" + topicPartition.partition()).toPath();
    }

    @Override
    public void handleRemoteLogSegmentMetadataUpdate(RemoteLogSegmentMetadataUpdate rlsmUpdate) {
        log.debug("Updating remote log segment: [{}]", (Object)rlsmUpdate);
        RemoteLogSegmentId remoteLogSegmentId = rlsmUpdate.remoteLogSegmentId();
        TopicIdPartition topicIdPartition = remoteLogSegmentId.topicIdPartition();
        RemoteLogMetadataCache remoteLogMetadataCache = this.idToRemoteLogMetadataCache.get(topicIdPartition);
        if (remoteLogMetadataCache != null) {
            try {
                remoteLogMetadataCache.updateRemoteLogSegmentMetadata(rlsmUpdate);
            }
            catch (RemoteResourceNotFoundException e) {
                log.warn("Error occurred while updating the remote log segment.", (Throwable)e);
            }
        } else {
            throw new IllegalStateException("No partition metadata found for : " + topicIdPartition);
        }
    }

    @Override
    public void handleRemotePartitionDeleteMetadata(RemotePartitionDeleteMetadata remotePartitionDeleteMetadata) {
        log.debug("Received partition delete state with: [{}]", (Object)remotePartitionDeleteMetadata);
        TopicIdPartition topicIdPartition = remotePartitionDeleteMetadata.topicIdPartition();
        this.idToPartitionDeleteMetadata.put(topicIdPartition, remotePartitionDeleteMetadata);
        if (remotePartitionDeleteMetadata.state() == RemotePartitionDeleteState.DELETE_PARTITION_FINISHED) {
            this.idToRemoteLogMetadataCache.remove(topicIdPartition);
            this.idToPartitionDeleteMetadata.remove(topicIdPartition);
        }
    }

    @Override
    public void syncLogMetadataSnapshot(TopicIdPartition topicIdPartition, int metadataPartition, Long metadataPartitionOffset) throws IOException {
        RemotePartitionDeleteMetadata partitionDeleteMetadata = this.idToPartitionDeleteMetadata.get(topicIdPartition);
        if (partitionDeleteMetadata != null) {
            log.info("Skipping syncing of metadata snapshot as remote partition [{}] is with state: [{}] ", (Object)topicIdPartition, (Object)partitionDeleteMetadata);
        } else {
            FileBasedRemoteLogMetadataCache remoteLogMetadataCache = this.idToRemoteLogMetadataCache.get(topicIdPartition);
            if (remoteLogMetadataCache != null) {
                remoteLogMetadataCache.flushToFile(metadataPartition, metadataPartitionOffset);
            }
        }
    }

    @Override
    public void clearTopicPartition(TopicIdPartition topicIdPartition) {
        this.idToRemoteLogMetadataCache.remove(topicIdPartition);
    }

    public Iterator<RemoteLogSegmentMetadata> listRemoteLogSegments(TopicIdPartition topicIdPartition) throws RemoteStorageException {
        Objects.requireNonNull(topicIdPartition, "topicIdPartition can not be null");
        return this.getRemoteLogMetadataCache(topicIdPartition).listAllRemoteLogSegments();
    }

    public Iterator<RemoteLogSegmentMetadata> listRemoteLogSegments(TopicIdPartition topicIdPartition, int leaderEpoch) throws RemoteStorageException {
        Objects.requireNonNull(topicIdPartition, "topicIdPartition can not be null");
        return this.getRemoteLogMetadataCache(topicIdPartition).listRemoteLogSegments(leaderEpoch);
    }

    private FileBasedRemoteLogMetadataCache getRemoteLogMetadataCache(TopicIdPartition topicIdPartition) throws RemoteResourceNotFoundException {
        FileBasedRemoteLogMetadataCache remoteLogMetadataCache = this.idToRemoteLogMetadataCache.get(topicIdPartition);
        if (remoteLogMetadataCache == null) {
            throw new RemoteResourceNotFoundException("No resource found for partition: " + topicIdPartition);
        }
        return remoteLogMetadataCache;
    }

    public Optional<RemoteLogSegmentMetadata> remoteLogSegmentMetadata(TopicIdPartition topicIdPartition, long offset, int epochForOffset) throws RemoteStorageException {
        Objects.requireNonNull(topicIdPartition, "topicIdPartition can not be null");
        return this.getRemoteLogMetadataCache(topicIdPartition).remoteLogSegmentMetadata(epochForOffset, offset);
    }

    public Optional<Long> highestLogOffset(TopicIdPartition topicIdPartition, int leaderEpoch) throws RemoteStorageException {
        Objects.requireNonNull(topicIdPartition, "topicIdPartition can not be null");
        return this.getRemoteLogMetadataCache(topicIdPartition).highestOffsetForEpoch(leaderEpoch);
    }

    @Override
    public void close() throws IOException {
        log.info("Clearing the entries from the store.");
        this.idToPartitionDeleteMetadata = Collections.emptyMap();
        this.idToRemoteLogMetadataCache = Collections.emptyMap();
    }

    public void maybeLoadPartition(TopicIdPartition partition) {
        this.idToRemoteLogMetadataCache.computeIfAbsent(partition, topicIdPartition -> new FileBasedRemoteLogMetadataCache((TopicIdPartition)topicIdPartition, this.partitionLogDirectory(topicIdPartition.topicPartition())));
    }
}

