/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import java.util.Map;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;

public class ProcessorNodeMetrics {
    private static final String RATE_DESCRIPTION_PREFIX = "The average number of ";
    private static final String RATE_DESCRIPTION_SUFFIX = " per second";
    private static final String SUPPRESSION_EMIT = "suppression-emit";
    private static final String SUPPRESSION_EMIT_DESCRIPTION = "emitted records from the suppression buffer";
    private static final String SUPPRESSION_EMIT_TOTAL_DESCRIPTION = "The total number of emitted records from the suppression buffer";
    private static final String SUPPRESSION_EMIT_RATE_DESCRIPTION = "The average number of emitted records from the suppression buffer per second";
    private static final String IDEMPOTENT_UPDATE_SKIP = "idempotent-update-skip";
    private static final String IDEMPOTENT_UPDATE_SKIP_DESCRIPTION = "skipped idempotent updates";
    private static final String IDEMPOTENT_UPDATE_SKIP_TOTAL_DESCRIPTION = "The total number of skipped idempotent updates";
    private static final String IDEMPOTENT_UPDATE_SKIP_RATE_DESCRIPTION = "The average number of skipped idempotent updates per second";
    private static final String PROCESS = "process";
    private static final String PROCESS_DESCRIPTION = "calls to process";
    private static final String PROCESS_TOTAL_DESCRIPTION = "The total number of calls to process";
    private static final String PROCESS_RATE_DESCRIPTION = "The average number of calls to process per second";
    private static final String FORWARD = "forward";
    private static final String FORWARD_DESCRIPTION = "calls to forward";
    private static final String FORWARD_TOTAL_DESCRIPTION = "The total number of calls to forward";
    private static final String FORWARD_RATE_DESCRIPTION = "The average number of calls to forward per second";
    private static final String EMITTED_RECORDS = "window-aggregate-final-emit";
    private static final String EMITTED_RECORDS_DESCRIPTION = "emit final records";
    private static final String EMITTED_RECORDS_TOTAL_DESCRIPTION = "The total number of emit final records";
    private static final String EMITTED_RECORDS_RATE_DESCRIPTION = "The average number of emit final records per second";
    private static final String EMIT_FINAL_LATENCY = "window-aggregate-final-emit-latency";
    private static final String EMIT_FINAL_DESCRIPTION = "calls to emit final";
    private static final String EMIT_FINAL_AVG_LATENCY_DESCRIPTION = "The average latency of calls to emit final";
    private static final String EMIT_FINAL_MAX_LATENCY_DESCRIPTION = "The maximum latency of calls to emit final";

    private ProcessorNodeMetrics() {
    }

    public static Sensor suppressionEmitSensor(String threadId, String taskId, String processorNodeId, StreamsMetricsImpl streamsMetrics) {
        return ProcessorNodeMetrics.throughputSensor(threadId, taskId, processorNodeId, SUPPRESSION_EMIT, SUPPRESSION_EMIT_RATE_DESCRIPTION, SUPPRESSION_EMIT_TOTAL_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics, new Sensor[0]);
    }

    public static Sensor skippedIdempotentUpdatesSensor(String threadId, String taskId, String processorNodeId, StreamsMetricsImpl streamsMetrics) {
        return ProcessorNodeMetrics.throughputSensor(threadId, taskId, processorNodeId, IDEMPOTENT_UPDATE_SKIP, IDEMPOTENT_UPDATE_SKIP_RATE_DESCRIPTION, IDEMPOTENT_UPDATE_SKIP_TOTAL_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics, new Sensor[0]);
    }

    public static Sensor processAtSourceSensor(String threadId, String taskId, String processorNodeId, StreamsMetricsImpl streamsMetrics) {
        Sensor parentSensor = streamsMetrics.taskLevelSensor(threadId, taskId, PROCESS, Sensor.RecordingLevel.DEBUG, new Sensor[0]);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(parentSensor, "stream-task-metrics", streamsMetrics.taskLevelTagMap(threadId, taskId), PROCESS, PROCESS_RATE_DESCRIPTION, PROCESS_TOTAL_DESCRIPTION);
        return ProcessorNodeMetrics.throughputSensor(threadId, taskId, processorNodeId, PROCESS, PROCESS_RATE_DESCRIPTION, PROCESS_TOTAL_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics, parentSensor);
    }

    public static Sensor forwardSensor(String threadId, String taskId, String processorNodeId, StreamsMetricsImpl streamsMetrics) {
        Sensor parentSensor = ProcessorNodeMetrics.throughputParentSensor(threadId, taskId, FORWARD, FORWARD_RATE_DESCRIPTION, FORWARD_TOTAL_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics);
        return ProcessorNodeMetrics.throughputSensor(threadId, taskId, processorNodeId, FORWARD, FORWARD_RATE_DESCRIPTION, FORWARD_TOTAL_DESCRIPTION, Sensor.RecordingLevel.DEBUG, streamsMetrics, parentSensor);
    }

    public static Sensor e2ELatencySensor(String threadId, String taskId, String processorNodeId, StreamsMetricsImpl streamsMetrics) {
        String sensorName = processorNodeId + "-" + "record-e2e-latency";
        Sensor sensor = streamsMetrics.nodeLevelSensor(threadId, taskId, processorNodeId, sensorName, Sensor.RecordingLevel.INFO, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.nodeLevelTagMap(threadId, taskId, processorNodeId);
        StreamsMetricsImpl.addAvgAndMinAndMaxToSensor(sensor, "stream-processor-node-metrics", tagMap, "record-e2e-latency", "The average end-to-end latency of a record, measuring by comparing the record timestamp with the system time when it has been fully processed by the node", "The minimum end-to-end latency of a record, measuring by comparing the record timestamp with the system time when it has been fully processed by the node", "The maximum end-to-end latency of a record, measuring by comparing the record timestamp with the system time when it has been fully processed by the node");
        return sensor;
    }

    public static Sensor emitFinalLatencySensor(String threadId, String taskId, String processorNodeId, StreamsMetricsImpl streamsMetrics) {
        String sensorName = processorNodeId + "-" + EMIT_FINAL_LATENCY;
        Sensor sensor = streamsMetrics.nodeLevelSensor(threadId, taskId, processorNodeId, sensorName, Sensor.RecordingLevel.DEBUG, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.nodeLevelTagMap(threadId, taskId, processorNodeId);
        StreamsMetricsImpl.addAvgAndMaxToSensor(sensor, "stream-processor-node-metrics", tagMap, EMIT_FINAL_LATENCY, EMIT_FINAL_AVG_LATENCY_DESCRIPTION, EMIT_FINAL_MAX_LATENCY_DESCRIPTION);
        return sensor;
    }

    public static Sensor emittedRecordsSensor(String threadId, String taskId, String processorNodeId, StreamsMetricsImpl streamsMetrics) {
        String sensorName = processorNodeId + "-" + EMITTED_RECORDS;
        Sensor sensor = streamsMetrics.nodeLevelSensor(threadId, taskId, processorNodeId, sensorName, Sensor.RecordingLevel.DEBUG, new Sensor[0]);
        Map<String, String> tagMap = streamsMetrics.nodeLevelTagMap(threadId, taskId, processorNodeId);
        StreamsMetricsImpl.addRateOfSumAndSumMetricsToSensor(sensor, "stream-processor-node-metrics", tagMap, EMITTED_RECORDS, EMITTED_RECORDS_RATE_DESCRIPTION, EMITTED_RECORDS_TOTAL_DESCRIPTION);
        return sensor;
    }

    private static Sensor throughputParentSensor(String threadId, String taskId, String metricNamePrefix, String descriptionOfRate, String descriptionOfCount, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics) {
        Sensor sensor = streamsMetrics.taskLevelSensor(threadId, taskId, metricNamePrefix, recordingLevel, new Sensor[0]);
        Map<String, String> parentTagMap = streamsMetrics.nodeLevelTagMap(threadId, taskId, "all");
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(sensor, "stream-processor-node-metrics", parentTagMap, metricNamePrefix, descriptionOfRate, descriptionOfCount);
        return sensor;
    }

    private static Sensor throughputSensor(String threadId, String taskId, String processorNodeId, String metricNamePrefix, String descriptionOfRate, String descriptionOfCount, Sensor.RecordingLevel recordingLevel, StreamsMetricsImpl streamsMetrics, Sensor ... parentSensors) {
        Sensor sensor = streamsMetrics.nodeLevelSensor(threadId, taskId, processorNodeId, metricNamePrefix, recordingLevel, parentSensors);
        Map<String, String> tagMap = streamsMetrics.nodeLevelTagMap(threadId, taskId, processorNodeId);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor(sensor, "stream-processor-node-metrics", tagMap, metricNamePrefix, descriptionOfRate, descriptionOfCount);
        return sensor;
    }
}

