/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.common.TopicAndPartition;
import kafka.controller.ControllerZkChildListener;
import kafka.controller.ControllerZkListener;
import kafka.controller.IsrChangeNotificationListener$;
import kafka.controller.KafkaController;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ZkUtils$;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u000154A!\u0001\u0002\u0001\u000f\ti\u0012j\u001d:DQ\u0006tw-\u001a(pi&4\u0017nY1uS>tG*[:uK:,'O\u0003\u0002\u0004\t\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011A\u0001\"!\u0003\b\u000e\u0003)Q!a\u0003\u0007\u0002\t1\fgn\u001a\u0006\u0002\u001b\u0005!!.\u0019<b\u0013\ty!B\u0001\u0004PE*,7\r\u001e\t\u0003#Ii\u0011AA\u0005\u0003'\t\u0011\u0011dQ8oiJ|G\u000e\\3s5.\u001c\u0005.\u001b7e\u0019&\u001cH/\u001a8fe\"A1\u0001\u0001BC\u0002\u0013EQ#F\u0001\u0017!\t\tr#\u0003\u0002\u0019\u0005\ty1*\u00194lC\u000e{g\u000e\u001e:pY2,'\u000f\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u0017\u0003-\u0019wN\u001c;s_2dWM\u001d\u0011\t\u000bq\u0001A\u0011A\u000f\u0002\rqJg.\u001b;?)\tqr\u0004\u0005\u0002\u0012\u0001!)1a\u0007a\u0001-!)\u0011\u0005\u0001C\tE\u00059An\\4OC6,W#A\u0012\u0011\u0005%!\u0013BA\u0013\u000b\u0005\u0019\u0019FO]5oO\")q\u0005\u0001C\u0001Q\u0005\u0019Bm\u001c%b]\u0012dWm\u00115jY\u0012\u001c\u0005.\u00198hKR\u0019\u0011fL\u001e\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\tUs\u0017\u000e\u001e\u0005\u0006a\u0019\u0002\r!M\u0001\u000ba\u0006\u0014XM\u001c;QCRD\u0007C\u0001\u001a:\u001d\t\u0019t\u0007\u0005\u00025W5\tQG\u0003\u00027\r\u00051AH]8pizJ!\u0001O\u0016\u0002\rA\u0013X\rZ3g\u0013\t)#H\u0003\u00029W!)AH\na\u0001{\u0005y1-\u001e:sK:$8\t[5mIJ,g\u000eE\u0002?\u0003Fj\u0011a\u0010\u0006\u0003\u0001.\n!bY8mY\u0016\u001cG/[8o\u0013\t\u0011uHA\u0002TKFDQ\u0001\u0012\u0001\u0005\n\u0015\u000b!\u0004\u001d:pG\u0016\u001c8/\u00169eCR,gj\u001c;jM&\u001c\u0017\r^5p]N$\"!\u000b$\t\u000b\u001d\u001b\u0005\u0019\u0001%\u0002%Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|gn\u001d\t\u0004\u00132sU\"\u0001&\u000b\u0005-{\u0014!C5n[V$\u0018M\u00197f\u0013\ti%JA\u0002TKR\u0004\"a\u0014*\u000e\u0003AS!!\u0015\u0003\u0002\r\r|W.\\8o\u0013\t\u0019\u0006KA\tU_BL7-\u00118e!\u0006\u0014H/\u001b;j_:DQ!\u0016\u0001\u0005\nY\u000bAcZ3u)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>tGCA,Z!\rq\u0004LT\u0005\u0003\u001b~BQA\u0017+A\u0002E\nQa\u00195jY\u0012<Q\u0001\u0018\u0002\t\u0002u\u000bQ$S:s\u0007\"\fgnZ3O_RLg-[2bi&|g\u000eT5ti\u0016tWM\u001d\t\u0003#y3Q!\u0001\u0002\t\u0002}\u001b\"A\u00181\u0011\u0005)\n\u0017B\u00012,\u0005\u0019\te.\u001f*fM\")AD\u0018C\u0001IR\tQ\fC\u0004g=\n\u0007I\u0011A4\u0002\u000fY,'o]5p]V\t\u0001\u000e\u0005\u0002+S&\u0011!n\u000b\u0002\u0005\u0019>tw\r\u0003\u0004m=\u0002\u0006I\u0001[\u0001\tm\u0016\u00148/[8oA\u0001")
public class IsrChangeNotificationListener
implements ControllerZkChildListener {
    private final KafkaController controller;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static long version() {
        return IsrChangeNotificationListener$.MODULE$.version();
    }

    @Override
    public final void handleChildChange(String parentPath, java.util.List<String> currentChildren) throws Exception {
        ControllerZkChildListener.handleChildChange$(this, parentPath, currentChildren);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        IsrChangeNotificationListener isrChangeNotificationListener = this;
        synchronized (isrChangeNotificationListener) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public KafkaController controller() {
        return this.controller;
    }

    @Override
    public String logName() {
        return "IsrChangeNotificationListener";
    }

    @Override
    public void doHandleChildChange(String parentPath, Seq<String> currentChildren) {
        CoreUtils$.MODULE$.inLock(this.controller().controllerContext().controllerLock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "ISR change notification listener fired");
            try {
                scala.collection.immutable.Set topicAndPartitions = ((TraversableOnce)currentChildren.flatMap((Function1 & Serializable & scala.Serializable)child -> this.getTopicAndPartition((String)child), Seq$.MODULE$.canBuildFrom())).toSet();
                if (topicAndPartitions.nonEmpty()) {
                    this.controller().updateLeaderAndIsrCache((Set<TopicAndPartition>)topicAndPartitions);
                    this.processUpdateNotifications((scala.collection.immutable.Set<TopicAndPartition>)topicAndPartitions);
                }
            }
            finally {
                currentChildren.map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)IsrChangeNotificationListener.$anonfun$doHandleChildChange$4(this, x)), Seq$.MODULE$.canBuildFrom());
            }
        });
    }

    private void processUpdateNotifications(scala.collection.immutable.Set<TopicAndPartition> topicAndPartitions) {
        Seq liveBrokers = this.controller().controllerContext().liveOrShuttingDownBrokerIds().toSeq();
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Sending MetadataRequest to Brokers:" + liveBrokers + " for TopicAndPartitions:" + topicAndPartitions);
        this.controller().sendUpdateMetadataRequest((Seq<Object>)liveBrokers, (Set<TopicAndPartition>)topicAndPartitions);
    }

    private Set<TopicAndPartition> getTopicAndPartition(String child) {
        Set set;
        Option jsonOpt;
        String changeZnode = ZkUtils$.MODULE$.IsrChangeNotificationPath() + "/" + child;
        Tuple2<Option<String>, Stat> tuple2 = this.controller().controllerContext().zkUtils().readDataMaybeNull(changeZnode);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option option = jsonOpt = (Option)tuple2._1();
        Option jsonOpt2 = option;
        if (jsonOpt2.isDefined()) {
            Set set2;
            Option<Object> json = Json$.MODULE$.parseFull((String)jsonOpt2.get());
            Option<Object> option2 = json;
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Object m = some.value();
                HashSet topicAndPartitions = new HashSet();
                Map isrChanges = (Map)m;
                List topicAndPartitionList = (List)isrChanges.apply((Object)"partitions");
                topicAndPartitionList.foreach(arg_0 -> IsrChangeNotificationListener.$anonfun$getTopicAndPartition$1((scala.collection.mutable.Set)topicAndPartitions, arg_0));
                set2 = topicAndPartitions;
            } else if (None$.MODULE$.equals(option2)) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Invalid topic and partition JSON: " + jsonOpt2.get() + " in ZK: " + changeZnode);
                set2 = Set$.MODULE$.empty();
            } else {
                throw new MatchError(option2);
            }
            set = set2;
        } else {
            set = Set$.MODULE$.empty();
        }
        return set;
    }

    public static final /* synthetic */ boolean $anonfun$doHandleChildChange$4(IsrChangeNotificationListener $this, String x) {
        return $this.controller().controllerContext().zkUtils().deletePath(ZkUtils$.MODULE$.IsrChangeNotificationPath() + "/" + x);
    }

    public static final /* synthetic */ scala.collection.mutable.Set $anonfun$getTopicAndPartition$1(scala.collection.mutable.Set topicAndPartitions$2, Object x0$14) {
        Object object = x0$14;
        Map topicAndPartition = (Map)object;
        String topic = (String)topicAndPartition.apply((Object)"topic");
        int partition = BoxesRunTime.unboxToInt((Object)topicAndPartition.apply((Object)"partition"));
        scala.collection.mutable.Set set = (scala.collection.mutable.Set)topicAndPartitions$2.$plus$eq((Object)new TopicAndPartition(topic, partition));
        return set;
    }

    public IsrChangeNotificationListener(KafkaController controller) {
        this.controller = controller;
        Logging.$init$(this);
        ControllerZkListener.$init$(this);
        ControllerZkChildListener.$init$(this);
    }
}

