/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import kafka.log.LogValidator;
import kafka.message.CompressionCodec;
import kafka.message.InvalidMessageException;
import kafka.message.NoCompressionCodec$;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.record.ByteBufferLogInputStream;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.TimestampType;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.math.Numeric;
import scala.math.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

public final class LogValidator$ {
    public static LogValidator$ MODULE$;

    static {
        new LogValidator$();
    }

    /*
     * Enabled aggressive block sorting
     */
    public LogValidator.ValidationAndOffsetAssignResult validateMessagesAndAssignOffsets(MemoryRecords records, kafka.common.LongRef offsetCounter, long now, CompressionCodec sourceCodec, CompressionCodec targetCodec, boolean compactedTopic, byte messageFormatVersion, TimestampType messageTimestampType, long messageTimestampDiffMaxMs) {
        LogValidator.ValidationAndOffsetAssignResult validationAndOffsetAssignResult;
        CompressionCodec compressionCodec = sourceCodec;
        NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
        if (!(compressionCodec != null ? !compressionCodec.equals(noCompressionCodec$) : noCompressionCodec$ != null)) {
            CompressionCodec compressionCodec2 = targetCodec;
            NoCompressionCodec$ noCompressionCodec$2 = NoCompressionCodec$.MODULE$;
            if (!(compressionCodec2 != null ? !compressionCodec2.equals(noCompressionCodec$2) : noCompressionCodec$2 != null)) {
                if (!records.hasMatchingShallowMagic(messageFormatVersion)) {
                    validationAndOffsetAssignResult = this.convertAndAssignOffsetsNonCompressed(records, offsetCounter, compactedTopic, now, messageTimestampType, messageTimestampDiffMaxMs, messageFormatVersion);
                    return validationAndOffsetAssignResult;
                }
                validationAndOffsetAssignResult = this.assignOffsetsNonCompressed(records, offsetCounter, now, compactedTopic, messageTimestampType, messageTimestampDiffMaxMs);
                return validationAndOffsetAssignResult;
            }
        }
        validationAndOffsetAssignResult = this.validateMessagesAndAssignOffsetsCompressed(records, offsetCounter, now, sourceCodec, targetCodec, compactedTopic, messageFormatVersion, messageTimestampType, messageTimestampDiffMaxMs);
        return validationAndOffsetAssignResult;
    }

    public boolean validateMessagesAndAssignOffsets$default$6() {
        return false;
    }

    public byte validateMessagesAndAssignOffsets$default$7() {
        return 1;
    }

    private LogValidator.ValidationAndOffsetAssignResult convertAndAssignOffsetsNonCompressed(MemoryRecords records, kafka.common.LongRef offsetCounter, boolean compactedTopic, long now, TimestampType timestampType, long messageTimestampDiffMaxMs, byte toMagicValue) {
        int sizeInBytesAfterConversion = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.shallowEntries()).asScala()).map((Function1 & Serializable & scala.Serializable)logEntry -> BoxesRunTime.boxToInteger((int)LogValidator$.$anonfun$convertAndAssignOffsetsNonCompressed$1(toMagicValue, logEntry)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ByteBuffer newBuffer = ByteBuffer.allocate(sizeInBytesAfterConversion);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)newBuffer, (byte)toMagicValue, (CompressionType)CompressionType.NONE, (TimestampType)timestampType, (long)offsetCounter.value(), (long)now);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.shallowEntries()).asScala()).foreach((Function1 & Serializable & scala.Serializable)logEntry -> {
            LogValidator$.$anonfun$convertAndAssignOffsetsNonCompressed$2(this, offsetCounter, compactedTopic, now, timestampType, messageTimestampDiffMaxMs, builder, logEntry);
            return BoxedUnit.UNIT;
        });
        MemoryRecords convertedRecords = builder.build();
        MemoryRecordsBuilder.RecordsInfo info = builder.info();
        return new LogValidator.ValidationAndOffsetAssignResult(convertedRecords, info.maxTimestamp, info.shallowOffsetOfMaxTimestamp, true);
    }

    private LogValidator.ValidationAndOffsetAssignResult assignOffsetsNonCompressed(MemoryRecords records, kafka.common.LongRef offsetCounter, long now, boolean compactedTopic, TimestampType timestampType, long timestampDiffMaxMs) {
        LongRef maxTimestamp = LongRef.create((long)-1L);
        LongRef offsetOfMaxTimestamp = LongRef.create((long)-1L);
        long firstOffset = offsetCounter.value();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.shallowEntries()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            LogValidator$.$anonfun$assignOffsetsNonCompressed$1(this, offsetCounter, now, compactedTopic, timestampType, timestampDiffMaxMs, maxTimestamp, offsetOfMaxTimestamp, entry);
            return BoxedUnit.UNIT;
        });
        TimestampType timestampType2 = timestampType;
        TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
        if (!(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null)) {
            maxTimestamp.elem = now;
            offsetOfMaxTimestamp.elem = firstOffset;
        }
        return new LogValidator.ValidationAndOffsetAssignResult(records, maxTimestamp.elem, offsetOfMaxTimestamp.elem, false);
    }

    public LogValidator.ValidationAndOffsetAssignResult validateMessagesAndAssignOffsetsCompressed(MemoryRecords records, kafka.common.LongRef offsetCounter, long now, CompressionCodec sourceCodec, CompressionCodec targetCodec, boolean compactedTopic, byte messageFormatVersion, TimestampType messageTimestampType, long messageTimestampDiffMaxMs) {
        LogValidator.ValidationAndOffsetAssignResult validationAndOffsetAssignResult;
        CompressionCodec compressionCodec = sourceCodec;
        CompressionCodec compressionCodec2 = targetCodec;
        BooleanRef inPlaceAssignment = BooleanRef.create((!(compressionCodec != null ? !compressionCodec.equals(compressionCodec2) : compressionCodec2 != null) && messageFormatVersion > 0 ? 1 : 0) != 0);
        LongRef maxTimestamp = LongRef.create((long)-1L);
        kafka.common.LongRef expectedInnerOffset = new kafka.common.LongRef(0L);
        ArrayBuffer validatedRecords = new ArrayBuffer();
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.deepEntries(true)).asScala()).foreach((Function1 & Serializable & scala.Serializable)logEntry -> {
            Record record;
            block4: {
                record = logEntry.record();
                this.validateKey(record, compactedTopic);
                if (record.magic() > 0 && messageFormatVersion > 0) {
                    this.validateTimestamp(record, now, messageTimestampType, messageTimestampDiffMaxMs);
                    if (logEntry.offset() != expectedInnerOffset.getAndIncrement()) {
                        inPlaceAssignment$1.elem = false;
                    }
                    if (record.timestamp() > maxTimestamp$2.elem) {
                        maxTimestamp$2.elem = record.timestamp();
                    }
                }
                CompressionCodec compressionCodec = sourceCodec;
                NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                if ((compressionCodec == null ? noCompressionCodec$ != null : !compressionCodec.equals(noCompressionCodec$)) && logEntry.isCompressed()) {
                    throw new InvalidMessageException("Compressed outer record should not have an inner record with a " + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"compression attribute set: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record})));
                }
                if (record.magic() == messageFormatVersion) break block4;
                inPlaceAssignment$1.elem = false;
            }
            return validatedRecords.$plus$eq((Object)record.convert(messageFormatVersion));
        });
        if (!inPlaceAssignment.elem) {
            ArrayBuffer entries = (ArrayBuffer)validatedRecords.map((Function1 & Serializable & scala.Serializable)record -> LogEntry.create((long)offsetCounter.getAndIncrement(), (Record)record), ArrayBuffer$.MODULE$.canBuildFrom());
            MemoryRecordsBuilder builder = MemoryRecords.builderWithEntries((TimestampType)messageTimestampType, (CompressionType)CompressionType.forId((int)targetCodec.codec()), (long)now, (List)((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)entries).asJava()));
            MemoryRecords updatedRecords = builder.build();
            MemoryRecordsBuilder.RecordsInfo info = builder.info();
            validationAndOffsetAssignResult = new LogValidator.ValidationAndOffsetAssignResult(updatedRecords, info.maxTimestamp, info.shallowOffsetOfMaxTimestamp, true);
        } else {
            validatedRecords.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.ensureValid();
                return BoxedUnit.UNIT;
            });
            ByteBufferLogInputStream.ByteBufferLogEntry entry = (ByteBufferLogInputStream.ByteBufferLogEntry)records.shallowEntries().iterator().next();
            long offset = offsetCounter.addAndGet(validatedRecords.size()) - 1L;
            entry.setOffset(offset);
            TimestampType timestampType = messageTimestampType;
            TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
            long shallowTimestamp = !(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null) ? now : maxTimestamp.elem;
            TimestampType timestampType3 = messageTimestampType;
            TimestampType timestampType4 = TimestampType.LOG_APPEND_TIME;
            if (!(timestampType3 != null ? !timestampType3.equals(timestampType4) : timestampType4 != null)) {
                entry.setLogAppendTime(shallowTimestamp);
            } else {
                TimestampType timestampType5 = messageTimestampType;
                TimestampType timestampType6 = TimestampType.CREATE_TIME;
                if (!(timestampType5 != null ? !timestampType5.equals(timestampType6) : timestampType6 != null)) {
                    entry.setCreateTime(shallowTimestamp);
                }
            }
            validationAndOffsetAssignResult = new LogValidator.ValidationAndOffsetAssignResult(records, shallowTimestamp, offset, false);
        }
        return validationAndOffsetAssignResult;
    }

    public boolean validateMessagesAndAssignOffsetsCompressed$default$6() {
        return false;
    }

    public byte validateMessagesAndAssignOffsetsCompressed$default$7() {
        return 1;
    }

    private void validateKey(Record record, boolean compactedTopic) {
        if (compactedTopic && !record.hasKey()) {
            throw new InvalidMessageException("Compacted topic cannot accept message without key.");
        }
    }

    private void validateTimestamp(Record record, long now, TimestampType timestampType, long timestampDiffMaxMs) {
        TimestampType timestampType2 = timestampType;
        TimestampType timestampType3 = TimestampType.CREATE_TIME;
        if (!(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null) && package$.MODULE$.abs(record.timestamp() - now) > timestampDiffMaxMs) {
            throw new InvalidTimestampException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Timestamp ", " of message is out of range. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)record.timestamp())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The timestamp should be within [", ", ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(now - timestampDiffMaxMs)), BoxesRunTime.boxToLong((long)(now + timestampDiffMaxMs))})));
        }
        TimestampType timestampType4 = record.timestampType();
        TimestampType timestampType5 = TimestampType.LOG_APPEND_TIME;
        if (!(timestampType4 != null ? !timestampType4.equals(timestampType5) : timestampType5 != null)) {
            throw new InvalidTimestampException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid timestamp type in message ", ". Producer should not set "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{record})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"timestamp type to LogAppendTime."})).s((Seq)Nil$.MODULE$));
        }
    }

    public static final /* synthetic */ int $anonfun$convertAndAssignOffsetsNonCompressed$1(byte toMagicValue$1, ByteBufferLogInputStream.ByteBufferLogEntry logEntry) {
        return logEntry.record().convertedSize(toMagicValue$1);
    }

    public static final /* synthetic */ void $anonfun$convertAndAssignOffsetsNonCompressed$2(LogValidator$ $this, kafka.common.LongRef offsetCounter$1, boolean compactedTopic$1, long now$1, TimestampType timestampType$1, long messageTimestampDiffMaxMs$1, MemoryRecordsBuilder builder$1, ByteBufferLogInputStream.ByteBufferLogEntry logEntry) {
        Record record = logEntry.record();
        $this.validateKey(record, compactedTopic$1);
        $this.validateTimestamp(record, now$1, timestampType$1, messageTimestampDiffMaxMs$1);
        builder$1.convertAndAppendWithOffset(offsetCounter$1.getAndIncrement(), record);
    }

    public static final /* synthetic */ void $anonfun$assignOffsetsNonCompressed$1(LogValidator$ $this, kafka.common.LongRef offsetCounter$2, long now$2, boolean compactedTopic$2, TimestampType timestampType$2, long timestampDiffMaxMs$1, LongRef maxTimestamp$1, LongRef offsetOfMaxTimestamp$1, ByteBufferLogInputStream.ByteBufferLogEntry entry) {
        block0: {
            long offset;
            Record record;
            block1: {
                record = entry.record();
                $this.validateKey(record, compactedTopic$2);
                offset = offsetCounter$2.getAndIncrement();
                entry.setOffset(offset);
                if (record.magic() <= 0) break block0;
                $this.validateTimestamp(record, now$2, timestampType$2, timestampDiffMaxMs$1);
                TimestampType timestampType = timestampType$2;
                TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
                if (timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null) break block1;
                entry.setLogAppendTime(now$2);
                break block0;
            }
            if (record.timestamp() <= maxTimestamp$1.elem) break block0;
            maxTimestamp$1.elem = record.timestamp();
            offsetOfMaxTimestamp$1.elem = offset;
        }
    }

    private LogValidator$() {
        MODULE$ = this;
    }
}

