/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import kafka.api.RequestOrResponse;
import kafka.network.BlockingChannel$;
import kafka.network.RequestOrResponseSend;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005]u!B\u0001\u0003\u0011\u00039\u0011a\u0004\"m_\u000e\\\u0017N\\4DQ\u0006tg.\u001a7\u000b\u0005\r!\u0011a\u00028fi^|'o\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u0005\n\u001b\u0005\u0011a!\u0002\u0006\u0003\u0011\u0003Y!a\u0004\"m_\u000e\\\u0017N\\4DQ\u0006tg.\u001a7\u0014\u0005%a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rC\u0003\u0014\u0013\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002\u000f!9a#\u0003b\u0001\n\u00039\u0012\u0001F+tK\u0012+g-Y;mi\n+hMZ3s'&TX-F\u0001\u0019!\ti\u0011$\u0003\u0002\u001b\u001d\t\u0019\u0011J\u001c;\t\rqI\u0001\u0015!\u0003\u0019\u0003U)6/\u001a#fM\u0006,H\u000e\u001e\"vM\u001a,'oU5{K\u00022AA\u0003\u0002\u0001=M\u0019Q\u0004D\u0010\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0005\t\"\u0011!B;uS2\u001c\u0018B\u0001\u0013\"\u0005\u001daunZ4j]\u001eD\u0001BJ\u000f\u0003\u0006\u0004%\taJ\u0001\u0005Q>\u001cH/F\u0001)!\tI\u0003G\u0004\u0002+]A\u00111FD\u0007\u0002Y)\u0011QFB\u0001\u0007yI|w\u000e\u001e \n\u0005=r\u0011A\u0002)sK\u0012,g-\u0003\u00022e\t11\u000b\u001e:j]\u001eT!a\f\b\t\u0011Qj\"\u0011!Q\u0001\n!\nQ\u0001[8ti\u0002B\u0001BN\u000f\u0003\u0006\u0004%\taF\u0001\u0005a>\u0014H\u000f\u0003\u00059;\t\u0005\t\u0015!\u0003\u0019\u0003\u0015\u0001xN\u001d;!\u0011!QTD!b\u0001\n\u00039\u0012A\u0004:fC\u0012\u0014UO\u001a4feNK'0\u001a\u0005\tyu\u0011\t\u0011)A\u00051\u0005y!/Z1e\u0005V4g-\u001a:TSj,\u0007\u0005\u0003\u0005?;\t\u0015\r\u0011\"\u0001\u0018\u0003=9(/\u001b;f\u0005V4g-\u001a:TSj,\u0007\u0002\u0003!\u001e\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002!]\u0014\u0018\u000e^3Ck\u001a4WM]*ju\u0016\u0004\u0003\u0002\u0003\"\u001e\u0005\u000b\u0007I\u0011A\f\u0002\u001bI,\u0017\r\u001a+j[\u0016|W\u000f^'t\u0011!!UD!A!\u0002\u0013A\u0012A\u0004:fC\u0012$\u0016.\\3pkRl5\u000f\t\u0005\u0006'u!\tA\u0012\u000b\u0007\u000f\"K%j\u0013'\u0011\u0005!i\u0002\"\u0002\u0014F\u0001\u0004A\u0003\"\u0002\u001cF\u0001\u0004A\u0002\"\u0002\u001eF\u0001\u0004A\u0002\"\u0002 F\u0001\u0004A\u0002\"\u0002\"F\u0001\u0004A\u0002b\u0002(\u001e\u0001\u0004%IaT\u0001\nG>tg.Z2uK\u0012,\u0012\u0001\u0015\t\u0003\u001bEK!A\u0015\b\u0003\u000f\t{w\u000e\\3b]\"9A+\ba\u0001\n\u0013)\u0016!D2p]:,7\r^3e?\u0012*\u0017\u000f\u0006\u0002W3B\u0011QbV\u0005\u00031:\u0011A!\u00168ji\"9!lUA\u0001\u0002\u0004\u0001\u0016a\u0001=%c!1A,\bQ!\nA\u000b!bY8o]\u0016\u001cG/\u001a3!\u0011\u001dqV\u00041A\u0005\n}\u000bqa\u00195b]:,G.F\u0001a!\t\t\u0007.D\u0001c\u0015\t\u0019G-\u0001\u0005dQ\u0006tg.\u001a7t\u0015\t)g-A\u0002oS>T\u0011aZ\u0001\u0005U\u00064\u0018-\u0003\u0002jE\ni1k\\2lKR\u001c\u0005.\u00198oK2Dqa[\u000fA\u0002\u0013%A.A\u0006dQ\u0006tg.\u001a7`I\u0015\fHC\u0001,n\u0011\u001dQ&.!AA\u0002\u0001Daa\\\u000f!B\u0013\u0001\u0017\u0001C2iC:tW\r\u001c\u0011\t\u000fEl\u0002\u0019!C\u0005e\u0006Y!/Z1e\u0007\"\fgN\\3m+\u0005\u0019\bCA1u\u0013\t)(MA\nSK\u0006$\u0017M\u00197f\u0005f$Xm\u00115b]:,G\u000eC\u0004x;\u0001\u0007I\u0011\u0002=\u0002\u001fI,\u0017\rZ\"iC:tW\r\\0%KF$\"AV=\t\u000fi3\u0018\u0011!a\u0001g\"110\bQ!\nM\fAB]3bI\u000eC\u0017M\u001c8fY\u0002Bq!`\u000fA\u0002\u0013%a0\u0001\u0007xe&$Xm\u00115b]:,G.F\u0001\u0000!\r\t\u0017\u0011A\u0005\u0004\u0003\u0007\u0011'\u0001F$bi\",'/\u001b8h\u0005f$Xm\u00115b]:,G\u000eC\u0005\u0002\bu\u0001\r\u0011\"\u0003\u0002\n\u0005\u0001rO]5uK\u000eC\u0017M\u001c8fY~#S-\u001d\u000b\u0004-\u0006-\u0001\u0002\u0003.\u0002\u0006\u0005\u0005\t\u0019A@\t\u000f\u0005=Q\u0004)Q\u0005\u007f\u0006iqO]5uK\u000eC\u0017M\u001c8fY\u0002B\u0011\"a\u0005\u001e\u0005\u0004%I!!\u0006\u0002\t1|7m[\u000b\u0003\u0003/\u0001B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;1\u0017\u0001\u00027b]\u001eLA!!\t\u0002\u001c\t1qJ\u00196fGRD\u0001\"!\n\u001eA\u0003%\u0011qC\u0001\u0006Y>\u001c7\u000e\t\u0005\t\u0003Si\"\u0019!C\u0005/\u0005\u00012m\u001c8oK\u000e$H+[7f_V$Xj\u001d\u0005\b\u0003[i\u0002\u0015!\u0003\u0019\u0003E\u0019wN\u001c8fGR$\u0016.\\3pkRl5\u000f\t\u0005\t\u0003ci\u0002\u0019!C\u0005O\u0005a1m\u001c8oK\u000e$\u0018n\u001c8JI\"I\u0011QG\u000fA\u0002\u0013%\u0011qG\u0001\u0011G>tg.Z2uS>t\u0017\nZ0%KF$2AVA\u001d\u0011!Q\u00161GA\u0001\u0002\u0004A\u0003bBA\u001f;\u0001\u0006K\u0001K\u0001\u000eG>tg.Z2uS>t\u0017\n\u001a\u0011\t\u000f\u0005\u0005S\u0004\"\u0001\u0002D\u000591m\u001c8oK\u000e$H#\u0001,\t\u000f\u0005\u001dS\u0004\"\u0001\u0002D\u0005QA-[:d_:tWm\u0019;\t\r\u0005-S\u0004\"\u0001P\u0003-I7oQ8o]\u0016\u001cG/\u001a3\t\u000f\u0005=S\u0004\"\u0001\u0002R\u0005!1/\u001a8e)\u0011\t\u0019&!\u0017\u0011\u00075\t)&C\u0002\u0002X9\u0011A\u0001T8oO\"A\u00111LA'\u0001\u0004\ti&A\u0004sKF,Xm\u001d;\u0011\t\u0005}\u0013QM\u0007\u0003\u0003CR1!a\u0019\u0005\u0003\r\t\u0007/[\u0005\u0005\u0003O\n\tGA\tSKF,Xm\u001d;PeJ+7\u000f]8og\u0016Dq!a\u001b\u001e\t\u0003\ti'A\u0004sK\u000e,\u0017N^3\u0015\u0005\u0005=\u0004\u0003BA9\u0003\u0007k!!a\u001d\u000b\u0007\r\t)H\u0003\u0003\u0002x\u0005e\u0014AB2p[6|gNC\u0002\u0006\u0003wRA!! \u0002\u0000\u00051\u0011\r]1dQ\u0016T!!!!\u0002\u0007=\u0014x-\u0003\u0003\u0002\u0006\u0006M$A\u0004(fi^|'o\u001b*fG\u0016Lg/\u001a\u0005\b\u0003\u0013kB\u0011BAF\u00039\u0011X-\u00193D_6\u0004H.\u001a;fYf$B!a\u001c\u0002\u000e\"1a,a\"A\u0002MD3!HAI!\r\u0001\u00131S\u0005\u0004\u0003+\u000b#!\u00048p]RD'/Z1eg\u00064W\r")
public class BlockingChannel
implements Logging {
    private final String host;
    private final int port;
    private final int readBufferSize;
    private final int writeBufferSize;
    private final int readTimeoutMs;
    private boolean connected;
    private SocketChannel channel;
    private ReadableByteChannel readChannel;
    private GatheringByteChannel writeChannel;
    private final Object lock;
    private final int connectTimeoutMs;
    private String connectionId;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static int UseDefaultBufferSize() {
        return BlockingChannel$.MODULE$.UseDefaultBufferSize();
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        BlockingChannel blockingChannel = this;
        synchronized (blockingChannel) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int readBufferSize() {
        return this.readBufferSize;
    }

    public int writeBufferSize() {
        return this.writeBufferSize;
    }

    public int readTimeoutMs() {
        return this.readTimeoutMs;
    }

    private boolean connected() {
        return this.connected;
    }

    private void connected_$eq(boolean x$1) {
        this.connected = x$1;
    }

    private SocketChannel channel() {
        return this.channel;
    }

    private void channel_$eq(SocketChannel x$1) {
        this.channel = x$1;
    }

    private ReadableByteChannel readChannel() {
        return this.readChannel;
    }

    private void readChannel_$eq(ReadableByteChannel x$1) {
        this.readChannel = x$1;
    }

    private GatheringByteChannel writeChannel() {
        return this.writeChannel;
    }

    private void writeChannel_$eq(GatheringByteChannel x$1) {
        this.writeChannel = x$1;
    }

    private Object lock() {
        return this.lock;
    }

    private int connectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    private String connectionId() {
        return this.connectionId;
    }

    private void connectionId_$eq(String x$1) {
        this.connectionId = x$1;
    }

    public void connect() {
        Object object = this.lock();
        synchronized (object) {
            if (!this.connected()) {
                this.liftedTree1$1();
            }
        }
    }

    public void disconnect() {
        Object object = this.lock();
        synchronized (object) {
            if (this.channel() != null) {
                this.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.channel().close());
                this.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.channel().socket().close());
                this.channel_$eq(null);
                this.writeChannel_$eq(null);
            }
            if (this.readChannel() != null) {
                this.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.readChannel().close());
                this.readChannel_$eq(null);
            }
            this.connected_$eq(false);
        }
    }

    public boolean isConnected() {
        return this.connected();
    }

    public long send(RequestOrResponse request) {
        if (!this.connected()) {
            throw new ClosedChannelException();
        }
        RequestOrResponseSend send = new RequestOrResponseSend(this.connectionId(), request);
        return send.writeCompletely(this.writeChannel());
    }

    /*
     * WARNING - void declaration
     */
    public NetworkReceive receive() {
        void var1_1;
        if (!this.connected()) {
            throw new ClosedChannelException();
        }
        NetworkReceive response = this.readCompletely(this.readChannel());
        response.payload().rewind();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private NetworkReceive readCompletely(ReadableByteChannel channel) {
        void var2_2;
        NetworkReceive response = new NetworkReceive();
        while (!response.complete()) {
            response.readFromReadableChannel(channel);
        }
        return var2_2;
    }

    private final void liftedTree1$1() {
        try {
            this.channel_$eq(SocketChannel.open());
            if (this.readBufferSize() > 0) {
                this.channel().socket().setReceiveBufferSize(this.readBufferSize());
            }
            if (this.writeBufferSize() > 0) {
                this.channel().socket().setSendBufferSize(this.writeBufferSize());
            }
            this.channel().configureBlocking(true);
            this.channel().socket().setSoTimeout(this.readTimeoutMs());
            this.channel().socket().setKeepAlive(true);
            this.channel().socket().setTcpNoDelay(true);
            this.channel().socket().connect(new InetSocketAddress(this.host(), this.port()), this.connectTimeoutMs());
            this.writeChannel_$eq(this.channel());
            this.readChannel_$eq(Channels.newChannel(this.channel().socket().getInputStream()));
            this.connected_$eq(true);
            String localHost = this.channel().socket().getLocalAddress().getHostAddress();
            int localPort = this.channel().socket().getLocalPort();
            String remoteHost = this.channel().socket().getInetAddress().getHostAddress();
            int remotePort = this.channel().socket().getPort();
            this.connectionId_$eq(localHost + ":" + localPort + "-" + remoteHost + ":" + remotePort);
            String msg = "Created socket with SO_TIMEOUT = %d (requested %d), SO_RCVBUF = %d (requested %d), SO_SNDBUF = %d (requested %d), connectTimeoutMs = %d.";
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(msg)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.channel().socket().getSoTimeout()), BoxesRunTime.boxToInteger((int)this.readTimeoutMs()), BoxesRunTime.boxToInteger((int)this.channel().socket().getReceiveBufferSize()), BoxesRunTime.boxToInteger((int)this.readBufferSize()), BoxesRunTime.boxToInteger((int)this.channel().socket().getSendBufferSize()), BoxesRunTime.boxToInteger((int)this.writeBufferSize()), BoxesRunTime.boxToInteger((int)this.connectTimeoutMs())})));
        }
        catch (Throwable throwable) {
            this.disconnect();
        }
    }

    public BlockingChannel(String host, int port, int readBufferSize, int writeBufferSize, int readTimeoutMs) {
        this.host = host;
        this.port = port;
        this.readBufferSize = readBufferSize;
        this.writeBufferSize = writeBufferSize;
        this.readTimeoutMs = readTimeoutMs;
        Logging.$init$(this);
        this.connected = false;
        this.channel = null;
        this.readChannel = null;
        this.writeChannel = null;
        this.lock = new Object();
        this.connectTimeoutMs = readTimeoutMs;
        this.connectionId = "";
    }
}

