/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.Serializable;
import java.util.ArrayList;
import kafka.common.TopicAndPartition;
import kafka.utils.Json$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils;
import org.I0Itec.zkclient.IZkConnection;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.ZkConnection;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ZkUtils$ {
    public static ZkUtils$ MODULE$;
    private final String ConsumersPath;
    private final String ClusterIdPath;
    private final String BrokerIdsPath;
    private final String BrokerTopicsPath;
    private final String ControllerPath;
    private final String ControllerEpochPath;
    private final String ReassignPartitionsPath;
    private final String DeleteTopicsPath;
    private final String PreferredReplicaLeaderElectionPath;
    private final String BrokerSequenceIdPath;
    private final String IsrChangeNotificationPath;
    private final String EntityConfigPath;
    private final String EntityConfigChangesPath;

    static {
        new ZkUtils$();
    }

    public String ConsumersPath() {
        return this.ConsumersPath;
    }

    public String ClusterIdPath() {
        return this.ClusterIdPath;
    }

    public String BrokerIdsPath() {
        return this.BrokerIdsPath;
    }

    public String BrokerTopicsPath() {
        return this.BrokerTopicsPath;
    }

    public String ControllerPath() {
        return this.ControllerPath;
    }

    public String ControllerEpochPath() {
        return this.ControllerEpochPath;
    }

    public String ReassignPartitionsPath() {
        return this.ReassignPartitionsPath;
    }

    public String DeleteTopicsPath() {
        return this.DeleteTopicsPath;
    }

    public String PreferredReplicaLeaderElectionPath() {
        return this.PreferredReplicaLeaderElectionPath;
    }

    public String BrokerSequenceIdPath() {
        return this.BrokerSequenceIdPath;
    }

    public String IsrChangeNotificationPath() {
        return this.IsrChangeNotificationPath;
    }

    public String EntityConfigPath() {
        return this.EntityConfigPath;
    }

    public String EntityConfigChangesPath() {
        return this.EntityConfigChangesPath;
    }

    public ZkUtils apply(String zkUrl, int sessionTimeout, int connectionTimeout, boolean isZkSecurityEnabled) {
        Tuple2<ZkClient, ZkConnection> tuple2 = this.createZkClientAndConnection(zkUrl, sessionTimeout, connectionTimeout);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ZkClient zkClient = (ZkClient)tuple2._1();
        ZkConnection zkConnection = (ZkConnection)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)zkClient, (Object)zkConnection);
        Tuple2 tuple23 = tuple22;
        ZkClient zkClient2 = (ZkClient)tuple23._1();
        ZkConnection zkConnection2 = (ZkConnection)tuple23._2();
        return new ZkUtils(zkClient2, zkConnection2, isZkSecurityEnabled);
    }

    public ZkUtils apply(ZkClient zkClient, boolean isZkSecurityEnabled) {
        return new ZkUtils(zkClient, null, isZkSecurityEnabled);
    }

    public ZkClient createZkClient(String zkUrl, int sessionTimeout, int connectionTimeout) {
        ZkClient zkClient = new ZkClient(zkUrl, sessionTimeout, connectionTimeout, (ZkSerializer)ZKStringSerializer$.MODULE$);
        return zkClient;
    }

    public Tuple2<ZkClient, ZkConnection> createZkClientAndConnection(String zkUrl, int sessionTimeout, int connectionTimeout) {
        ZkConnection zkConnection = new ZkConnection(zkUrl, sessionTimeout);
        ZkClient zkClient = new ZkClient((IZkConnection)zkConnection, connectionTimeout, (ZkSerializer)ZKStringSerializer$.MODULE$);
        return new Tuple2((Object)zkClient, (Object)zkConnection);
    }

    /*
     * WARNING - void declaration
     */
    public java.util.List<ACL> DefaultAcls(boolean isSecure) {
        ArrayList arrayList;
        if (isSecure) {
            void var2_2;
            ArrayList list = new ArrayList();
            list.addAll(ZooDefs.Ids.CREATOR_ALL_ACL);
            list.addAll(ZooDefs.Ids.READ_ACL_UNSAFE);
            arrayList = var2_2;
        } else {
            arrayList = ZooDefs.Ids.OPEN_ACL_UNSAFE;
        }
        return arrayList;
    }

    public void maybeDeletePath(String zkUrl, String dir) {
        try {
            ZkClient zk = this.createZkClient(zkUrl, 30000, 30000);
            zk.deleteRecursive(dir);
            zk.close();
        }
        catch (Throwable throwable) {}
    }

    public String getTopicPath(String topic) {
        return this.BrokerTopicsPath() + "/" + topic;
    }

    public String getTopicPartitionsPath(String topic) {
        return this.getTopicPath(topic) + "/partitions";
    }

    public String getTopicPartitionPath(String topic, int partitionId) {
        return this.getTopicPartitionsPath(topic) + "/" + partitionId;
    }

    public String getTopicPartitionLeaderAndIsrPath(String topic, int partitionId) {
        return this.getTopicPartitionPath(topic, partitionId) + "/" + "state";
    }

    public String getEntityConfigRootPath(String entityType) {
        return this.EntityConfigPath() + "/" + entityType;
    }

    public String getEntityConfigPath(String entityType, String entity) {
        return this.getEntityConfigRootPath(entityType) + "/" + entity;
    }

    public String getEntityConfigPath(String entityPath) {
        return this.EntityConfigPath() + "/" + entityPath;
    }

    public String getDeleteTopicPath(String topic) {
        return this.DeleteTopicsPath() + "/" + topic;
    }

    public Seq<Tuple2<TopicAndPartition, Seq<Object>>> parsePartitionReassignmentDataWithoutDedup(String jsonData) {
        Seq seq;
        Option<Object> option = Json$.MODULE$.parseFull(jsonData);
        if (option instanceof Some) {
            Seq seq2;
            Some some = (Some)option;
            Object m = some.value();
            Option option2 = ((Map)m).get((Object)"partitions");
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Object partitionsSeq = some2.value();
                seq2 = (Seq)((Seq)partitionsSeq).map((Function1 & Serializable & scala.Serializable)p -> {
                    String topic = (String)p.get((Object)"topic").get();
                    int partition = BoxesRunTime.unboxToInt((Object)p.get((Object)"partition").get());
                    Seq newReplicas = (Seq)p.get((Object)"replicas").get();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicAndPartition(topic, partition)), (Object)newReplicas);
                }, Seq$.MODULE$.canBuildFrom());
            } else if (None$.MODULE$.equals(option2)) {
                seq2 = (Seq)Seq$.MODULE$.empty();
            } else {
                throw new MatchError((Object)option2);
            }
            seq = seq2;
        } else if (None$.MODULE$.equals(option)) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            throw new MatchError(option);
        }
        return seq;
    }

    public Map<TopicAndPartition, Seq<Object>> parsePartitionReassignmentData(String jsonData) {
        return this.parsePartitionReassignmentDataWithoutDedup(jsonData).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<String> parseTopicsData(String jsonData) {
        ObjectRef topics = ObjectRef.create((Object)List$.MODULE$.empty());
        Option<Object> option = Json$.MODULE$.parseFull(jsonData);
        if (option instanceof Some) {
            Some some = (Some)option;
            Object m = some.value();
            Option option2 = ((Map)m).get((Object)"topics");
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Object partitionsSeq = some2.value();
                Seq mapPartitionSeq = (Seq)partitionsSeq;
                mapPartitionSeq.foreach((Function1 & Serializable & scala.Serializable)p -> {
                    ZkUtils$.$anonfun$parseTopicsData$1(topics, p);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option2)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option2);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        return (List)topics.elem;
    }

    public String formatAsReassignmentJson(Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned) {
        return Json$.MODULE$.encode(Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitions"), partitionsToBeReassigned.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq replicas;
            TopicAndPartition topicAndPartition;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$1;
                    if (tuple2 == null) break block2;
                    topicAndPartition = (TopicAndPartition)tuple2._1();
                    replicas = (Seq)tuple2._2();
                    if (topicAndPartition != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            String topic = topicAndPartition.topic();
            int partition = topicAndPartition.partition();
            Map map = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)topic), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)partition)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"replicas"), (Object)replicas)}));
            return map;
        }, Iterable$.MODULE$.canBuildFrom()))})));
    }

    public static final /* synthetic */ void $anonfun$parseTopicsData$1(ObjectRef topics$1, Map p) {
        String topic = (String)p.get((Object)"topic").get();
        topics$1.elem = (List)((List)topics$1.elem).$plus$plus((GenTraversableOnce)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), List$.MODULE$.canBuildFrom());
    }

    private ZkUtils$() {
        MODULE$ = this;
        this.ConsumersPath = "/consumers";
        this.ClusterIdPath = "/cluster/id";
        this.BrokerIdsPath = "/brokers/ids";
        this.BrokerTopicsPath = "/brokers/topics";
        this.ControllerPath = "/controller";
        this.ControllerEpochPath = "/controller_epoch";
        this.ReassignPartitionsPath = "/admin/reassign_partitions";
        this.DeleteTopicsPath = "/admin/delete_topics";
        this.PreferredReplicaLeaderElectionPath = "/admin/preferred_replica_election";
        this.BrokerSequenceIdPath = "/brokers/seqid";
        this.IsrChangeNotificationPath = "/isr_change_notification";
        this.EntityConfigPath = "/config";
        this.EntityConfigChangesPath = "/config/changes";
    }
}

