/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaState;
import kafka.log.Log;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.LogDirFailureTest$Checkpoint$;
import kafka.server.LogDirFailureTest$Roll$;
import kafka.server.ReplicaFetcherThread;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IndexedSeqOptimized;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.VolatileObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001B\u001a5\u0001eBQ\u0001\u0011\u0001\u0005\u0002\u0005Cq\u0001\u0012\u0001C\u0002\u0013\u0005Q\t\u0003\u0004M\u0001\u0001\u0006IA\u0012\u0005\b\u001b\u0002\u0011\r\u0011\"\u0001F\u0011\u0019q\u0005\u0001)A\u0005\r\"9q\n\u0001b\u0001\n\u0003)\u0005B\u0002)\u0001A\u0003%a\tC\u0004R\u0001\t\u0007I\u0011\u0002*\t\rm\u0003\u0001\u0015!\u0003T\u0011\u001da\u0006A1A\u0005\n\u0015Ca!\u0018\u0001!\u0002\u00131\u0005b\u00020\u0001\u0005\u0004%\t%\u0012\u0005\u0007?\u0002\u0001\u000b\u0011\u0002$\t\u000b\u0001\u0004A\u0011I1\t\u000b9\u0004A\u0011A1\t\u000bM\u0004A\u0011A1\t\u000bU\u0004A\u0011A1\t\u000b]\u0004A\u0011A1\t\u000be\u0004A\u0011A1\t\u000bm\u0004A\u0011A1\t\u000bu\u0004A\u0011\u0001@\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\"9\u00111\u0014\u0001\u0005\n\u0005u\u0005bBAa\u0001\u0011%\u00111Y\u0004\b\u0003+!\u0004\u0012AA\f\r\u0019\u0019D\u0007#\u0001\u0002\u001a!1\u0001I\u0007C\u0001\u0003C1\u0011\"a\t\u001b!\u0003\r\n#!\n\b\u000f\u0005E%\u0004#!\u0002\b\u001a9\u0011\u0011\u0011\u000e\t\u0002\u0006\r\u0005B\u0002!\u001f\t\u0003\t)\t\u0003\u0005\u0002By\t\t\u0011\"\u0011S\u0011!\t\u0019EHA\u0001\n\u0003)\u0005\"CA#=\u0005\u0005I\u0011AAE\u0011%\t\u0019FHA\u0001\n\u0003\n)\u0006C\u0005\u0002dy\t\t\u0011\"\u0001\u0002\u000e\"I\u0011q\u000e\u0010\u0002\u0002\u0013\u0005\u0013\u0011\u000f\u0005\n\u0003gr\u0012\u0011!C!\u0003kB\u0011\"a\u001e\u001f\u0003\u0003%I!!\u001f\b\u000f\u0005M%\u0004#!\u0002@\u00199\u0011\u0011\u0006\u000e\t\u0002\u0006-\u0002B\u0002!*\t\u0003\ti\u0004\u0003\u0005\u0002B%\n\t\u0011\"\u0011S\u0011!\t\u0019%KA\u0001\n\u0003)\u0005\"CA#S\u0005\u0005I\u0011AA$\u0011%\t\u0019&KA\u0001\n\u0003\n)\u0006C\u0005\u0002d%\n\t\u0011\"\u0001\u0002f!I\u0011qN\u0015\u0002\u0002\u0013\u0005\u0013\u0011\u000f\u0005\n\u0003gJ\u0013\u0011!C!\u0003kB\u0011\"a\u001e*\u0003\u0003%I!!\u001f\u0003#1{w\rR5s\r\u0006LG.\u001e:f)\u0016\u001cHO\u0003\u00026m\u000511/\u001a:wKJT\u0011aN\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\b\u0005\u0002<}5\tAH\u0003\u0002>m\u0005\u0019\u0011\r]5\n\u0005}b$AF%oi\u0016<'/\u0019;j_:$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005\u0011\u0005CA\"\u0001\u001b\u0005!\u0014!\u00049s_\u0012,8-\u001a:D_VtG/F\u0001G!\t9%*D\u0001I\u0015\u0005I\u0015!B:dC2\f\u0017BA&I\u0005\rIe\u000e^\u0001\u000faJ|G-^2fe\u000e{WO\u001c;!\u00035\u0019wN\\:v[\u0016\u00148i\\;oi\u0006q1m\u001c8tk6,'oQ8v]R\u0004\u0013a\u00032s_.,'oQ8v]R\fAB\u0019:pW\u0016\u00148i\\;oi\u0002\nQ\u0001^8qS\u000e,\u0012a\u0015\t\u0003)fk\u0011!\u0016\u0006\u0003-^\u000bA\u0001\\1oO*\t\u0001,\u0001\u0003kCZ\f\u0017B\u0001.V\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\nA\u0002]1si&$\u0018n\u001c8Ok6\fQ\u0002]1si&$\u0018n\u001c8Ok6\u0004\u0013a\u00037pO\u0012K'oQ8v]R\fA\u0002\\8h\t&\u00148i\\;oi\u0002\nQa]3u+B$\u0012A\u0019\t\u0003\u000f\u000eL!\u0001\u001a%\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u001d\u0019\u0004\"a\u001a7\u000e\u0003!T!!\u001b6\u0002\u000b),h.\u001b;\u000b\u0003-\f1a\u001c:h\u0013\ti\u0007N\u0001\u0004CK\u001a|'/Z\u0001%i\u0016\u001cH\u000f\u0015:pIV\u001cW-\u0012:s_J4%o\\7GC&dWO]3P]2{wMU8mY\"\u0012q\u0002\u001d\t\u0003OFL!A\u001d5\u0003\tQ+7\u000f^\u0001\u001di\u0016\u001cH/S(Fq\u000e,\u0007\u000f^5p]\u0012+(/\u001b8h\u0019><'k\u001c7mQ\t\u0001\u0002/A\u001dce>\\WM],ji\"|E\u000eZ%oi\u0016\u0014(I]8lKJ\u0004&o\u001c;pG>d7\u000b[8vY\u0012D\u0015\r\u001c;P]2{w\rR5s\r\u0006LG.\u001e:fQ\t\t\u0002/A\u0014uKN$\bK]8ek\u000e,WI\u001d:pe\u001a\u0013x.\u001c$bS2,(/Z(o\u0007\",7m\u001b9pS:$\bF\u0001\nq\u0003}!Xm\u001d;J\u001f\u0016C8-\u001a9uS>tG)\u001e:j]\u001e\u001c\u0005.Z2la>Lg\u000e\u001e\u0015\u0003'A\fA\u0007^3tiJ+\u0007\u000f\\5dC\u001a+Go\u00195feRC'/Z1e\u0003\u001a$XM\u001d'pO\u0012K'OR1jYV\u0014Xm\u00148G_2dwn^3sQ\t!\u0002/\u0001\u0016uKN$\bK]8ek\u000e,WI\u001d:peN4%o\\7M_\u001e$\u0015N\u001d$bS2,(/Z(o\u0019\u0016\fG-\u001a:\u0015\u0005\t|\bbBA\u0001+\u0001\u0007\u00111A\u0001\fM\u0006LG.\u001e:f)f\u0004X\rE\u0002\u0002\u0006qq1!a\u0002\u001a\u001d\u0011\tI!a\u0005\u000f\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u00049\u0003\u0019a$o\\8u}%\tq'\u0003\u00026m\u0005\tBj\\4ESJ4\u0015-\u001b7ve\u0016$Vm\u001d;\u0011\u0005\rS2c\u0001\u000e\u0002\u001cA\u0019q)!\b\n\u0007\u0005}\u0001J\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003/\u0011\u0011\u0003T8h\t&\u0014h)Y5mkJ,G+\u001f9f'\ra\u00121D\u0015\u00049%r\"AC\"iK\u000e\\\u0007o\\5oiNI\u0011&a\u0007\u0002.\u0005E\u0012q\u0007\t\u0004\u0003_aR\"\u0001\u000e\u0011\u0007\u001d\u000b\u0019$C\u0002\u00026!\u0013q\u0001\u0015:pIV\u001cG\u000fE\u0002H\u0003sI1!a\u000fI\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\ty\u0004E\u0002\u00020%\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\u0018\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0013\ny\u0005E\u0002H\u0003\u0017J1!!\u0014I\u0005\r\te.\u001f\u0005\t\u0003#j\u0013\u0011!a\u0001\r\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0016\u0011\r\u0005e\u0013qLA%\u001b\t\tYFC\u0002\u0002^!\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t'a\u0017\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003O\ni\u0007E\u0002H\u0003SJ1!a\u001bI\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u00150\u0003\u0003\u0005\r!!\u0013\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012AR\u0001\ti>\u001cFO]5oOR\t1+A\u0006sK\u0006$'+Z:pYZ,GCAA>!\r!\u0016QP\u0005\u0004\u0003\u007f*&AB(cU\u0016\u001cGO\u0001\u0003S_2d7#\u0003\u0010\u0002\u001c\u00055\u0012\u0011GA\u001c)\t\t9\tE\u0002\u00020y!B!!\u0013\u0002\f\"A\u0011\u0011\u000b\u0012\u0002\u0002\u0003\u0007a\t\u0006\u0003\u0002h\u0005=\u0005\"CA)I\u0005\u0005\t\u0019AA%\u0003\u0011\u0011v\u000e\u001c7\u0002\u0015\rCWmY6q_&tG/A\u0013uKN$\bK]8ek\u000e,\u0017I\u001a;fe2{w\rR5s\r\u0006LG.\u001e:f\u001f:dU-\u00193feR\u0019!-!'\t\u000f\u0005\u0005a\u00031\u0001\u0002\u0004\u0005\u00112-Y;tK2{w\rR5s\r\u0006LG.\u001e:f)\u001d\u0011\u0017qTAQ\u0003WCq!!\u0001\u0018\u0001\u0004\t\u0019\u0001C\u0004\u0002$^\u0001\r!!*\u0002\u00191,\u0017\rZ3s'\u0016\u0014h/\u001a:\u0011\u0007\r\u000b9+C\u0002\u0002*R\u00121bS1gW\u0006\u001cVM\u001d<fe\"9\u0011QV\fA\u0002\u0005=\u0016!\u00039beRLG/[8o!\u0011\t\t,!0\u000e\u0005\u0005M&\u0002BA[\u0003o\u000baaY8n[>t'bA\u001c\u0002:*\u0019\u00111\u00186\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\ty,a-\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006i2/\u001e2tGJL'-Z!oI^\u000b\u0017\u000e\u001e$pe\u0006\u001b8/[4o[\u0016tG\u000fF\u0003c\u0003\u000b\f)\u000e\u0003\u0004R1\u0001\u0007\u0011q\u0019\t\u0005\u0003\u0013\f\tN\u0004\u0003\u0002L\u00065\u0007cAA\u0006\u0011&\u0019\u0011q\u001a%\u0002\rA\u0013X\rZ3g\u0013\rQ\u00161\u001b\u0006\u0004\u0003\u001fD\u0005bBAl1\u0001\u0007\u0011\u0011\\\u0001\tG>t7/^7feBA\u00111\\Ar\u0003O\f9/\u0004\u0002\u0002^*!\u0011q[Ap\u0015\u0011\t\t/a.\u0002\u000f\rd\u0017.\u001a8ug&!\u0011Q]Ao\u00055Y\u0015MZ6b\u0007>t7/^7feB)q)!;\u0002n&\u0019\u00111\u001e%\u0003\u000b\u0005\u0013(/Y=\u0011\u0007\u001d\u000by/C\u0002\u0002r\"\u0013AAQ=uK\u0002")
public class LogDirFailureTest
extends IntegrationTestHarness {
    private final int producerCount;
    private final int consumerCount;
    private final int brokerCount;
    private final String topic;
    private final int partitionNum;
    private final int logDirCount;

    public int producerCount() {
        return this.producerCount;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    private String topic() {
        return this.topic;
    }

    private int partitionNum() {
        return this.partitionNum;
    }

    @Override
    public int logDirCount() {
        return this.logDirCount;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.createTopic(this.topic(), this.partitionNum(), this.brokerCount(), this.createTopic$default$4());
    }

    @Test
    public void testProduceErrorFromFailureOnLogRoll() {
        this.testProduceErrorsFromLogDirFailureOnLeader(LogDirFailureTest$Roll$.MODULE$);
    }

    @Test
    public void testIOExceptionDuringLogRoll() {
        this.testProduceAfterLogDirFailureOnLeader(LogDirFailureTest$Roll$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure() {
        void setHaltProcedure_haltProcedure;
        VolatileObjectRef statusCodeOption = VolatileObjectRef.create((Object)None$.MODULE$);
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(statusCode, x$1) -> LogDirFailureTest.$anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$1(statusCodeOption, BoxesRunTime.unboxToInt((Object)statusCode), x$1);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setHaltProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        KafkaServer server = null;
        try {
            int x$12 = this.brokerCount();
            String x$2 = this.zkConnect();
            int x$3 = 3;
            boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
            boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
            int x$6 = TestUtils$.MODULE$.createBrokerConfig$default$5();
            Option<SecurityProtocol> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$6();
            Option<File> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$7();
            Option<Properties> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$8();
            boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$9();
            boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$10();
            int x$122 = TestUtils$.MODULE$.createBrokerConfig$default$11();
            boolean x$13 = TestUtils$.MODULE$.createBrokerConfig$default$12();
            int x$14 = TestUtils$.MODULE$.createBrokerConfig$default$13();
            boolean x$15 = TestUtils$.MODULE$.createBrokerConfig$default$14();
            int x$16 = TestUtils$.MODULE$.createBrokerConfig$default$15();
            Option<String> x$17 = TestUtils$.MODULE$.createBrokerConfig$default$16();
            boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
            int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
            short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
            Properties props = TestUtils$.MODULE$.createBrokerConfig(x$12, x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16, x$17, x$3, x$18, x$19, x$20);
            props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.11.0");
            props.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.11.0");
            KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
            File logDir = new File((String)kafkaConfig.logDirs().head());
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils.delete((File)logDir), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            logDir.createNewFile();
            Assert.assertTrue((boolean)logDir.isFile());
            server = TestUtils$.MODULE$.createServer(kafkaConfig, TestUtils$.MODULE$.createServer$default$2());
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!LogDirFailureTest.$anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$3(statusCodeOption)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    throw Assertions$.MODULE$.fail(LogDirFailureTest.$anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$4(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
                }
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
            }
        }
        catch (Throwable throwable) {
            Exit$.MODULE$.resetHaltProcedure();
            if (server != null) {
                TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)new .colon.colon(server, (List)Nil$.MODULE$));
            }
            throw throwable;
        }
        Exit$.MODULE$.resetHaltProcedure();
        if (server != null) {
            TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        }
    }

    @Test
    public void testProduceErrorFromFailureOnCheckpoint() {
        this.testProduceErrorsFromLogDirFailureOnLeader(LogDirFailureTest$Checkpoint$.MODULE$);
    }

    @Test
    public void testIOExceptionDuringCheckpoint() {
        this.testProduceAfterLogDirFailureOnLeader(LogDirFailureTest$Checkpoint$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReplicaFetcherThreadAfterLogDirFailureOnFollower() {
        void find_p;
        this.producerConfig().setProperty("retries", "0");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        PartitionInfo partitionInfo = (PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(x$2))).get();
        int leaderServerId = partitionInfo.leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(leaderServerId, x$3))).get();
        JFunction1.mcZI.sp & Serializable & scala.Serializable intersect = (JFunction1.mcZI.sp & Serializable & scala.Serializable)x$5 -> x$5 != leaderServerId;
        ArrayOps.ofInt find_this = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])TraversableLike.map$((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas())), (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), (CanBuildFrom)Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))));
        int find_i = find_this.prefixLength(arg_0 -> IndexedSeqOptimized.$anonfun$find$1$adapted((Function1)find_p, arg_0));
        Object object = find_i < find_this.length() ? new Some(find_this.apply(find_i)) : None$.MODULE$;
        int followerServerId = BoxesRunTime.unboxToInt((Object)object.get());
        KafkaServer followerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(followerServerId, x$6))).get();
        followerServer.replicaManager().markPartitionOffline(partition);
        int n = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        int anotherPartitionWithTheSameLeader = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension0(n, this.partitionNum()).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> {
            Option option = leaderServer.replicaManager().nonOfflinePartition(new TopicPartition(this.topic(), i));
            if (option == null) {
                throw null;
            }
            Option flatMap_this = option;
            Object object = flatMap_this.isEmpty() ? None$.MODULE$ : ((Partition)flatMap_this.get()).leaderLogIfLocal();
            return object.isDefined();
        }).get());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(anotherPartitionWithTheSameLeader), (Object)this.topic().getBytes(), (Object)"message".getBytes());
        producer.send(record).get();
        Assert.assertEquals((long)this.brokerCount(), (long)((Partition)leaderServer.replicaManager().nonOfflinePartition(new TopicPartition(this.topic(), anotherPartitionWithTheSameLeader)).get()).inSyncReplicaIds().size());
        followerServer.replicaManager().replicaFetcherManager().fetcherThreadMap().values().foreach((Function1 & Serializable & scala.Serializable)thread -> {
            LogDirFailureTest.$anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(thread);
            return BoxedUnit.UNIT;
        });
    }

    public void testProduceErrorsFromLogDirFailureOnLeader(LogDirFailureType failureType) {
        this.producerConfig().setProperty("retries", "0");
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        int leaderServerId = ((PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceErrorsFromLogDirFailureOnLeader$1(x$8))).get()).leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceErrorsFromLogDirFailureOnLeader$2(leaderServerId, x$9))).get();
        this.causeLogDirFailure(failureType, leaderServer, partition);
        try {
            producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
            throw Assertions$.MODULE$.fail("send() should fail with either KafkaStorageException or NotLeaderForPartitionException", new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof KafkaStorageException) {
                return;
            }
            if (throwable instanceof NotLeaderForPartitionException) {
                return;
            }
            if (throwable != null) {
                throw Assertions$.MODULE$.fail(new StringBuilder(98).append("send() should fail with either KafkaStorageException or NotLeaderForPartitionException instead of ").append(throwable.toString()).toString(), new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            }
            throw new MatchError(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void testProduceAfterLogDirFailureOnLeader(LogDirFailureType failureType) {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        TopicPartition partition = new TopicPartition(this.topic(), 0);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        int leaderServerId = ((PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$1(x$10))).get()).leader().id();
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$2(leaderServerId, x$11))).get();
        producer.send(record).get();
        TestUtils$.MODULE$.consumeRecords(consumer, 1, TestUtils$.MODULE$.consumeRecords$default$3());
        this.causeLogDirFailure(failureType, leaderServer, partition);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 6000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$3(this, producer, record, leaderServerId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$5(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        producer.send(record).get(6000L, TimeUnit.MILLISECONDS);
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, 1, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
        Assert.assertTrue((boolean)this.zkClient().getAllLogDirEventNotifications().isEmpty());
        Assert.assertTrue((boolean)((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$6(x$13))).get()).kafkaController().controllerContext().replicasInState(this.topic(), (ReplicaState)OfflineReplica$.MODULE$).contains((Object)new PartitionAndReplica(new TopicPartition(this.topic(), 0), leaderServerId)));
    }

    /*
     * WARNING - void declaration
     */
    private void causeLogDirFailure(LogDirFailureType failureType, KafkaServer leaderServer, TopicPartition partition) {
        File logDir = leaderServer.replicaManager().localLogOrException(partition).dir().getParentFile();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils.delete((File)logDir), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        logDir.createNewFile();
        Assert.assertTrue((boolean)logDir.isFile());
        LogDirFailureType logDirFailureType = failureType;
        LogDirFailureTest$Roll$ logDirFailureTest$Roll$ = LogDirFailureTest$Roll$.MODULE$;
        if (!(logDirFailureType != null ? !logDirFailureType.equals(logDirFailureTest$Roll$) : logDirFailureTest$Roll$ != null)) {
            try {
                Log qual$1 = (Log)leaderServer.replicaManager().getLog(partition).get();
                Option x$1 = qual$1.roll$default$1();
                qual$1.roll(x$1);
                throw Assertions$.MODULE$.fail("Log rolling should fail with KafkaStorageException", new Position("LogDirFailureTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
            }
            catch (KafkaStorageException kafkaStorageException) {}
        } else {
            LogDirFailureType logDirFailureType2 = failureType;
            LogDirFailureTest$Checkpoint$ logDirFailureTest$Checkpoint$ = LogDirFailureTest$Checkpoint$.MODULE$;
            if (!(logDirFailureType2 != null ? !logDirFailureType2.equals(logDirFailureTest$Checkpoint$) : logDirFailureTest$Checkpoint$ != null)) {
                leaderServer.replicaManager().checkpointHighWatermarks();
            }
        }
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 3000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogDirFailureTest.$anonfun$causeLogDirFailure$2(leaderServer, logDir)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(LogDirFailureTest.$anonfun$causeLogDirFailure$3(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        Assert.assertTrue((boolean)leaderServer.replicaManager().localLog(partition).isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        void pollUntilTrue_action;
        consumer.subscribe(Collections.singletonList(topic));
        long l = TestUtils$.MODULE$.pollUntilTrue$default$4();
        JFunction0.mcZ.sp & Serializable & scala.Serializable intersect = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !consumer.assignment().isEmpty();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long pollUntilTrue_x$3 = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollUntilTrue$1(consumer, (Function0)pollUntilTrue_action)) {
            void pollUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(LogDirFailureTest.$anonfun$subscribeAndWaitForAssignment$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)pollUntilTrue_waitTimeMs, pollUntilTrue_x$3));
        }
    }

    public static final /* synthetic */ Nothing$ $anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$1(VolatileObjectRef statusCodeOption$1, int statusCode, Option x$1) {
        statusCodeOption$1.elem = new Some((Object)BoxesRunTime.boxToInteger((int)statusCode));
        throw new IllegalArgumentException();
    }

    public static final /* synthetic */ boolean $anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$3(VolatileObjectRef statusCodeOption$1) {
        return ((Option)statusCodeOption$1.elem).contains((Object)BoxesRunTime.boxToInteger((int)1));
    }

    public static final /* synthetic */ String $anonfun$brokerWithOldInterBrokerProtocolShouldHaltOnLogDirFailure$4() {
        return "timed out waiting for broker to halt";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$1(PartitionInfo x$2) {
        return x$2.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$2(int leaderServerId$1, KafkaServer x$3) {
        return x$3.config().brokerId() == leaderServerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$5(int followerServerId$1, KafkaServer x$6) {
        return x$6.config().brokerId() == followerServerId$1;
    }

    public static final /* synthetic */ void $anonfun$testReplicaFetcherThreadAfterLogDirFailureOnFollower$8(ReplicaFetcherThread thread) {
        Assert.assertFalse((String)"ReplicaFetcherThread should still be working if its partition count > 0", (boolean)thread.isShutdownComplete());
    }

    public static final /* synthetic */ boolean $anonfun$testProduceErrorsFromLogDirFailureOnLeader$1(PartitionInfo x$8) {
        return x$8.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceErrorsFromLogDirFailureOnLeader$2(int leaderServerId$2, KafkaServer x$9) {
        return x$9.config().brokerId() == leaderServerId$2;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$1(PartitionInfo x$10) {
        return x$10.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$2(int leaderServerId$3, KafkaServer x$11) {
        return x$11.config().brokerId() == leaderServerId$3;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$4(PartitionInfo x$12) {
        return x$12.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$3(LogDirFailureTest $this, KafkaProducer producer$1, ProducerRecord record$1, int leaderServerId$3) {
        producer$1.send(record$1);
        return ((PartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(producer$1.partitionsFor($this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)LogDirFailureTest.$anonfun$testProduceAfterLogDirFailureOnLeader$4(x$12))).get()).leader().id() != leaderServerId$3;
    }

    public static final /* synthetic */ String $anonfun$testProduceAfterLogDirFailureOnLeader$5() {
        return "Expected new leader for the partition";
    }

    public static final /* synthetic */ boolean $anonfun$testProduceAfterLogDirFailureOnLeader$6(KafkaServer x$13) {
        return x$13.kafkaController().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$causeLogDirFailure$2(KafkaServer leaderServer$2, File logDir$2) {
        return !leaderServer$2.logManager().isLogDirOnline(logDir$2.getAbsolutePath());
    }

    public static final /* synthetic */ String $anonfun$causeLogDirFailure$3() {
        return "Expected log directory offline";
    }

    public static final /* synthetic */ String $anonfun$subscribeAndWaitForAssignment$2() {
        return "Expected non-empty assignment";
    }

    public LogDirFailureTest() {
        this.producerCount = 1;
        this.consumerCount = 1;
        this.brokerCount = 2;
        this.topic = "topic";
        this.partitionNum = 12;
        this.logDirCount = 3;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ReplicaHighWatermarkCheckpointIntervalMsProp(), "60000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "1");
    }

    public static interface LogDirFailureType {
    }
}

