/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.log.ProducerStateEntry;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005d\u0001\u0002\u001b6\u0001iBQ!\u0011\u0001\u0005\u0002\tCq!\u0012\u0001C\u0002\u0013\u0005a\t\u0003\u0004N\u0001\u0001\u0006Ia\u0012\u0005\b\u001d\u0002\u0011\r\u0011\"\u0001G\u0011\u0019y\u0005\u0001)A\u0005\u000f\"9\u0001\u000b\u0001b\u0001\n\u00031\u0005BB)\u0001A\u0003%q\tC\u0004S\u0001\t\u0007I\u0011\u0001$\t\rM\u0003\u0001\u0015!\u0003H\u0011\u001d!\u0006A1A\u0005\u0002UCaA\u0018\u0001!\u0002\u00131\u0006bB0\u0001\u0005\u0004%\t!\u0016\u0005\u0007A\u0002\u0001\u000b\u0011\u0002,\t\u000f\u0005\u0004!\u0019!C\u0001\r\"1!\r\u0001Q\u0001\n\u001dCqa\u0019\u0001C\u0002\u0013\u0005A\rC\u0004\u0002\u0002\u0001\u0001\u000b\u0011B3\t\u0013\u0005\r\u0001A1A\u0005\u0002\u0005\u0015\u0001\u0002CA\u000b\u0001\u0001\u0006I!a\u0002\t\u0013\u0005]\u0001A1A\u0005\u0002\u0005\u0015\u0001\u0002CA\r\u0001\u0001\u0006I!a\u0002\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u001e!9\u00111\u0007\u0001\u0005B\u0005U\u0002bBA&\u0001\u0011\u0005\u0013Q\u0007\u0005\b\u0003+\u0002A\u0011AA\u001b\u0011\u001d\ty\u0006\u0001C\u0001\u0003kAq!a\u0019\u0001\t\u0003\t)\u0004C\u0004\u0002h\u0001!\t!!\u000e\t\u000f\u0005-\u0004\u0001\"\u0001\u00026!9\u0011q\u000e\u0001\u0005\n\u0005E\u0004bBAI\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003+\u0003A\u0011AA\u001b\u0011\u001d\tI\n\u0001C\u0001\u0003kAq!!(\u0001\t\u0003\t)\u0004C\u0004\u0002\"\u0002!\t!!\u000e\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u00026!9\u0011\u0011\u0016\u0001\u0005\u0002\u0005U\u0002bBAW\u0001\u0011\u0005\u0011Q\u0007\u0005\b\u0003\u0003\u0004A\u0011AA\u001b\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003kAq!a6\u0001\t\u0013\tI\u000eC\u0004\u0002t\u0002!I!!>\t\u000f\t\r\u0001\u0001\"\u0003\u0003\u0006!I!1\u0003\u0001\u0012\u0002\u0013%!Q\u0003\u0005\n\u0005W\u0001\u0011\u0013!C\u0005\u0005[A\u0011B!\r\u0001#\u0003%IAa\r\t\u000f\t]\u0002\u0001\"\u0003\u0003:!9!Q\b\u0001\u0005\n\t}\u0002\"\u0003B,\u0001E\u0005I\u0011\u0002B-\u0011%\u0011i\u0006AI\u0001\n\u0013\u0011I\u0006C\u0005\u0003`\u0001\t\n\u0011\"\u0003\u0003.\t\u0001BK]1og\u0006\u001cG/[8ogR+7\u000f\u001e\u0006\u0003m]\n1!\u00199j\u0015\u0005A\u0014!B6bM.\f7\u0001A\n\u0003\u0001m\u0002\"\u0001P \u000e\u0003uR!AP\u001c\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003\u0001v\u0012acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0003\"\u0001\u0012\u0001\u000e\u0003U\n!B\\;n'\u0016\u0014h/\u001a:t+\u00059\u0005C\u0001%L\u001b\u0005I%\"\u0001&\u0002\u000bM\u001c\u0017\r\\1\n\u00051K%aA%oi\u0006Ya.^7TKJ4XM]:!\u0003i!(/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ\u001cu.\u001e8u\u0003m!(/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ\u001cu.\u001e8uA\u0005QBO]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148i\\;oi\u0006YBO]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148i\\;oi\u0002\nQD\\8o)J\fgn]1di&|g.\u00197D_:\u001cX/\\3s\u0007>,h\u000e^\u0001\u001f]>tGK]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148i\\;oi\u0002\na\u0001^8qS\u000e\fT#\u0001,\u0011\u0005]cV\"\u0001-\u000b\u0005eS\u0016\u0001\u00027b]\u001eT\u0011aW\u0001\u0005U\u00064\u0018-\u0003\u0002^1\n11\u000b\u001e:j]\u001e\fq\u0001^8qS\u000e\f\u0004%\u0001\u0004u_BL7MM\u0001\bi>\u0004\u0018n\u0019\u001a!\u00035qW/\u001c)beRLG/[8og\u0006qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0013A\u0006;sC:\u001c\u0018m\u0019;j_:\fG\u000e\u0015:pIV\u001cWM]:\u0016\u0003\u0015\u00042AZ6n\u001b\u00059'B\u00015j\u0003\u001diW\u000f^1cY\u0016T!A[%\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002mO\n1!)\u001e4gKJ\u0004BA\u001c={u6\tqN\u0003\u0002qc\u0006A\u0001O]8ek\u000e,'O\u0003\u0002sg\u000691\r\\5f]R\u001c(B\u0001\u001du\u0015\t)h/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002o\u0006\u0019qN]4\n\u0005e|'!D&bM.\f\u0007K]8ek\u000e,'\u000fE\u0002IwvL!\u0001`%\u0003\u000b\u0005\u0013(/Y=\u0011\u0005!s\u0018BA@J\u0005\u0011\u0011\u0015\u0010^3\u0002/Q\u0014\u0018M\\:bGRLwN\\1m!J|G-^2feN\u0004\u0013A\u0006;sC:\u001c\u0018m\u0019;j_:\fGnQ8ogVlWM]:\u0016\u0005\u0005\u001d\u0001\u0003\u00024l\u0003\u0013\u0001b!a\u0003\u0002\u0012iTXBAA\u0007\u0015\r\ty!]\u0001\tG>t7/^7fe&!\u00111CA\u0007\u00055Y\u0015MZ6b\u0007>t7/^7fe\u00069BO]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148\u000fI\u0001\u001a]>tGK]1og\u0006\u001cG/[8oC2\u001cuN\\:v[\u0016\u00148/\u0001\u000eo_:$&/\u00198tC\u000e$\u0018n\u001c8bY\u000e{gn];nKJ\u001c\b%A\bhK:,'/\u0019;f\u0007>tg-[4t+\t\ty\u0002\u0005\u0004\u0002\"\u0005\r\u0012qE\u0007\u0002S&\u0019\u0011QE5\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\r\ticN\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005E\u00121\u0006\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0003tKR,\u0006\u000f\u0006\u0002\u00028A\u0019\u0001*!\u000f\n\u0007\u0005m\u0012J\u0001\u0003V]&$\bfA\f\u0002@A!\u0011\u0011IA$\u001b\t\t\u0019EC\u0002\u0002FY\fQA[;oSRLA!!\u0013\u0002D\t1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u00041\u0005=\u0003\u0003BA!\u0003#JA!a\u0015\u0002D\t)\u0011I\u001a;fe\u0006)B/Z:u\u0005\u0006\u001c\u0018n\u0019+sC:\u001c\u0018m\u0019;j_:\u001c\bfA\r\u0002ZA!\u0011\u0011IA.\u0013\u0011\ti&a\u0011\u0003\tQ+7\u000f^\u00013i\u0016\u001cHOU3bI\u000e{W.\\5ui\u0016$7i\u001c8tk6,'o\u00155pk2$gj\u001c;TK\u0016,f\u000eZ3dS\u0012,G\rR1uC\"\u001a!$!\u0017\u0002UQ,7\u000f\u001e#fY\u0006LX\r\u001a$fi\u000eD\u0017J\\2mk\u0012,7/\u00112peR,G\r\u0016:b]N\f7\r^5p]\"\u001a1$!\u0017\u00025Q,7\u000f^*f]\u0012|eMZ:fiN<\u0016\u000e\u001e5He>,\b/\u00133)\u0007q\tI&\u0001\u0011uKN$8+\u001a8e\u001f\u001a47/\u001a;t/&$\bn\u0012:pkBlU\r^1eCR\f\u0007fA\u000f\u0002Z\u0005Q1/\u001a8e\u001f\u001a47/\u001a;\u0015\t\u0005]\u00121\u000f\u0005\b\u0003kr\u0002\u0019AA<\u0003\u0019\u0019w.\\7jiBQ\u0001*!\u001fn\u0003{\nI!a\u000e\n\u0007\u0005m\u0014JA\u0005Gk:\u001cG/[8ogA!\u0011qPAG\u001d\u0011\t\t)!#\u0011\u0007\u0005\r\u0015*\u0004\u0002\u0002\u0006*\u0019\u0011qQ\u001d\u0002\rq\u0012xn\u001c;?\u0013\r\tY)S\u0001\u0007!J,G-\u001a4\n\u0007u\u000byIC\u0002\u0002\f&\u000b1\u0003^3ti\u001a+gnY5oO>s7i\\7nSRD3aHA-\u0003a!Xm\u001d;GK:\u001c\u0017N\\4P]N+g\u000eZ(gMN,Go\u001d\u0015\u0004A\u0005e\u0013\u0001\f;fgR|eMZ:fi6+G/\u00193bi\u0006LenU3oI>3gm]3ugR{GK]1og\u0006\u001cG/[8oQ\r\t\u0013\u0011L\u0001\u0012i\u0016\u001cHOR3oG&twm\u00148TK:$\u0007f\u0001\u0012\u0002Z\u0005QB/Z:u\r\u0016t7-\u001b8h\u001f:\fE\r\u001a)beRLG/[8og\"\u001a1%!\u0017\u0002EQ,7\u000f\u001e$f]\u000eLgnZ(o)J\fgn]1di&|g.\u0012=qSJ\fG/[8oQ\r!\u0013\u0011L\u0001\u001di\u0016\u001cH/T;mi&\u0004H.Z'be.,'o](oK2+\u0017\rZ3sQ\r)\u0013\u0011L\u0001%i\u0016\u001cHoQ8og\u0016\u001cW\u000f^5wK2L(+\u001e8J]&$HK]1og\u0006\u001cG/[8og\":a%!\u0017\u00022\u0006M\u0016\u0001C3ya\u0016\u001cG/\u001a3$\u0005\u0005U\u0006\u0003BA\\\u0003{k!!!/\u000b\u0007\u0005m6/\u0001\u0004d_6lwN\\\u0005\u0005\u0003\u007f\u000bIL\u0001\bLC\u001a\\\u0017-\u0012=dKB$\u0018n\u001c8\u00029Q,7\u000f^\"p[6LG\u000f\u0016:b]N\f7\r^5p]RKW.Z8vi\":q%!\u0017\u00022\u0006\u00157EAAd!\u0011\tI-a4\u000e\u0005\u0005-'\u0002BAg\u0003s\u000ba!\u001a:s_J\u001c\u0018\u0002BAi\u0003\u0017\u0014\u0001\u0003V5nK>,H/\u0012=dKB$\u0018n\u001c8\u00025Q,7\u000f\u001e\"v[B$&/\u00198tC\u000e$\u0018n\u001c8bY\u0016\u0003xn\u00195)\u0007!\nI&A\u0014tK:$GK]1og\u0006\u001cG/[8oC2lUm]:bO\u0016\u001cx+\u001b;i-\u0006dW/\u001a*b]\u001e,G\u0003DA\u001c\u00037\fi.!9\u0002f\u0006%\b\"\u00029*\u0001\u0004i\u0007bBApS\u0001\u0007\u0011QP\u0001\u0006i>\u0004\u0018n\u0019\u0005\u0007\u0003GL\u0003\u0019A$\u0002\u000bM$\u0018M\u001d;\t\r\u0005\u001d\u0018\u00061\u0001H\u0003\r)g\u000e\u001a\u0005\b\u0003WL\u0003\u0019AAw\u0003=9\u0018\u000e\u001c7CK\u000e{W.\\5ui\u0016$\u0007c\u0001%\u0002p&\u0019\u0011\u0011_%\u0003\u000f\t{w\u000e\\3b]\u0006Y1/\u001a:wKJ\u0004&o\u001c9t)\t\t9\u0010\u0005\u0003\u0002z\u0006}XBAA~\u0015\r\tiPW\u0001\u0005kRLG.\u0003\u0003\u0003\u0002\u0005m(A\u0003)s_B,'\u000f^5fg\u0006Y2M]3bi\u0016\u0014V-\u00193D_6l\u0017\u000e\u001e;fI\u000e{gn];nKJ$\u0002\"!\u0003\u0003\b\t-!q\u0002\u0005\n\u0005\u0013Y\u0003\u0013!a\u0001\u0003{\nQa\u001a:pkBD\u0001B!\u0004,!\u0003\u0005\raR\u0001\u000f[\u0006D\bk\u001c7m%\u0016\u001cwN\u001d3t\u0011%\u0011\tb\u000bI\u0001\u0002\u0004\t90A\u0003qe>\u00048/A\u0013de\u0016\fG/\u001a*fC\u0012\u001cu.\\7jiR,GmQ8ogVlWM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!q\u0003\u0016\u0005\u0003{\u0012Ib\u000b\u0002\u0003\u001cA!!Q\u0004B\u0014\u001b\t\u0011yB\u0003\u0003\u0003\"\t\r\u0012!C;oG\",7m[3e\u0015\r\u0011)#S\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0015\u0005?\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0015\u001a'/Z1uKJ+\u0017\rZ\"p[6LG\u000f^3e\u0007>t7/^7fe\u0012\"WMZ1vYR$#'\u0006\u0002\u00030)\u001aqI!\u0007\u0002K\r\u0014X-\u0019;f%\u0016\fGmQ8n[&$H/\u001a3D_:\u001cX/\\3sI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u001bU\u0011\t9P!\u0007\u0002;\r\u0014X-\u0019;f%\u0016\fG-\u00168d_6l\u0017\u000e\u001e;fI\u000e{gn];nKJ$B!!\u0003\u0003<!9!\u0011B\u0018A\u0002\u0005u\u0014aG2sK\u0006$X\r\u0016:b]N\f7\r^5p]\u0006d\u0007K]8ek\u000e,'\u000fF\u0005n\u0005\u0003\u0012)Ea\u0014\u0003T!9!1\t\u0019A\u0002\u0005u\u0014a\u0004;sC:\u001c\u0018m\u0019;j_:\fG.\u00133\t\u0013\t\u001d\u0003\u0007%AA\u0002\t%\u0013\u0001\u0006;sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRl5\u000fE\u0002I\u0005\u0017J1A!\u0014J\u0005\u0011auN\\4\t\u0013\tE\u0003\u0007%AA\u0002\t%\u0013AC7bq\ncwnY6Ng\"A!Q\u000b\u0019\u0011\u0002\u0003\u0007q)A\teK2Lg/\u001a:z)&lWm\\;u\u001bN\fQe\u0019:fCR,GK]1og\u0006\u001cG/[8oC2\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tm#\u0006\u0002B%\u00053\tQe\u0019:fCR,GK]1og\u0006\u001cG/[8oC2\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002K\r\u0014X-\u0019;f)J\fgn]1di&|g.\u00197Qe>$WoY3sI\u0011,g-Y;mi\u0012\"\u0004")
public class TransactionsTest
extends KafkaServerTestHarness {
    private final int numServers;
    private final int transactionalProducerCount;
    private final int transactionalConsumerCount;
    private final int nonTransactionalConsumerCount;
    private final String topic1;
    private final String topic2;
    private final int numPartitions;
    private final Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Buffer<KafkaConsumer<byte[], byte[]>> transactionalConsumers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Buffer<KafkaConsumer<byte[], byte[]>> nonTransactionalConsumers = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);

    public int numServers() {
        return this.numServers;
    }

    public int transactionalProducerCount() {
        return this.transactionalProducerCount;
    }

    public int transactionalConsumerCount() {
        return this.transactionalConsumerCount;
    }

    public int nonTransactionalConsumerCount() {
        return this.nonTransactionalConsumerCount;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public Buffer<KafkaProducer<byte[], byte[]>> transactionalProducers() {
        return this.transactionalProducers;
    }

    public Buffer<KafkaConsumer<byte[], byte[]>> transactionalConsumers() {
        return this.transactionalConsumers;
    }

    public Buffer<KafkaConsumer<byte[], byte[]>> nonTransactionalConsumers() {
        return this.nonTransactionalConsumers;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.serverProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        this.createTopic(this.topic1(), this.numPartitions(), this.numServers(), topicConfig);
        this.createTopic(this.topic2(), this.numPartitions(), this.numServers(), topicConfig);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, this.transactionalProducerCount());
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                this.createTransactionalProducer("transactional-producer", this.createTransactionalProducer$default$2(), this.createTransactionalProducer$default$3(), this.createTransactionalProducer$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        int n2 = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range2 = RichInt$.MODULE$.until$extension0(n2, this.transactionalConsumerCount());
        if (range2 == null) {
            throw null;
        }
        Range foreach_this2 = range2;
        if (!foreach_this2.isEmpty()) {
            int foreach_i = foreach_this2.start();
            while (true) {
                this.createReadCommittedConsumer("transactional-group", this.createReadCommittedConsumer$default$2(), this.createReadCommittedConsumer$default$3());
                if (foreach_i == foreach_this2.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this2.step();
            }
        }
        int n3 = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range3 = RichInt$.MODULE$.until$extension0(n3, this.nonTransactionalConsumerCount());
        if (range3 == null) {
            throw null;
        }
        Range foreach_this3 = range3;
        if (!foreach_this3.isEmpty()) {
            int foreach_i = foreach_this3.start();
            while (true) {
                this.createReadUncommittedConsumer("non-transactional-group");
                if (foreach_i == foreach_this3.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this3.step();
            }
        }
    }

    @Override
    @After
    public void tearDown() {
        this.transactionalProducers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        this.transactionalConsumers().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        this.nonTransactionalConsumers().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    @Test
    public void testBasicTransactions() {
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        KafkaConsumer unCommittedConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", false));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "4", "4", false));
        producer.flush();
        producer.abortTransaction();
        producer.beginTransaction();
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", true));
        producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", true));
        producer.commitTransaction();
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        unCommittedConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 4, TestUtils$.MODULE$.consumeRecords$default$3());
        scala.collection.immutable.Set expectedValues = new .colon.colon((Object)"1", (List)new .colon.colon((Object)"2", (List)new .colon.colon((Object)"3", (List)new .colon.colon((Object)"4", (List)Nil$.MODULE$)))).toSet();
        allRecords.foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsTest.$anonfun$testBasicTransactions$2(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReadCommittedConsumerShouldNotSeeUndecidedData() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", this.createTransactionalProducer$default$2(), this.createTransactionalProducer$default$3(), this.createTransactionalProducer$default$4());
        KafkaConsumer readCommittedConsumer = (KafkaConsumer)this.transactionalConsumers().head();
        KafkaConsumer readUncommittedConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        long latestVisibleTimestamp = System.currentTimeMillis();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestVisibleTimestamp), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        long latestWrittenTimestamp = latestVisibleTimestamp + 1L;
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"a".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"b".getBytes(), (Object)"2".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"c".getBytes(), (Object)"3".getBytes()));
        producer1.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"d".getBytes(), (Object)"4".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.send(new ProducerRecord(this.topic2(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(latestWrittenTimestamp), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.commitTransaction();
        TopicPartition tp1 = new TopicPartition(this.topic1(), 0);
        TopicPartition tp2 = new TopicPartition(this.topic2(), 0);
        readUncommittedConsumer.assign((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        TestUtils$.MODULE$.consumeRecords(readUncommittedConsumer, 8, TestUtils$.MODULE$.consumeRecords$default$3());
        Tuple2[] tuple2Array = new Tuple2[2];
        Long l = Predef$.MODULE$.long2Long(latestWrittenTimestamp);
        Object object = Predef$.MODULE$.ArrowAssoc((Object)tp1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        Long l2 = Predef$.MODULE$.long2Long(latestWrittenTimestamp);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)tp2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        java.util.Map readUncommittedOffsetsForTimes = readUncommittedConsumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava());
        Assert.assertEquals((long)2L, (long)readUncommittedOffsetsForTimes.size());
        Assert.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp1)).timestamp());
        Assert.assertEquals((long)latestWrittenTimestamp, (long)((OffsetAndTimestamp)readUncommittedOffsetsForTimes.get(tp2)).timestamp());
        readUncommittedConsumer.unsubscribe();
        readCommittedConsumer.assign((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2}))).asJava());
        TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsTest.$anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(record);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)2L, (long)readCommittedConsumer.assignment().size());
        readCommittedConsumer.seekToEnd((Collection)readCommittedConsumer.assignment());
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(readCommittedConsumer.assignment()).asScala()).foreach((Function1 & Serializable & scala.Serializable)tp -> {
            TransactionsTest.$anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$2(readCommittedConsumer, tp);
            return BoxedUnit.UNIT;
        });
        Tuple2[] tuple2Array2 = new Tuple2[2];
        Long l3 = Predef$.MODULE$.long2Long(latestWrittenTimestamp);
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)tp1);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Long l4 = Predef$.MODULE$.long2Long(latestWrittenTimestamp);
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)tp2);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        java.util.Map readCommittedOffsetsForTimes = readCommittedConsumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava());
        Assert.assertNull(readCommittedOffsetsForTimes.get(tp1));
        Assert.assertNull(readCommittedOffsetsForTimes.get(tp2));
    }

    @Test
    public void testDelayedFetchIncludesAbortedTransaction() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().head();
        KafkaProducer<byte[], byte[]> producer2 = this.createTransactionalProducer("other", this.createTransactionalProducer$default$2(), this.createTransactionalProducer$default$3(), this.createTransactionalProducer$default$4());
        producer1.initTransactions();
        producer2.initTransactions();
        producer1.beginTransaction();
        producer2.beginTransaction();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"1".getBytes()));
        producer2.flush();
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"1".getBytes()));
        producer1.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"y".getBytes(), (Object)"2".getBytes()));
        producer1.flush();
        producer2.send(new ProducerRecord(this.topic1(), Predef$.MODULE$.int2Integer(0), (Object)"x".getBytes(), (Object)"2".getBytes()));
        producer2.flush();
        producer1.abortTransaction();
        producer2.commitTransaction();
        Properties consumerProps = new Properties();
        consumerProps.put("fetch.min.bytes", "100000");
        consumerProps.put("fetch.max.wait.ms", "100");
        String x$2 = this.createReadCommittedConsumer$default$1();
        int x$3 = this.createReadCommittedConsumer$default$2();
        KafkaConsumer<byte[], byte[]> readCommittedConsumer = this.createReadCommittedConsumer(x$2, x$3, consumerProps);
        readCommittedConsumer.assign((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic1(), 0)}))).asJava());
        Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.consumeRecords(readCommittedConsumer, 2, TestUtils$.MODULE$.consumeRecords$default$3());
        Assert.assertEquals((long)2L, (long)records.size());
        ConsumerRecord first = (ConsumerRecord)records.head();
        Assert.assertEquals((Object)"x", (Object)new String((byte[])first.key()));
        Assert.assertEquals((Object)"1", (Object)new String((byte[])first.value()));
        Assert.assertEquals((long)0L, (long)first.offset());
        ConsumerRecord second = (ConsumerRecord)records.last();
        Assert.assertEquals((Object)"x", (Object)new String((byte[])second.key()));
        Assert.assertEquals((Object)"2", (Object)new String((byte[])second.value()));
        Assert.assertEquals((long)3L, (long)second.offset());
    }

    @Test
    public void testSendOffsetsWithGroupId() {
        String sendOffset_consumerGroupId = "foobar-consumer-group";
        int sendOffset_numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), sendOffset_numSeedMessages, (Seq<KafkaServer>)this.servers());
        KafkaProducer sendOffset_producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer<byte[], byte[]> sendOffset_consumer = this.createReadCommittedConsumer(sendOffset_consumerGroupId, sendOffset_numSeedMessages / 4, this.createReadCommittedConsumer$default$3());
        sendOffset_consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        sendOffset_producer.initTransactions();
        BooleanRef sendOffset_shouldCommit = BooleanRef.create((boolean)false);
        IntRef sendOffset_recordsProcessed = IntRef.create((int)0);
        try {
            while (sendOffset_recordsProcessed.elem < sendOffset_numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> sendOffset_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_consumer, Math.min(10, sendOffset_numSeedMessages - sendOffset_recordsProcessed.elem), TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                sendOffset_producer.beginTransaction();
                sendOffset_shouldCommit.elem = !sendOffset_shouldCommit.elem;
                sendOffset_records.foreach((Function1 & Serializable & scala.Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                sendOffset_producer.sendOffsetsToTransaction((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)sendOffset_consumer)).asJava(), sendOffset_consumerGroupId);
                if (sendOffset_shouldCommit.elem) {
                    sendOffset_producer.commitTransaction();
                    sendOffset_recordsProcessed.elem += sendOffset_records.size();
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                sendOffset_producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(sendOffset_consumer);
            }
        }
        finally {
            sendOffset_consumer.close();
        }
        KafkaConsumer sendOffset_verifyingConsumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        sendOffset_verifyingConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq sendOffset_valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_verifyingConsumer, sendOffset_numSeedMessages, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()).map((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToInteger((int)TransactionsTest.$anonfun$sendOffset$4(record)), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set sendOffset_valueSet = sendOffset_valueSeq.toSet();
        Assert.assertEquals((String)new StringBuilder(21).append("Expected ").append(sendOffset_numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString(), (long)sendOffset_numSeedMessages, (long)sendOffset_valueSeq.size());
        Assert.assertEquals((String)new StringBuilder(30).append("Expected ").append(sendOffset_valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString(), (long)sendOffset_valueSeq.size(), (long)sendOffset_valueSet.size());
    }

    @Test
    public void testSendOffsetsWithGroupMetadata() {
        String sendOffset_consumerGroupId = "foobar-consumer-group";
        int sendOffset_numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), sendOffset_numSeedMessages, (Seq<KafkaServer>)this.servers());
        KafkaProducer sendOffset_producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer<byte[], byte[]> sendOffset_consumer = this.createReadCommittedConsumer(sendOffset_consumerGroupId, sendOffset_numSeedMessages / 4, this.createReadCommittedConsumer$default$3());
        sendOffset_consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        sendOffset_producer.initTransactions();
        BooleanRef sendOffset_shouldCommit = BooleanRef.create((boolean)false);
        IntRef sendOffset_recordsProcessed = IntRef.create((int)0);
        try {
            while (sendOffset_recordsProcessed.elem < sendOffset_numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> sendOffset_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_consumer, Math.min(10, sendOffset_numSeedMessages - sendOffset_recordsProcessed.elem), TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                sendOffset_producer.beginTransaction();
                sendOffset_shouldCommit.elem = !sendOffset_shouldCommit.elem;
                sendOffset_records.foreach((Function1 & Serializable & scala.Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                sendOffset_producer.sendOffsetsToTransaction((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)sendOffset_consumer)).asJava(), sendOffset_consumer.groupMetadata());
                if (sendOffset_shouldCommit.elem) {
                    sendOffset_producer.commitTransaction();
                    sendOffset_recordsProcessed.elem += sendOffset_records.size();
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                sendOffset_producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(sendOffset_consumer);
            }
        }
        finally {
            sendOffset_consumer.close();
        }
        KafkaConsumer sendOffset_verifyingConsumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        sendOffset_verifyingConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq sendOffset_valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(sendOffset_verifyingConsumer, sendOffset_numSeedMessages, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()).map((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToInteger((int)TransactionsTest.$anonfun$sendOffset$4(record)), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set sendOffset_valueSet = sendOffset_valueSeq.toSet();
        Assert.assertEquals((String)new StringBuilder(21).append("Expected ").append(sendOffset_numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString(), (long)sendOffset_numSeedMessages, (long)sendOffset_valueSeq.size());
        Assert.assertEquals((String)new StringBuilder(30).append("Expected ").append(sendOffset_valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString(), (long)sendOffset_valueSeq.size(), (long)sendOffset_valueSet.size());
    }

    private void sendOffset(Function3<KafkaProducer<byte[], byte[]>, String, KafkaConsumer<byte[], byte[]>, BoxedUnit> commit) {
        String consumerGroupId = "foobar-consumer-group";
        int numSeedMessages = 500;
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.topic1(), numSeedMessages, (Seq<KafkaServer>)this.servers());
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer<byte[], byte[]> consumer = this.createReadCommittedConsumer(consumerGroupId, numSeedMessages / 4, this.createReadCommittedConsumer$default$3());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        producer.initTransactions();
        BooleanRef shouldCommit = BooleanRef.create((boolean)false);
        IntRef recordsProcessed = IntRef.create((int)0);
        try {
            while (recordsProcessed.elem < numSeedMessages) {
                Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, Math.min(10, numSeedMessages - recordsProcessed.elem), TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
                producer.beginTransaction();
                shouldCommit.elem = !shouldCommit.elem;
                records.foreach((Function1 & Serializable & scala.Serializable)record -> {
                    String key = new String((byte[])record.key(), StandardCharsets.UTF_8);
                    String value = new String((byte[])record.value(), StandardCharsets.UTF_8);
                    return sendOffset_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, key, value, shouldCommit$1.elem));
                });
                commit.apply((Object)producer, (Object)consumerGroupId, consumer);
                if (shouldCommit.elem) {
                    producer.commitTransaction();
                    recordsProcessed.elem += records.size();
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("committed transaction.. Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                    continue;
                }
                producer.abortTransaction();
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("aborted transaction Last committed record: ").append(new String((byte[])((ConsumerRecord)sendOffset_records.last()).value(), StandardCharsets.UTF_8)).append(". Num ").append("records written to ").append(this.topic2()).append(": ").append(recordsProcessed$1.elem).toString());
                TestUtils$.MODULE$.resetToCommittedPositions(consumer);
            }
        }
        finally {
            consumer.close();
        }
        KafkaConsumer verifyingConsumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        verifyingConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$)).asJava());
        Seq valueSeq = (Seq)TestUtils$.MODULE$.pollUntilAtLeastNumRecords(verifyingConsumer, numSeedMessages, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3()).map((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToInteger((int)TransactionsTest.$anonfun$sendOffset$4(record)), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set valueSet = valueSeq.toSet();
        Assert.assertEquals((String)new StringBuilder(21).append("Expected ").append(numSeedMessages).append(" values in ").append(this.topic2()).append(".").toString(), (long)numSeedMessages, (long)valueSeq.size());
        Assert.assertEquals((String)new StringBuilder(30).append("Expected ").append(valueSeq.size()).append(" unique messages in ").append(this.topic2()).append(".").toString(), (long)valueSeq.size(), (long)valueSet.size());
    }

    @Test
    public void testFencingOnCommit() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true));
        try {
            producer1.commitTransaction();
            throw Assertions$.MODULE$.fail("Should not be able to commit transactions from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (Exception e) {
            throw Assertions$.MODULE$.fail("Got an unexpected exception from a fenced producer.", (Throwable)e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFencingOnSendOffsets() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true));
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true));
        try {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Tuple2[] tuple2Array = new Tuple2[1];
            OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(110L);
            Object object = Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foobartopic", 0));
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            producer1.sendOffsetsToTransaction((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), "foobarGroup");
            throw Assertions$.MODULE$.fail("Should not be able to send offsets from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (Exception e) {
            throw Assertions$.MODULE$.fail("Got an unexpected exception from a fenced producer.", (Throwable)e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetMetadataInSendOffsetsToTransaction() {
        void $minus$greater$extension_$this;
        TopicPartition tp = new TopicPartition(this.topic1(), 0);
        String groupId = "group";
        KafkaProducer producer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer<byte[], byte[]> consumer = this.createReadCommittedConsumer(groupId, this.createReadCommittedConsumer$default$2(), this.createReadCommittedConsumer$default$3());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        producer.initTransactions();
        producer.beginTransaction();
        OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(110L, Optional.of(Predef$.MODULE$.int2Integer(15)), "some metadata");
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)tp);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)offsetAndMetadata);
        producer.sendOffsetsToTransaction((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava(), groupId);
        producer.commitTransaction();
        ((KafkaProducer)this.transactionalProducers().apply(1)).initTransactions();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!offsetAndMetadata.equals(consumer.committed((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))).asJava()).get(tp))) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(TransactionsTest.$anonfun$testOffsetMetadataInSendOffsetsToTransaction$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testFencingOnSend() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true)).get();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true)).get();
        try {
            RecordMetadata recordMetadata = (RecordMetadata)producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "5", false)).get();
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Missed a producer fenced exception when writing to ").append(recordMetadata.topic()).append("-").append(recordMetadata.partition()).append(". Grab the logs!!").toString());
            this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("log dirs: ").append(((IterableLike)server.logManager().liveLogDirs().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getAbsolutePath(), Seq$.MODULE$.canBuildFrom())).head()).toString());
                return BoxedUnit.UNIT;
            });
            throw Assertions$.MODULE$.fail("Should not be able to send messages from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
        }
        catch (ProducerFencedException producerFencedException) {
            producer1.close();
        }
        catch (ExecutionException executionException) {
            Assert.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        catch (Exception e) {
            throw Assertions$.MODULE$.fail("Got an unexpected exception from a fenced producer.", (Throwable)e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @Test
    public void testFencingOnAddPartitions() {
        KafkaProducer producer1 = (KafkaProducer)this.transactionalProducers().apply(0);
        KafkaProducer producer2 = (KafkaProducer)this.transactionalProducers().apply(1);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().apply(0);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        producer1.initTransactions();
        producer1.beginTransaction();
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false));
        producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "3", "3", false));
        producer1.abortTransaction();
        producer2.initTransactions();
        producer2.beginTransaction();
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "4", true)).get(20L, TimeUnit.SECONDS);
        producer2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "4", true)).get(20L, TimeUnit.SECONDS);
        try {
            producer1.beginTransaction();
            RecordMetadata recordMetadata = (RecordMetadata)producer1.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "5", false)).get();
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Missed a producer fenced exception when writing to ").append(recordMetadata.topic()).append("-").append(recordMetadata.partition()).append(". Grab the logs!!").toString());
            this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("log dirs: ").append(((IterableLike)server.logManager().liveLogDirs().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getAbsolutePath(), Seq$.MODULE$.canBuildFrom())).head()).toString());
                return BoxedUnit.UNIT;
            });
            throw Assertions$.MODULE$.fail("Should not be able to send messages from a fenced producer.", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (ExecutionException executionException) {
            Assert.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        catch (Exception e) {
            throw Assertions$.MODULE$.fail("Got an unexpected exception from a fenced producer.", (Throwable)e, new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 488));
        }
        producer2.commitTransaction();
        TestUtils$.MODULE$.consumeRecords(consumer, 2, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    @Test
    public void testFencingOnTransactionExpiration() {
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("expiringProducer", 100L, this.createTransactionalProducer$default$3(), this.createTransactionalProducer$default$4());
        producer.initTransactions();
        producer.beginTransaction();
        Assert.assertTrue((boolean)((RecordMetadata)producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "1", "1", false)).get()).hasOffset());
        Thread.sleep(600L);
        try {
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "2", false)).get();
            throw Assertions$.MODULE$.fail("should have raised a ProducerFencedException since the transaction has expired", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
        }
        catch (ProducerFencedException producerFencedException) {
        }
        catch (ExecutionException executionException) {
            Assert.assertTrue((boolean)(executionException.getCause() instanceof ProducerFencedException));
        }
        KafkaConsumer nonTransactionalConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        nonTransactionalConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        Seq records = TestUtils$.MODULE$.consumeRecords(nonTransactionalConsumer, 1, TestUtils$.MODULE$.consumeRecords$default$3());
        Assert.assertEquals((long)1L, (long)records.size());
        Assert.assertEquals((Object)"1", (Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)((ConsumerRecord)records.head())));
        KafkaConsumer transactionalConsumer = (KafkaConsumer)this.transactionalConsumers().head();
        transactionalConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)Nil$.MODULE$)).asJava());
        Assert.assertTrue((boolean)TestUtils$.MODULE$.consumeRecordsFor(transactionalConsumer, 1000L).isEmpty());
    }

    @Test
    public void testMultipleMarkersOneLeader() {
        KafkaProducer firstProducer = (KafkaProducer)this.transactionalProducers().head();
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        KafkaConsumer unCommittedConsumer = (KafkaConsumer)this.nonTransactionalConsumers().head();
        String topicWith10Partitions = "largeTopic";
        String topicWith10PartitionsAndOneReplica = "largeTopicOneReplica";
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        this.createTopic(topicWith10Partitions, 10, this.numServers(), topicConfig);
        this.createTopic(topicWith10PartitionsAndOneReplica, 10, 1, new Properties());
        firstProducer.initTransactions();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 0, 5000, false);
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10PartitionsAndOneReplica, 5000, 10000, false);
        firstProducer.abortTransaction();
        firstProducer.beginTransaction();
        this.sendTransactionalMessagesWithValueRange((KafkaProducer<byte[], byte[]>)firstProducer, topicWith10Partitions, 10000, 11000, true);
        firstProducer.commitTransaction();
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicWith10PartitionsAndOneReplica, (List)new .colon.colon((Object)topicWith10Partitions, (List)Nil$.MODULE$))).asJava());
        unCommittedConsumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicWith10PartitionsAndOneReplica, (List)new .colon.colon((Object)topicWith10Partitions, (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(consumer, 1000, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
        Seq allRecords = TestUtils$.MODULE$.consumeRecords(unCommittedConsumer, 11000, TestUtils$.MODULE$.consumeRecords$default$3());
        scala.collection.immutable.Set expectedValues = ((TraversableOnce)package$.MODULE$.Range().apply(0, 11000).map((Function1 & Serializable & scala.Serializable)x$8 -> TransactionsTest.$anonfun$testMultipleMarkersOneLeader$2(BoxesRunTime.unboxToInt((Object)x$8)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        allRecords.foreach((Function1 & Serializable & scala.Serializable)record -> {
            TransactionsTest.$anonfun$testMultipleMarkersOneLeader$3(expectedValues, record);
            return BoxedUnit.UNIT;
        });
    }

    @Test(expected=KafkaException.class)
    public void testConsecutivelyRunInitTransactions() {
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("normalProducer", this.createTransactionalProducer$default$2(), this.createTransactionalProducer$default$3(), this.createTransactionalProducer$default$4());
        producer.initTransactions();
        producer.initTransactions();
        throw Assertions$.MODULE$.fail("Should have raised a KafkaException", new Position("TransactionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 586));
    }

    @Test(expected=TimeoutException.class)
    public void testCommitTransactionTimeout() {
        String x$1 = "transactionalProducer";
        long x$2 = 1000L;
        long x$3 = this.createTransactionalProducer$default$2();
        int x$4 = this.createTransactionalProducer$default$4();
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer(x$1, x$3, x$2, x$4);
        producer.initTransactions();
        producer.beginTransaction();
        producer.send(new ProducerRecord(this.topic1(), (Object)"foobar".getBytes()));
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, this.servers().size());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                this.killBroker(foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        try {
            producer.commitTransaction();
        }
        finally {
            producer.close(Duration.ZERO);
        }
    }

    @Test
    public void testBumpTransactionalEpoch() {
        String x$1 = "transactionalProducer";
        int x$2 = 5000;
        long x$3 = this.createTransactionalProducer$default$2();
        long x$4 = this.createTransactionalProducer$default$3();
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer(x$1, x$3, x$4, x$2);
        KafkaConsumer consumer = (KafkaConsumer)this.transactionalConsumers().head();
        try {
            String testTopic = "test-topic";
            this.createTopic(testTopic, this.numPartitions(), 1, new Properties());
            int partitionLeader = TestUtils$.MODULE$.waitUntilLeaderIsKnown((Seq<KafkaServer>)this.servers(), new TopicPartition(testTopic, 0), TestUtils$.MODULE$.waitUntilLeaderIsKnown$default$3());
            producer.initTransactions();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "4", "4", true));
            producer.commitTransaction();
            LogManager qual$1 = ((KafkaServer)this.servers().apply(partitionLeader)).logManager();
            TopicPartition x$5 = new TopicPartition(testTopic, 0);
            boolean x$6 = qual$1.getLog$default$2();
            ProducerStateEntry producerStateEntry = (ProducerStateEntry)((Tuple2)((Log)qual$1.getLog(x$5, x$6).get()).producerStateManager().activeProducers().head())._2();
            long producerId = producerStateEntry.producerId();
            short initialProducerEpoch = producerStateEntry.producerEpoch();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "2", "2", false));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "4", "4", false));
            this.killBroker(partitionLeader);
            Future failedFuture = producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "3", "3", false));
            Thread.sleep(6000L);
            this.restartDeadBrokers();
            TestUtils.assertFutureThrows((Future)failedFuture, TimeoutException.class);
            producer.abortTransaction();
            producer.beginTransaction();
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), null, "4", "4", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "1", "1", true));
            producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(testTopic, Predef$.MODULE$.int2Integer(0), "3", "3", true));
            producer.commitTransaction();
            consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)new .colon.colon((Object)testTopic, (List)Nil$.MODULE$)))).asJava());
            TestUtils$.MODULE$.consumeRecords(consumer, 5, TestUtils$.MODULE$.consumeRecords$default$3()).foreach((Function1 & Serializable & scala.Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
            LogManager qual$2 = ((KafkaServer)this.servers().apply(partitionLeader)).logManager();
            TopicPartition x$7 = new TopicPartition(testTopic, 0);
            boolean x$8 = qual$2.getLog$default$2();
            producerStateEntry = (ProducerStateEntry)((Log)qual$2.getLog(x$7, x$8).get()).producerStateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)producerId));
            Assert.assertTrue((producerStateEntry.producerEpoch() > initialProducerEpoch ? 1 : 0) != 0);
        }
        finally {
            producer.close(Duration.ZERO);
        }
    }

    private void sendTransactionalMessagesWithValueRange(KafkaProducer<byte[], byte[]> producer, String topic, int start, int end, boolean willBeCommitted) {
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(start, end);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                TransactionsTest.$anonfun$sendTransactionalMessagesWithValueRange$1(producer, topic, willBeCommitted, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
        producer.flush();
    }

    /*
     * WARNING - void declaration
     */
    private Properties serverProps() {
        void var1_1;
        Properties serverProps = new Properties();
        serverProps.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        serverProps.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)1)).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), ((Object)BoxesRunTime.boxToInteger((int)2)).toString());
        serverProps.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)true)).toString());
        serverProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        serverProps.put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)BoxesRunTime.boxToBoolean((boolean)false)).toString());
        serverProps.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsAbortTimedOutTransactionCleanupIntervalMsProp(), "200");
        return var1_1;
    }

    private KafkaConsumer<byte[], byte[]> createReadCommittedConsumer(String group, int maxPollRecords, Properties props) {
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        boolean x$3 = false;
        boolean x$4 = true;
        String x$6 = TestUtils$.MODULE$.createConsumer$default$3();
        SecurityProtocol x$7 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$8 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$9 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$10 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$11();
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, x$6, x$3, x$4, maxPollRecords, x$7, x$8, x$9, x$10, x$11);
        this.transactionalConsumers().$plus$eq(consumer);
        return consumer;
    }

    private String createReadCommittedConsumer$default$1() {
        return "group";
    }

    private int createReadCommittedConsumer$default$2() {
        return 500;
    }

    private Properties createReadCommittedConsumer$default$3() {
        return new Properties();
    }

    /*
     * WARNING - void declaration
     */
    private KafkaConsumer<byte[], byte[]> createReadUncommittedConsumer(String group) {
        void var2_12;
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        boolean x$3 = false;
        String x$4 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$5 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$6 = TestUtils$.MODULE$.createConsumer$default$6();
        SecurityProtocol x$7 = TestUtils$.MODULE$.createConsumer$default$7();
        Option<File> x$8 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$9 = TestUtils$.MODULE$.createConsumer$default$9();
        ByteArrayDeserializer x$10 = TestUtils$.MODULE$.createConsumer$default$10();
        ByteArrayDeserializer x$11 = TestUtils$.MODULE$.createConsumer$default$11();
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$1, group, x$4, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11);
        this.nonTransactionalConsumers().$plus$eq(consumer);
        return var2_12;
    }

    private KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId, long transactionTimeoutMs, long maxBlockMs, int deliveryTimeoutMs) {
        Buffer<KafkaServer> x$2 = this.servers();
        int x$6 = TestUtils$.MODULE$.createTransactionalProducer$default$3();
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createTransactionalProducer(transactionalId, (Seq<KafkaServer>)x$2, x$6, transactionTimeoutMs, maxBlockMs, deliveryTimeoutMs);
        this.transactionalProducers().$plus$eq(producer);
        return producer;
    }

    private long createTransactionalProducer$default$2() {
        return 60000L;
    }

    private long createTransactionalProducer$default$3() {
        return 60000L;
    }

    private int createTransactionalProducer$default$4() {
        return 120000;
    }

    public static final /* synthetic */ void $anonfun$testBasicTransactions$2(scala.collection.immutable.Set expectedValues$1, ConsumerRecord record) {
        Assert.assertTrue((boolean)expectedValues$1.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$1(ConsumerRecord record) {
        Assert.assertEquals((Object)"x", (Object)new String((byte[])record.key()));
        Assert.assertEquals((Object)"1", (Object)new String((byte[])record.value()));
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedConsumerShouldNotSeeUndecidedData$2(KafkaConsumer readCommittedConsumer$1, TopicPartition tp) {
        Assert.assertEquals((long)1L, (long)readCommittedConsumer$1.position(tp));
    }

    public static final /* synthetic */ int $anonfun$sendOffset$4(ConsumerRecord record) {
        String string = TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record);
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(string).toInt();
    }

    public static final /* synthetic */ String $anonfun$testOffsetMetadataInSendOffsetsToTransaction$2() {
        return "cannot read committed offset";
    }

    public static final /* synthetic */ String $anonfun$testMultipleMarkersOneLeader$2(int x$8) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$8)).toString();
    }

    public static final /* synthetic */ void $anonfun$testMultipleMarkersOneLeader$3(scala.collection.immutable.Set expectedValues$2, ConsumerRecord record) {
        Assert.assertTrue((boolean)expectedValues$2.contains((Object)TestUtils$.MODULE$.recordValueAsString((ConsumerRecord<byte[], byte[]>)record)));
    }

    public static final /* synthetic */ Future $anonfun$sendTransactionalMessagesWithValueRange$1(KafkaProducer producer$2, String topic$1, boolean willBeCommitted$1, int i) {
        String x$3 = ((Object)BoxesRunTime.boxToInteger((int)i)).toString();
        String x$5 = ((Object)BoxesRunTime.boxToInteger((int)i)).toString();
        return producer$2.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(topic$1, null, x$5, x$3, willBeCommitted$1));
    }

    public TransactionsTest() {
        this.numServers = 3;
        this.transactionalProducerCount = 2;
        this.transactionalConsumerCount = 1;
        this.nonTransactionalConsumerCount = 1;
        this.topic1 = "topic1";
        this.topic2 = "topic2";
        this.numPartitions = 4;
    }

    public static final /* synthetic */ KafkaProducer $anonfun$setUp$1$adapted(TransactionsTest $this, Object _) {
        return $this.createTransactionalProducer("transactional-producer", $this.createTransactionalProducer$default$2(), $this.createTransactionalProducer$default$3(), $this.createTransactionalProducer$default$4());
    }

    public static final /* synthetic */ KafkaConsumer $anonfun$setUp$2$adapted(TransactionsTest $this, Object _) {
        return $this.createReadCommittedConsumer("transactional-group", $this.createReadCommittedConsumer$default$2(), $this.createReadCommittedConsumer$default$3());
    }

    public static final /* synthetic */ KafkaConsumer $anonfun$setUp$3$adapted(TransactionsTest $this, Object _) {
        return $this.createReadUncommittedConsumer("non-transactional-group");
    }

    public static final /* synthetic */ Object $anonfun$testSendOffsetsWithGroupId$1$adapted(KafkaProducer producer, String groupId, KafkaConsumer consumer) {
        producer.sendOffsetsToTransaction((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)consumer)).asJava(), groupId);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSendOffsetsWithGroupMetadata$1$adapted(KafkaProducer producer, String x$5, KafkaConsumer consumer) {
        producer.sendOffsetsToTransaction((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)consumer)).asJava(), consumer.groupMetadata());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Future $anonfun$sendTransactionalMessagesWithValueRange$1$adapted(KafkaProducer producer$2, String topic$1, boolean willBeCommitted$1, Object i) {
        return TransactionsTest.$anonfun$sendTransactionalMessagesWithValueRange$1(producer$2, topic$1, willBeCommitted$1, BoxesRunTime.unboxToInt((Object)i));
    }
}

