/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaYammerMetrics;
import kafka.metrics.LinuxIoMetricsCollector;
import kafka.network.SocketServer;
import kafka.network.SocketServer$;
import kafka.raft.RaftManager;
import kafka.security.CredentialProvider;
import kafka.server.ControllerApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandlerPool;
import kafka.server.MetaProperties;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.Server;
import kafka.server.Server$SHUTDOWN$;
import kafka.server.Server$SHUTTING_DOWN$;
import kafka.server.Server$STARTED$;
import kafka.server.Server$STARTING$;
import kafka.server.SimpleApiVersionManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.controller.ControllerMetrics;
import org.apache.kafka.controller.QuorumController;
import org.apache.kafka.controller.QuorumControllerMetrics;
import org.apache.kafka.metadata.VersionRange;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0015h\u0001B\u001e=\u0001\u0005C\u0001\u0002\u0016\u0001\u0003\u0006\u0004%\t!\u0016\u0005\t5\u0002\u0011\t\u0011)A\u0005-\"A1\f\u0001BC\u0002\u0013\u0005A\f\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003^\u0011!\t\u0007A!b\u0001\n\u0003\u0011\u0007\u0002C;\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u0011Y\u0004!Q1A\u0005\u0002]D\u0001B \u0001\u0003\u0002\u0003\u0006I\u0001\u001f\u0005\t#\u0002\u0011)\u0019!C\u0001\u007f\"Q\u00111\u0002\u0001\u0003\u0002\u0003\u0006I!!\u0001\t\u0015\u00055\u0001A!b\u0001\n\u0003\ty\u0001\u0003\u0006\u0002.\u0001\u0011\t\u0011)A\u0005\u0003#A!\"a\f\u0001\u0005\u000b\u0007I\u0011AA\u0019\u0011)\tY\b\u0001B\u0001B\u0003%\u00111\u0007\u0005\b\u0003{\u0002A\u0011AA@\u0011%\t\t\n\u0001b\u0001\n\u0003\t\u0019\n\u0003\u0005\u0002\"\u0002\u0001\u000b\u0011BAK\u0011%\t\u0019\u000b\u0001b\u0001\n\u0003\t)\u000b\u0003\u0005\u0002.\u0002\u0001\u000b\u0011BAT\u0011%\ty\u000b\u0001a\u0001\n\u0003\t\t\fC\u0005\u0002J\u0002\u0001\r\u0011\"\u0001\u0002L\"A\u0011q\u001b\u0001!B\u0013\t\u0019\fC\u0005\u0002Z\u0002\u0001\r\u0011\"\u0001\u0002\\\"I\u00111\u001d\u0001A\u0002\u0013\u0005\u0011Q\u001d\u0005\t\u0003S\u0004\u0001\u0015)\u0003\u0002^\"I\u00111\u001e\u0001A\u0002\u0013\u0005\u0011Q\u001e\u0005\n\u0003w\u0004\u0001\u0019!C\u0001\u0003{D\u0001B!\u0001\u0001A\u0003&\u0011q\u001e\u0005\n\u0005\u0007\u0001\u0001\u0019!C\u0001\u0005\u000bA\u0011Ba\b\u0001\u0001\u0004%\tA!\t\t\u0011\t\u0015\u0002\u0001)Q\u0005\u0005\u000fA\u0011Ba\n\u0001\u0001\u0004%\tA!\u000b\t\u0013\tU\u0002\u00011A\u0005\u0002\t]\u0002\u0002\u0003B\u001e\u0001\u0001\u0006KAa\u000b\t\u0013\tu\u0002\u00011A\u0005\u0002\t}\u0002\"\u0003B'\u0001\u0001\u0007I\u0011\u0001B(\u0011!\u0011\u0019\u0006\u0001Q!\n\t\u0005\u0003\"\u0003B+\u0001\t\u0007I\u0011\u0001B,\u0011!\u0011Y\u0006\u0001Q\u0001\n\te\u0003\"\u0003B/\u0001\u0001\u0007I\u0011\u0001B0\u0011%\u0011Y\u0007\u0001a\u0001\n\u0003\u0011i\u0007\u0003\u0005\u0003r\u0001\u0001\u000b\u0015\u0002B1\u0011%\u0011\u0019\b\u0001b\u0001\n\u0003\u0011)\b\u0003\u0005\u0003\b\u0002\u0001\u000b\u0011\u0002B<\u0011%\u0011I\t\u0001a\u0001\n\u0003\u0011Y\tC\u0005\u0003\u001c\u0002\u0001\r\u0011\"\u0001\u0003\u001e\"A!\u0011\u0015\u0001!B\u0013\u0011i\tC\u0005\u0003$\u0002\u0001\r\u0011\"\u0001\u0003&\"I!Q\u0016\u0001A\u0002\u0013\u0005!q\u0016\u0005\t\u0005g\u0003\u0001\u0015)\u0003\u0003(\"I!Q\u0017\u0001A\u0002\u0013\u0005!q\u0017\u0005\n\u0005\u007f\u0003\u0001\u0019!C\u0001\u0005\u0003D\u0001B!2\u0001A\u0003&!\u0011\u0018\u0005\b\u0005\u000f\u0004A\u0011\u0002Be\u0011\u001d\u0011I\u000e\u0001C\u0001\u00057DqA!8\u0001\t\u0003\u0011y\u000eC\u0004\u0003b\u0002!\tAa8\t\u000f\t\r\b\u0001\"\u0001\u0003`\n\u00012i\u001c8ue>dG.\u001a:TKJ4XM\u001d\u0006\u0003{y\naa]3sm\u0016\u0014(\"A \u0002\u000b-\fgm[1\u0004\u0001M!\u0001A\u0011%O!\t\u0019e)D\u0001E\u0015\u0005)\u0015!B:dC2\f\u0017BA$E\u0005\u0019\te.\u001f*fMB\u0011\u0011\nT\u0007\u0002\u0015*\u00111JP\u0001\u0006kRLGn]\u0005\u0003\u001b*\u0013q\u0001T8hO&tw\r\u0005\u0002P%6\t\u0001K\u0003\u0002R}\u00059Q.\u001a;sS\u000e\u001c\u0018BA*Q\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f]\u0001\u000f[\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t+\u00051\u0006CA,Y\u001b\u0005a\u0014BA-=\u00059iU\r^1Qe>\u0004XM\u001d;jKN\fq\"\\3uCB\u0013x\u000e]3si&,7\u000fI\u0001\u0007G>tg-[4\u0016\u0003u\u0003\"a\u00160\n\u0005}c$aC&bM.\f7i\u001c8gS\u001e\fqaY8oM&<\u0007%A\u0006sC\u001a$X*\u00198bO\u0016\u0014X#A2\u0011\u0007\u0011<\u0017.D\u0001f\u0015\t1g(\u0001\u0003sC\u001a$\u0018B\u00015f\u0005-\u0011\u0016M\u001a;NC:\fw-\u001a:\u0011\u0005)\u001cX\"A6\u000b\u00051l\u0017AB2p[6|gN\u0003\u0002>]*\u0011qh\u001c\u0006\u0003aF\fa!\u00199bG\",'\"\u0001:\u0002\u0007=\u0014x-\u0003\u0002uW\n!\u0012\t]5NKN\u001c\u0018mZ3B]\u00124VM]:j_:\fAB]1gi6\u000bg.Y4fe\u0002\nA\u0001^5nKV\t\u0001\u0010\u0005\u0002zy6\t!P\u0003\u0002Lw*\u0011AN\\\u0005\u0003{j\u0014A\u0001V5nK\u0006)A/[7fAU\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\t9!\u0004\u0002\u0002\u0006)\u0011\u0011k_\u0005\u0005\u0003\u0013\t)AA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\n\u0001\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=\u0016\u0005\u0005E\u0001#B\"\u0002\u0014\u0005]\u0011bAA\u000b\t\n1q\n\u001d;j_:\u0004B!!\u0007\u0002(9!\u00111DA\u0012!\r\ti\u0002R\u0007\u0003\u0003?Q1!!\tA\u0003\u0019a$o\\8u}%\u0019\u0011Q\u0005#\u0002\rA\u0013X\rZ3g\u0013\u0011\tI#a\u000b\u0003\rM#(/\u001b8h\u0015\r\t)\u0003R\u0001\u0012i\"\u0014X-\u00193OC6,\u0007K]3gSb\u0004\u0013\u0001H2p]R\u0014x\u000e\u001c7feF+xN];n->$XM]:GkR,(/Z\u000b\u0003\u0003g\u0001b!!\u000e\u0002D\u0005\u001dSBAA\u001c\u0015\u0011\tI$a\u000f\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002>\u0005}\u0012\u0001B;uS2T!!!\u0011\u0002\t)\fg/Y\u0005\u0005\u0003\u000b\n9DA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u0004\u0002\"!\u0013\u0002L\u0005=\u00131L\u0007\u0003\u0003wIA!!\u0014\u0002<\t\u0019Q*\u00199\u0011\t\u0005E\u0013qK\u0007\u0003\u0003'RA!!\u0016\u0002@\u0005!A.\u00198h\u0013\u0011\tI&a\u0015\u0003\u000f%sG/Z4feB!\u0011QLA;\u001d\u0011\ty&a\u001c\u000f\t\u0005\u0005\u0014Q\u000e\b\u0005\u0003G\nYG\u0004\u0003\u0002f\u0005%d\u0002BA\u000f\u0003OJ\u0011A]\u0005\u0003aFL!aP8\n\u0005\u0019t\u0017\u0002BA9\u0003g\n!BU1gi\u000e{gNZ5h\u0015\t1g.\u0003\u0003\u0002x\u0005e$aC!eIJ,7o]*qK\u000eTA!!\u001d\u0002t\u0005i2m\u001c8ue>dG.\u001a:Rk>\u0014X/\u001c,pi\u0016\u00148OR;ukJ,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0011\u0003\u0003\u000b\u0019)!\"\u0002\b\u0006%\u00151RAG\u0003\u001f\u0003\"a\u0016\u0001\t\u000bQ{\u0001\u0019\u0001,\t\u000bm{\u0001\u0019A/\t\u000b\u0005|\u0001\u0019A2\t\u000bY|\u0001\u0019\u0001=\t\rE{\u0001\u0019AA\u0001\u0011\u001d\tia\u0004a\u0001\u0003#Aq!a\f\u0010\u0001\u0004\t\u0019$\u0001\u0003m_\u000e\\WCAAK!\u0011\t9*!(\u000e\u0005\u0005e%\u0002BAN\u0003o\tQ\u0001\\8dWNLA!a(\u0002\u001a\ni!+Z3oiJ\fg\u000e\u001e'pG.\fQ\u0001\\8dW\u0002\n\u0011#Y<bSR\u001c\u0006.\u001e;e_^t7i\u001c8e+\t\t9\u000b\u0005\u0003\u0002\u0018\u0006%\u0016\u0002BAV\u00033\u0013\u0011bQ8oI&$\u0018n\u001c8\u0002%\u0005<\u0018-\u001b;TQV$Hm\\<o\u0007>tG\rI\u0001\u0007gR\fG/^:\u0016\u0005\u0005M\u0006\u0003BA[\u0003\u0007tA!a.\u0002@:!\u0011\u0011XA_\u001d\u0011\ti\"a/\n\u0003}J!!\u0010 \n\u0007\u0005\u0005G(\u0001\u0004TKJ4XM]\u0005\u0005\u0003\u000b\f9MA\u0007Qe>\u001cWm]:Ti\u0006$Xo\u001d\u0006\u0004\u0003\u0003d\u0014AC:uCR,8o\u0018\u0013fcR!\u0011QZAj!\r\u0019\u0015qZ\u0005\u0004\u0003#$%\u0001B+oSRD\u0011\"!6\u0016\u0003\u0003\u0005\r!a-\u0002\u0007a$\u0013'A\u0004ti\u0006$Xo\u001d\u0011\u0002/1Lg.\u001e=J_6+GO]5dg\u000e{G\u000e\\3di>\u0014XCAAo!\ry\u0015q\\\u0005\u0004\u0003C\u0004&a\u0006'j]VD\u0018j\\'fiJL7m]\"pY2,7\r^8s\u0003ma\u0017N\\;y\u0013>lU\r\u001e:jGN\u001cu\u000e\u001c7fGR|'o\u0018\u0013fcR!\u0011QZAt\u0011%\t)\u000eGA\u0001\u0002\u0004\ti.\u0001\rmS:,\b0S8NKR\u0014\u0018nY:D_2dWm\u0019;pe\u0002\n!\"Y;uQ>\u0014\u0018N_3s+\t\ty\u000fE\u0003D\u0003'\t\t\u0010\u0005\u0003\u0002t\u0006]XBAA{\u0015\r\tY/\\\u0005\u0005\u0003s\f)P\u0001\u0006BkRDwN]5{KJ\fa\"Y;uQ>\u0014\u0018N_3s?\u0012*\u0017\u000f\u0006\u0003\u0002N\u0006}\b\"CAk7\u0005\u0005\t\u0019AAx\u0003-\tW\u000f\u001e5pe&TXM\u001d\u0011\u0002\u0015Q|7.\u001a8DC\u000eDW-\u0006\u0002\u0003\bA!!\u0011\u0002B\u000e\u001b\t\u0011YA\u0003\u0003\u0003\u000e\t=\u0011!C5oi\u0016\u0014h.\u00197t\u0015\u0011\u0011\tBa\u0005\u0002\u0015\u0011,G.Z4bi&|gN\u0003\u0003\u0003\u0016\t]\u0011!\u0002;pW\u0016t'b\u0001B\rw\u0006A1/Z2ve&$\u00180\u0003\u0003\u0003\u001e\t-!\u0001\u0006#fY\u0016<\u0017\r^5p]R{7.\u001a8DC\u000eDW-\u0001\bu_.,gnQ1dQ\u0016|F%Z9\u0015\t\u00055'1\u0005\u0005\n\u0003+t\u0012\u0011!a\u0001\u0005\u000f\t1\u0002^8lK:\u001c\u0015m\u00195fA\u0005\u00112M]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s+\t\u0011Y\u0003\u0005\u0003\u0003.\tERB\u0001B\u0018\u0015\r\u0011IBP\u0005\u0005\u0005g\u0011yC\u0001\nDe\u0016$WM\u001c;jC2\u0004&o\u001c<jI\u0016\u0014\u0018AF2sK\u0012,g\u000e^5bYB\u0013xN^5eKJ|F%Z9\u0015\t\u00055'\u0011\b\u0005\n\u0003+\f\u0013\u0011!a\u0001\u0005W\t1c\u0019:fI\u0016tG/[1m!J|g/\u001b3fe\u0002\nAb]8dW\u0016$8+\u001a:wKJ,\"A!\u0011\u0011\t\t\r#\u0011J\u0007\u0003\u0005\u000bR1Aa\u0012?\u0003\u001dqW\r^<pe.LAAa\u0013\u0003F\ta1k\\2lKR\u001cVM\u001d<fe\u0006\u00012o\\2lKR\u001cVM\u001d<fe~#S-\u001d\u000b\u0005\u0003\u001b\u0014\t\u0006C\u0005\u0002V\u0012\n\t\u00111\u0001\u0003B\u0005i1o\\2lKR\u001cVM\u001d<fe\u0002\n\u0001e]8dW\u0016$8+\u001a:wKJ4\u0015N]:u\u0005>,h\u000e\u001a)peR4U\u000f^;sKV\u0011!\u0011\f\t\u0007\u0003k\t\u0019%a\u0014\u0002CM|7m[3u'\u0016\u0014h/\u001a:GSJ\u001cHOQ8v]\u0012\u0004vN\u001d;GkR,(/\u001a\u0011\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0006\u0002\u0003bA!!1\rB4\u001b\t\u0011)GC\u0002\u0003^9LAA!\u001b\u0003f\tQ1i\u001c8ue>dG.\u001a:\u0002\u001d\r|g\u000e\u001e:pY2,'o\u0018\u0013fcR!\u0011Q\u001aB8\u0011%\t).KA\u0001\u0002\u0004\u0011\t'A\u0006d_:$(o\u001c7mKJ\u0004\u0013!E:vaB|'\u000f^3e\r\u0016\fG/\u001e:fgV\u0011!q\u000f\t\t\u00033\u0011I(a\u0006\u0003|%!\u0011QJA\u0016!\u0011\u0011iHa!\u000e\u0005\t}$b\u0001BA]\u0006AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0003\u0006\n}$\u0001\u0004,feNLwN\u001c*b]\u001e,\u0017AE:vaB|'\u000f^3e\r\u0016\fG/\u001e:fg\u0002\nQ\"];pi\u0006l\u0015M\\1hKJ\u001cXC\u0001BG!\u0011\u0011yI!&\u000f\t\u0005]&\u0011S\u0005\u0004\u0005'c\u0014\u0001D)v_R\fg)Y2u_JL\u0018\u0002\u0002BL\u00053\u0013Q\"U;pi\u0006l\u0015M\\1hKJ\u001c(b\u0001BJy\u0005\t\u0012/^8uC6\u000bg.Y4feN|F%Z9\u0015\t\u00055'q\u0014\u0005\n\u0003+t\u0013\u0011!a\u0001\u0005\u001b\u000ba\"];pi\u0006l\u0015M\\1hKJ\u001c\b%\u0001\bd_:$(o\u001c7mKJ\f\u0005/[:\u0016\u0005\t\u001d\u0006cA,\u0003*&\u0019!1\u0016\u001f\u0003\u001d\r{g\u000e\u001e:pY2,'/\u00119jg\u0006\u00112m\u001c8ue>dG.\u001a:Ba&\u001cx\fJ3r)\u0011\tiM!-\t\u0013\u0005U\u0017'!AA\u0002\t\u001d\u0016aD2p]R\u0014x\u000e\u001c7fe\u0006\u0003\u0018n\u001d\u0011\u00023\r|g\u000e\u001e:pY2,'/\u00119jg\"\u000bg\u000e\u001a7feB{w\u000e\\\u000b\u0003\u0005s\u00032a\u0016B^\u0013\r\u0011i\f\u0010\u0002\u0018\u0017\u000647.\u0019*fcV,7\u000f\u001e%b]\u0012dWM\u001d)p_2\fQdY8oiJ|G\u000e\\3s\u0003BL7\u000fS1oI2,'\u000fU8pY~#S-\u001d\u000b\u0005\u0003\u001b\u0014\u0019\rC\u0005\u0002VR\n\t\u00111\u0001\u0003:\u0006Q2m\u001c8ue>dG.\u001a:Ba&\u001c\b*\u00198eY\u0016\u0014\bk\\8mA\u0005\tR.Y=cK\u000eC\u0017M\\4f'R\fG/^:\u0015\r\t-'\u0011\u001bBk!\r\u0019%QZ\u0005\u0004\u0005\u001f$%a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005'4\u0004\u0019AAZ\u0003\u00111'o\\7\t\u000f\t]g\u00071\u0001\u00024\u0006\u0011Ao\\\u0001\nG2,8\u000f^3s\u0013\u0012,\"!a\u0006\u0002\u000fM$\u0018M\u001d;vaR\u0011\u0011QZ\u0001\tg\",H\u000fZ8x]\u0006i\u0011m^1jiNCW\u000f\u001e3po:\u0004")
public class ControllerServer
implements KafkaMetricsGroup {
    private final MetaProperties metaProperties;
    private final KafkaConfig config;
    private final RaftManager<ApiMessageAndVersion> raftManager;
    private final Time time;
    private final Metrics metrics;
    private final Option<String> threadNamePrefix;
    private final CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final ReentrantLock lock;
    private final Condition awaitShutdownCond;
    private Server.ProcessStatus status;
    private LinuxIoMetricsCollector linuxIoMetricsCollector;
    private Option<Authorizer> authorizer;
    private DelegationTokenCache tokenCache;
    private CredentialProvider credentialProvider;
    private SocketServer socketServer;
    private final CompletableFuture<Integer> socketServerFirstBoundPortFuture;
    private Controller controller;
    private final scala.collection.immutable.Map<String, VersionRange> supportedFeatures;
    private QuotaFactory.QuotaManagers quotaManagers;
    private ControllerApis controllerApis;
    private KafkaRequestHandlerPool controllerApisHandlerPool;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public MetaProperties metaProperties() {
        return this.metaProperties;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public RaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public Time time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Option<String> threadNamePrefix() {
        return this.threadNamePrefix;
    }

    public CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public Condition awaitShutdownCond() {
        return this.awaitShutdownCond;
    }

    public Server.ProcessStatus status() {
        return this.status;
    }

    public void status_$eq(Server.ProcessStatus x$1) {
        this.status = x$1;
    }

    public LinuxIoMetricsCollector linuxIoMetricsCollector() {
        return this.linuxIoMetricsCollector;
    }

    public void linuxIoMetricsCollector_$eq(LinuxIoMetricsCollector x$1) {
        this.linuxIoMetricsCollector = x$1;
    }

    public Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    public void authorizer_$eq(Option<Authorizer> x$1) {
        this.authorizer = x$1;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public void tokenCache_$eq(DelegationTokenCache x$1) {
        this.tokenCache = x$1;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    public void credentialProvider_$eq(CredentialProvider x$1) {
        this.credentialProvider = x$1;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public void socketServer_$eq(SocketServer x$1) {
        this.socketServer = x$1;
    }

    public CompletableFuture<Integer> socketServerFirstBoundPortFuture() {
        return this.socketServerFirstBoundPortFuture;
    }

    public Controller controller() {
        return this.controller;
    }

    public void controller_$eq(Controller x$1) {
        this.controller = x$1;
    }

    public scala.collection.immutable.Map<String, VersionRange> supportedFeatures() {
        return this.supportedFeatures;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public void quotaManagers_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManagers = x$1;
    }

    public ControllerApis controllerApis() {
        return this.controllerApis;
    }

    public void controllerApis_$eq(ControllerApis x$1) {
        this.controllerApis = x$1;
    }

    public KafkaRequestHandlerPool controllerApisHandlerPool() {
        return this.controllerApisHandlerPool;
    }

    public void controllerApisHandlerPool_$eq(KafkaRequestHandlerPool x$1) {
        this.controllerApisHandlerPool = x$1;
    }

    private boolean maybeChangeStatus(Server.ProcessStatus from, Server.ProcessStatus to) {
        block9: {
            boolean bl;
            block8: {
                this.lock().lock();
                try {
                    Server.ProcessStatus processStatus = this.status();
                    if (processStatus == null ? from != null : !processStatus.equals(from)) {
                        bl = false;
                        break block8;
                    }
                    this.status_$eq(to);
                    Server.ProcessStatus processStatus2 = to;
                    Server$SHUTDOWN$ server$SHUTDOWN$ = Server$SHUTDOWN$.MODULE$;
                    if (processStatus2 == null) {
                        if (server$SHUTDOWN$ != null) {
                            break block9;
                        }
                    } else if (!processStatus2.equals(server$SHUTDOWN$)) break block9;
                    this.awaitShutdownCond().signalAll();
                    break block9;
                }
                finally {
                    this.lock().unlock();
                }
            }
            return bl;
        }
        return true;
    }

    public String clusterId() {
        return this.metaProperties().clusterId().toString();
    }

    public void startup() {
        if (!this.maybeChangeStatus(Server$SHUTDOWN$.MODULE$, Server$STARTING$.MODULE$)) {
            return;
        }
        try {
            scala.collection.immutable.Map map;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting controller");
            this.maybeChangeStatus(Server$STARTING$.MODULE$, Server$STARTED$.MODULE$);
            this.logIdent_$eq(new LogContext(new StringBuilder(23).append("[ControllerServer id=").append(this.config().nodeId()).append("] ").toString()).logPrefix());
            this.newGauge("ClusterId", new Gauge<String>(this){
                private final /* synthetic */ ControllerServer $outer;

                public final String value() {
                    return this.$outer.kafka$server$ControllerServer$$$anonfun$startup$2();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.newGauge$default$3());
            this.newGauge("yammer-metrics-count", new Gauge<Object>(this){
                private final /* synthetic */ ControllerServer $outer;

                public final int value() {
                    return ControllerServer.kafka$server$ControllerServer$$$anonfun$startup$4();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.newGauge$default$3());
            this.linuxIoMetricsCollector_$eq(new LinuxIoMetricsCollector("/proc", this.time(), this.logger().underlying()));
            if (this.linuxIoMetricsCollector().usable()) {
                this.newGauge("linux-disk-read-bytes", new Gauge<Object>(this){
                    private final /* synthetic */ ControllerServer $outer;

                    public final long value() {
                        return this.$outer.kafka$server$ControllerServer$$$anonfun$startup$6();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.newGauge$default$3());
                this.newGauge("linux-disk-write-bytes", new Gauge<Object>(this){
                    private final /* synthetic */ ControllerServer $outer;

                    public final long value() {
                        return this.$outer.kafka$server$ControllerServer$$$anonfun$startup$8();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.newGauge$default$3());
            }
            List javaListeners = (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)this.config().controllerListeners().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toJava(), Seq$.MODULE$.canBuildFrom())).asJava();
            this.authorizer_$eq(this.config().authorizer());
            this.authorizer().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.configure(this.config().originals());
                return BoxedUnit.UNIT;
            });
            Option<Authorizer> option = this.authorizer();
            if (option instanceof Some) {
                Authorizer authZ = (Authorizer)((Some)option).value();
                Broker.ServerInfo controllerAuthorizerInfo = new Broker.ServerInfo(new ClusterResource(this.clusterId()), this.config().nodeId(), javaListeners, (Endpoint)javaListeners.get(0));
                map = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(authZ.start((AuthorizerServerInfo)controllerAuthorizerInfo)).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    Endpoint ep = (Endpoint)x0$1._1();
                    CompletionStage cs = (CompletionStage)x0$1._2();
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ep), cs.toCompletableFuture());
                    return tuple2;
                }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            } else if (None$.MODULE$.equals(option)) {
                map = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(javaListeners).asScala()).map((Function1 & Serializable & scala.Serializable)ep -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ep), CompletableFuture.completedFuture(null)), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            } else {
                throw new MatchError(option);
            }
            SimpleApiVersionManager apiVersionManager = new SimpleApiVersionManager(ApiMessageType.ListenerType.CONTROLLER);
            this.tokenCache_$eq(new DelegationTokenCache(ScramMechanism.mechanismNames()));
            this.credentialProvider_$eq(new CredentialProvider(ScramMechanism.mechanismNames(), this.tokenCache()));
            this.socketServer_$eq(new SocketServer(this.config(), this.metrics(), this.time(), this.credentialProvider(), apiVersionManager));
            this.socketServer().startup(false, (Option<EndPoint>)None$.MODULE$, this.config().controllerListeners());
            if (!this.config().controllerListeners().nonEmpty()) {
                throw new ConfigException("No controller.listener.names defined for controller");
            }
            this.socketServerFirstBoundPortFuture().complete(Predef$.MODULE$.int2Integer(this.socketServer().boundPort(((EndPoint)this.config().controllerListeners().head()).listenerName())));
            java.util.Map configDefs = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigResource.Type.BROKER), (Object)KafkaConfig$.MODULE$.configDef()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigResource.Type.TOPIC), (Object)LogConfig$.MODULE$.configDefCopy())}))).asJava();
            String threadNamePrefixAsString = (String)this.threadNamePrefix().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            this.controller_$eq((Controller)new QuorumController.Builder(this.config().nodeId()).setTime(this.time()).setThreadNamePrefix(threadNamePrefixAsString).setConfigDefs(configDefs).setRaftClient(this.raftManager().client()).setDefaultReplicationFactor((short)this.config().defaultReplicationFactor()).setDefaultNumPartitions(this.config().numPartitions().intValue()).setSessionTimeoutNs(TimeUnit.NANOSECONDS.convert(this.config().brokerSessionTimeoutMs(), TimeUnit.MILLISECONDS)).setSnapshotMaxNewRecordBytes(Predef$.MODULE$.Long2long(this.config().metadataSnapshotMaxNewRecordBytes())).setMetrics((ControllerMetrics)new QuorumControllerMetrics(KafkaYammerMetrics.defaultRegistry())).build());
            this.quotaManagers_$eq(QuotaFactory$.MODULE$.instantiate(this.config(), this.metrics(), this.time(), (String)this.threadNamePrefix().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")));
            Buffer controllerNodes = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(RaftConfig.voterConnectionsToNodes(this.controllerQuorumVotersFuture().get())).asScala();
            this.controllerApis_$eq(new ControllerApis(this.socketServer().dataPlaneRequestChannel(), this.authorizer(), this.quotaManagers(), this.time(), this.supportedFeatures(), this.controller(), this.raftManager(), this.config(), this.metaProperties(), (Seq<Node>)controllerNodes.toSeq(), apiVersionManager));
            this.controllerApisHandlerPool_$eq(new KafkaRequestHandlerPool(this.config().nodeId(), this.socketServer().dataPlaneRequestChannel(), this.controllerApis(), this.time(), Predef$.MODULE$.Integer2int(this.config().numIoThreads()), new StringBuilder(28).append(SocketServer$.MODULE$.DataPlaneMetricPrefix()).append("RequestHandlerAvgIdlePercent").toString(), SocketServer$.MODULE$.DataPlaneThreadPrefix()));
            this.socketServer().startProcessingRequests((Map<Endpoint, CompletableFuture<Void>>)map);
            return;
        }
        catch (Throwable e) {
            this.maybeChangeStatus(Server$STARTING$.MODULE$, Server$STARTED$.MODULE$);
            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fatal error during controller startup. Prepare to shutdown", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.shutdown();
            throw e;
        }
    }

    public void shutdown() {
        if (!this.maybeChangeStatus(Server$STARTED$.MODULE$, Server$SHUTTING_DOWN$.MODULE$)) {
            return;
        }
        try {
            try {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "shutting down");
                if (this.socketServer() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.socketServer().stopProcessingRequests(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
                if (this.controller() != null) {
                    this.controller().beginShutdown();
                }
                if (this.socketServer() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.socketServer().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
                if (this.controllerApisHandlerPool() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.controllerApisHandlerPool().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
                if (this.controllerApis() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.controllerApis().close(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
                if (this.quotaManagers() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.quotaManagers().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
                if (this.controller() != null) {
                    this.controller().close();
                }
                this.socketServerFirstBoundPortFuture().completeExceptionally(new RuntimeException("shutting down"));
            }
            catch (Throwable e) {
                this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fatal error during controller shutdown.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                throw e;
            }
        }
        finally {
            this.maybeChangeStatus(Server$SHUTTING_DOWN$.MODULE$, Server$SHUTDOWN$.MODULE$);
        }
    }

    public void awaitShutdown() {
        this.lock().lock();
        try {
            while (true) {
                Server.ProcessStatus processStatus = this.status();
                Server$SHUTDOWN$ server$SHUTDOWN$ = Server$SHUTDOWN$.MODULE$;
                if (processStatus == null ? server$SHUTDOWN$ != null : !processStatus.equals(server$SHUTDOWN$)) {
                    this.awaitShutdownCond().awaitUninterruptibly();
                    continue;
                }
                break;
            }
        }
        finally {
            this.lock().unlock();
        }
    }

    public final /* synthetic */ String kafka$server$ControllerServer$$$anonfun$startup$2() {
        return this.clusterId();
    }

    public static final /* synthetic */ int kafka$server$ControllerServer$$$anonfun$startup$4() {
        return KafkaYammerMetrics.defaultRegistry().allMetrics().size();
    }

    public final /* synthetic */ long kafka$server$ControllerServer$$$anonfun$startup$6() {
        return this.linuxIoMetricsCollector().readBytes();
    }

    public final /* synthetic */ long kafka$server$ControllerServer$$$anonfun$startup$8() {
        return this.linuxIoMetricsCollector().writeBytes();
    }

    public ControllerServer(MetaProperties metaProperties, KafkaConfig config, RaftManager<ApiMessageAndVersion> raftManager, Time time, Metrics metrics, Option<String> threadNamePrefix, CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture) {
        this.metaProperties = metaProperties;
        this.config = config;
        this.raftManager = raftManager;
        this.time = time;
        this.metrics = metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.lock = new ReentrantLock();
        this.awaitShutdownCond = this.lock().newCondition();
        this.status = Server$SHUTDOWN$.MODULE$;
        this.linuxIoMetricsCollector = null;
        this.authorizer = null;
        this.tokenCache = null;
        this.credentialProvider = null;
        this.socketServer = null;
        this.socketServerFirstBoundPortFuture = new CompletableFuture();
        this.controller = null;
        this.supportedFeatures = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.quotaManagers = null;
        this.controllerApis = null;
        this.controllerApisHandlerPool = null;
    }
}

