/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.client.Partition;
import org.apache.kudu.client.ReplicaSelection;
import org.apache.kudu.client.ServerInfo;
import org.apache.kudu.consensus.Metadata;
import org.apache.kudu.shaded.com.google.common.base.Joiner;
import org.apache.kudu.shaded.com.google.common.base.Objects;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.collect.ComparisonChain;
import org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RemoteTablet
implements Comparable<RemoteTablet> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteTablet.class);
    private static final int randomInt = new Random().nextInt(Integer.MAX_VALUE);
    private final String tableId;
    private final String tabletId;
    @GuardedBy(value="tabletServers")
    private final Map<String, ServerInfo> tabletServers;
    private final AtomicReference<List<LocatedTablet.Replica>> replicas = new AtomicReference(ImmutableList.of());
    private final Partition partition;
    @GuardedBy(value="tabletServers")
    private String leaderUuid;

    RemoteTablet(String tableId, String tabletId, Partition partition, List<LocatedTablet.Replica> replicas, List<ServerInfo> serverInfos) {
        Preconditions.checkArgument(replicas.size() == serverInfos.size(), "the number of replicas does not equal the number of servers");
        this.tabletId = tabletId;
        this.tableId = tableId;
        this.partition = partition;
        this.tabletServers = new HashMap<String, ServerInfo>(serverInfos.size());
        for (ServerInfo serverInfo : serverInfos) {
            this.tabletServers.put(serverInfo.getUuid(), serverInfo);
        }
        ImmutableList.Builder replicasBuilder = new ImmutableList.Builder();
        for (int i = 0; i < replicas.size(); ++i) {
            replicasBuilder.add(replicas.get(i));
            if (!replicas.get(i).getRoleAsEnum().equals(Metadata.RaftPeerPB.Role.LEADER)) continue;
            this.leaderUuid = serverInfos.get(i).getUuid();
        }
        if (this.leaderUuid == null) {
            LOG.warn("No leader provided for tablet {}", (Object)this.getTabletId());
        }
        this.replicas.set((List<LocatedTablet.Replica>)((Object)replicasBuilder.build()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ArrayList<String> tsStrings;
        StringBuilder sb = new StringBuilder();
        sb.append(this.tabletId).append("@[");
        Map<String, ServerInfo> map = this.tabletServers;
        synchronized (map) {
            tsStrings = new ArrayList<String>(this.tabletServers.size());
            for (ServerInfo e : this.tabletServers.values()) {
                String flag = e.getUuid().equals(this.leaderUuid) ? "[L]" : "";
                tsStrings.add(e.toString() + flag);
            }
        }
        Collections.sort(tsStrings);
        sb.append(Joiner.on(',').join(tsStrings));
        sb.append(']');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeTabletClient(String uuid) {
        Map<String, ServerInfo> map = this.tabletServers;
        synchronized (map) {
            if (this.leaderUuid != null && this.leaderUuid.equals(uuid)) {
                this.leaderUuid = null;
            }
            if (this.tabletServers.remove(uuid) != null) {
                return true;
            }
            LOG.debug("tablet {} already removed ts {}, size left is {}", new Object[]{this.getTabletId(), uuid, this.tabletServers.size()});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void demoteLeader(String uuid) {
        Map<String, ServerInfo> map = this.tabletServers;
        synchronized (map) {
            if (this.leaderUuid == null) {
                LOG.debug("{} couldn't be demoted as the leader for {}, there is no known leader", (Object)uuid, (Object)this.getTabletId());
                return;
            }
            if (this.leaderUuid.equals(uuid)) {
                this.leaderUuid = null;
                LOG.debug("{} was demoted as the leader for {}", (Object)uuid, (Object)this.getTabletId());
            } else {
                LOG.debug("{} wasn't the leader for {}, current leader is {}", new Object[]{uuid, this.getTabletId(), this.leaderUuid});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ServerInfo getLeaderServerInfo() {
        Map<String, ServerInfo> map = this.tabletServers;
        synchronized (map) {
            return this.tabletServers.get(this.leaderUuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ServerInfo getClosestServerInfo(String location) {
        Map<String, ServerInfo> map = this.tabletServers;
        synchronized (map) {
            ServerInfo result = null;
            ArrayList<ServerInfo> localServers = new ArrayList<ServerInfo>();
            ArrayList<ServerInfo> serversInSameLocation = new ArrayList<ServerInfo>();
            int randomIndex = randomInt % this.tabletServers.size();
            int index = 0;
            for (ServerInfo e : this.tabletServers.values()) {
                if (e.isLocal()) {
                    localServers.add(e);
                }
                if (e.inSameLocation(location)) {
                    serversInSameLocation.add(e);
                }
                if (index == randomIndex) {
                    result = e;
                }
                ++index;
            }
            if (!localServers.isEmpty()) {
                randomIndex = randomInt % localServers.size();
                return (ServerInfo)localServers.get(randomIndex);
            }
            if (!serversInSameLocation.isEmpty()) {
                randomIndex = randomInt % serversInSameLocation.size();
                return (ServerInfo)serversInSameLocation.get(randomIndex);
            }
            return result;
        }
    }

    @Nullable
    ServerInfo getReplicaSelectedServerInfo(ReplicaSelection replicaSelection, String location) {
        switch (replicaSelection) {
            case LEADER_ONLY: {
                return this.getLeaderServerInfo();
            }
            case CLOSEST_REPLICA: {
                return this.getClosestServerInfo(location);
            }
        }
        throw new RuntimeException("unknown replica selection mechanism " + (Object)((Object)replicaSelection));
    }

    List<LocatedTablet.Replica> getReplicas() {
        return this.replicas.get();
    }

    public String getTableId() {
        return this.tableId;
    }

    String getTabletId() {
        return this.tabletId;
    }

    public Partition getPartition() {
        return this.partition;
    }

    byte[] getTabletIdAsBytes() {
        return this.tabletId.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public int compareTo(RemoteTablet remoteTablet) {
        if (remoteTablet == null) {
            return 1;
        }
        return ComparisonChain.start().compare((Comparable<?>)((Object)this.tableId), (Comparable<?>)((Object)remoteTablet.tableId)).compare(this.partition, remoteTablet.partition).result();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoteTablet)) {
            return false;
        }
        RemoteTablet that = (RemoteTablet)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return Objects.hashCode(this.tableId, this.partition);
    }
}

