/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.ShapeQuery;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.geo.Rectangle2D;
import org.apache.lucene.index.PointValues;

final class LatLonShapeBoundingBoxQuery
extends ShapeQuery {
    final Rectangle rectangle;
    final Rectangle2D rectangle2D;

    public LatLonShapeBoundingBoxQuery(String field, ShapeField.QueryRelation queryRelation, double minLat, double maxLat, double minLon, double maxLon) {
        super(field, queryRelation);
        this.rectangle = new Rectangle(minLat, maxLat, minLon, maxLon);
        this.rectangle2D = Rectangle2D.create(this.rectangle);
    }

    @Override
    protected PointValues.Relation relateRangeBBoxToQuery(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        if (this.queryRelation == ShapeField.QueryRelation.INTERSECTS || this.queryRelation == ShapeField.QueryRelation.DISJOINT) {
            return this.rectangle2D.intersectRangeBBox(minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
        }
        return this.rectangle2D.relateRangeBBox(minXOffset, minYOffset, minTriangle, maxXOffset, maxYOffset, maxTriangle);
    }

    @Override
    protected boolean queryMatches(byte[] t, ShapeField.DecodedTriangle scratchTriangle, ShapeField.QueryRelation queryRelation) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        int aY = scratchTriangle.aY;
        int aX = scratchTriangle.aX;
        int bY = scratchTriangle.bY;
        int bX = scratchTriangle.bX;
        int cY = scratchTriangle.cY;
        int cX = scratchTriangle.cX;
        switch (queryRelation) {
            case INTERSECTS: {
                return this.rectangle2D.intersectsTriangle(aX, aY, bX, bY, cX, cY);
            }
            case WITHIN: {
                return this.rectangle2D.containsTriangle(aX, aY, bX, bY, cX, cY);
            }
            case DISJOINT: {
                return !this.rectangle2D.intersectsTriangle(aX, aY, bX, bY, cX, cY);
            }
        }
        throw new IllegalArgumentException("Unsupported query type :[" + (Object)((Object)queryRelation) + "]");
    }

    @Override
    protected Component2D.WithinRelation queryWithin(byte[] t, ShapeField.DecodedTriangle scratchTriangle) {
        ShapeField.decodeTriangle(t, scratchTriangle);
        return this.rectangle2D.withinTriangle(scratchTriangle.aX, scratchTriangle.aY, scratchTriangle.ab, scratchTriangle.bX, scratchTriangle.bY, scratchTriangle.bc, scratchTriangle.cX, scratchTriangle.cY, scratchTriangle.ca);
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo(((Object)((Object)this)).getClass().cast(o));
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && this.rectangle.equals((Object)((LatLonShapeBoundingBoxQuery)((Object)o)).rectangle);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this.rectangle.hashCode();
        return hash;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(this.rectangle.toString());
        return sb.toString();
    }
}

