/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.assembly.interpolation;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugin.assembly.interpolation.AssemblyInterpolationException;
import org.apache.maven.plugin.assembly.model.Assembly;
import org.apache.maven.plugin.assembly.utils.AssemblyFileUtils;
import org.apache.maven.plugin.assembly.utils.InterpolationConstants;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.fixed.FixedStringSearchInterpolator;
import org.codehaus.plexus.interpolation.fixed.FixedValueSource;
import org.codehaus.plexus.interpolation.object.FieldBasedObjectInterpolator;
import org.codehaus.plexus.interpolation.object.ObjectInterpolationWarning;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.cli.CommandLineUtils;

public class AssemblyInterpolator
extends AbstractLogEnabled {
    private static final Set<String> INTERPOLATION_BLACKLIST;
    private static final Properties ENVIRONMENT_VARIABLES;

    public Assembly interpolate(Assembly assembly, MavenProject project, AssemblerConfigurationSource configSource, FixedStringSearchInterpolator projectInterpolator) throws AssemblyInterpolationException {
        HashSet<String> blacklistFields = new HashSet<String>(FieldBasedObjectInterpolator.DEFAULT_BLACKLISTED_FIELD_NAMES);
        blacklistFields.addAll(INTERPOLATION_BLACKLIST);
        Set blacklistPkgs = FieldBasedObjectInterpolator.DEFAULT_BLACKLISTED_PACKAGE_PREFIXES;
        FieldBasedObjectInterpolator objectInterpolator = new FieldBasedObjectInterpolator(blacklistFields, blacklistPkgs);
        FixedStringSearchInterpolator interpolator = AssemblyInterpolator.buildInterpolator(project, projectInterpolator, configSource);
        PrefixAwareRecursionInterceptor interceptor = new PrefixAwareRecursionInterceptor(InterpolationConstants.PROJECT_PREFIXES, true);
        try {
            objectInterpolator.interpolate((Object)assembly, interpolator.asBasicInterpolator(), (RecursionInterceptor)interceptor);
        }
        catch (InterpolationException e) {
            throw new AssemblyInterpolationException("Failed to interpolate assembly with ID: " + assembly.getId() + ". Reason: " + e.getMessage(), e);
        }
        if (objectInterpolator.hasWarnings() && this.getLogger().isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("One or more minor errors occurred while interpolating the assembly with ID: ").append(assembly.getId()).append(":\n");
            List warnings = objectInterpolator.getWarnings();
            for (ObjectInterpolationWarning warning : warnings) {
                sb.append('\n').append(warning);
            }
            sb.append("\n\nThese values were SKIPPED, but the assembly process will continue.\n");
            this.getLogger().debug(sb.toString());
        }
        return assembly;
    }

    public static FixedStringSearchInterpolator buildInterpolator(MavenProject project, @Nonnull FixedStringSearchInterpolator projectIp, AssemblerConfigurationSource configSource) {
        return FixedStringSearchInterpolator.create((FixedValueSource[])new FixedValueSource[]{configSource.getRepositoryInterpolator(), configSource.getCommandLinePropsInterpolator(), configSource.getEnvInterpolator(), projectIp}).withPostProcessor((InterpolationPostProcessor)new PathTranslatingPostProcessor(project.getBasedir()));
    }

    protected Logger getLogger() {
        Logger logger = super.getLogger();
        if (logger == null) {
            logger = new ConsoleLogger(1, "interpolator-internal");
            this.enableLogging(logger);
        }
        return logger;
    }

    static {
        Properties environmentVariables;
        HashSet<String> blacklist = new HashSet<String>();
        blacklist.add("outputFileNameMapping");
        blacklist.add("outputDirectoryMapping");
        blacklist.add("outputDirectory");
        INTERPOLATION_BLACKLIST = blacklist;
        try {
            environmentVariables = CommandLineUtils.getSystemEnvVars((boolean)false);
        }
        catch (IOException e) {
            environmentVariables = new Properties();
        }
        ENVIRONMENT_VARIABLES = environmentVariables;
    }

    private static final class PathTranslatingPostProcessor
    implements InterpolationPostProcessor {
        private final File basedir;

        public PathTranslatingPostProcessor(File basedir) {
            this.basedir = basedir;
        }

        public Object execute(String expression, Object value) {
            String path = String.valueOf(value);
            return AssemblyFileUtils.makePathRelativeTo(path, this.basedir);
        }
    }
}

