/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.plugin.CheckoutMojo;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;

@Mojo(name="bootstrap", requiresProject=false)
public class BootstrapMojo
extends CheckoutMojo {
    @Parameter(property="goals")
    private String goals;
    @Parameter(property="profiles")
    private String profiles;
    @Parameter(property="goalsDirectory", defaultValue="")
    private String goalsDirectory;
    @Parameter(property="mavenHome", defaultValue="")
    private String mavenHome;

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        if (this.getCheckoutResult() != null) {
            ScmResult checkoutResult = this.getCheckoutResult();
            String relativePathProjectDirectory = "";
            if (checkoutResult instanceof CheckOutScmResult) {
                relativePathProjectDirectory = ((CheckOutScmResult)checkoutResult).getRelativePathProjectDirectory();
            }
            this.runGoals(relativePathProjectDirectory);
        }
    }

    private void runGoals(String relativePathProjectDirectory) throws MojoExecutionException {
        Commandline cl = new Commandline();
        try {
            cl.addSystemEnvironment();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Can't add system environment variables to mvn command line.", e);
        }
        cl.addEnvironment("MAVEN_TERMINATE_CMD", "on");
        if ("".equals(this.mavenHome)) {
            cl.setExecutable("mvn");
        } else {
            cl.setExecutable(this.mavenHome.concat("/bin/mvn"));
        }
        cl.setWorkingDirectory(this.determineWorkingDirectoryPath(this.getCheckoutDirectory(), relativePathProjectDirectory, this.goalsDirectory));
        if (this.goals != null) {
            String[] tokens = StringUtils.split((String)this.goals, (String)", ");
            for (int i = 0; i < tokens.length; ++i) {
                cl.createArg().setValue(tokens[i]);
            }
        }
        if (!StringUtils.isEmpty((String)this.profiles)) {
            cl.createArg().setValue("-P" + this.profiles);
        }
        DefaultConsumer consumer = new DefaultConsumer();
        try {
            int result = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)consumer);
            if (result != 0) {
                throw new MojoExecutionException("Result of mvn execution is: '" + result + "'. Release failed.");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Can't run goal " + this.goals, (Exception)((Object)e));
        }
    }

    protected String determineWorkingDirectoryPath(File checkoutDirectory, String relativePathProjectDirectory, String goalsDirectory) {
        File projectDirectory = StringUtils.isNotEmpty((String)relativePathProjectDirectory) ? new File(checkoutDirectory, relativePathProjectDirectory) : checkoutDirectory;
        if (StringUtils.isEmpty((String)goalsDirectory)) {
            return projectDirectory.getPath();
        }
        return new File(projectDirectory, goalsDirectory).getPath();
    }
}

