/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.gitexe.command.blame;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.blame.AbstractBlameCommand;
import org.apache.maven.scm.command.blame.BlameScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.gitexe.command.GitCommandLineUtils;
import org.apache.maven.scm.provider.git.gitexe.command.blame.GitBlameConsumer;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class GitBlameCommand
extends AbstractBlameCommand
implements GitCommand {
    public BlameScmResult executeBlameCommand(ScmProviderRepository repo, ScmFileSet workingDirectory, String filename) throws ScmException {
        CommandLineUtils.StringStreamConsumer stderr;
        GitBlameConsumer consumer;
        Commandline cl = GitBlameCommand.createCommandLine(workingDirectory.getBasedir(), filename);
        int exitCode = GitCommandLineUtils.execute(cl, (StreamConsumer)(consumer = new GitBlameConsumer(this.getLogger())), stderr = new CommandLineUtils.StringStreamConsumer(), this.getLogger());
        if (exitCode != 0) {
            return new BlameScmResult(cl.toString(), "The git blame command failed.", stderr.getOutput(), false);
        }
        return new BlameScmResult(cl.toString(), consumer.getLines());
    }

    public static Commandline createCommandLine(File workingDirectory, String filename) {
        Commandline cl = GitCommandLineUtils.getBaseGitCommandLine(workingDirectory, "blame");
        cl.createArg().setValue("--porcelain");
        cl.createArg().setValue(filename);
        return cl;
    }
}

