/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.BitSet;
import org.apache.maven.surefire.util.NestedRuntimeException;

public class UrlUtils {
    private static final BitSet UNRESERVED = new BitSet(256);

    public static URL getURL(File file) throws MalformedURLException {
        URL url = file.toURL();
        try {
            byte[] bytes = url.toString().getBytes("US-ASCII");
            StringBuffer buf = new StringBuffer(bytes.length);
            for (int i = 0; i < bytes.length; ++i) {
                byte b = bytes[i];
                if (UNRESERVED.get(b)) {
                    buf.append((char)b);
                    continue;
                }
                buf.append('%');
                buf.append(Character.forDigit(b >>> 4 & 0xF, 16));
                buf.append(Character.forDigit(b & 0xF, 16));
            }
            return new URL(buf.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new NestedRuntimeException(e);
        }
    }

    static {
        try {
            byte[] bytes = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'():/".getBytes("US-ASCII");
            for (int i = 0; i < bytes.length; ++i) {
                UNRESERVED.set(bytes[i]);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }
}

