/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.charts;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.DataMarker;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.ss.util.cellwalk.CellHandler;
import org.apache.poi.ss.util.cellwalk.CellWalk;
import org.apache.poi.ss.util.cellwalk.CellWalkContext;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumData;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumRef;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumVal;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTUnsignedInt;

class XSSFNumberCache {
    private CTNumData ctNumData;

    XSSFNumberCache(CTNumData ctNumData) {
        this.ctNumData = ctNumData;
    }

    static XSSFNumberCache buildCache(DataMarker marker, CTNumRef ctNumRef) {
        CellRangeAddress range = marker.getRange();
        int numOfPoints = range.getNumberOfCells();
        if (numOfPoints == 0) {
            return null;
        }
        XSSFNumberCache cache = new XSSFNumberCache(ctNumRef.addNewNumCache());
        cache.setPointCount(numOfPoints);
        Workbook wb = marker.getSheet().getWorkbook();
        FormulaEvaluator evaluator = wb.getCreationHelper().createFormulaEvaluator();
        CellWalk cellWalk = new CellWalk(marker);
        XSSFNumberCache xSSFNumberCache = cache;
        xSSFNumberCache.getClass();
        NumCacheCellHandler numCacheHandler = xSSFNumberCache.new NumCacheCellHandler(evaluator);
        cellWalk.traverse((CellHandler)numCacheHandler);
        return cache;
    }

    long getPointCount() {
        CTUnsignedInt pointCount = this.ctNumData.getPtCount();
        if (pointCount != null) {
            return pointCount.getVal();
        }
        return 0L;
    }

    double getValueAt(int index) {
        for (CTNumVal pt : this.ctNumData.getPtList()) {
            if (pt.getIdx() != (long)index) continue;
            return Double.valueOf(pt.getV());
        }
        return 0.0;
    }

    private void setPointCount(int numOfPoints) {
        this.ctNumData.addNewPtCount().setVal((long)numOfPoints);
    }

    private class NumCacheCellHandler
    implements CellHandler {
        private FormulaEvaluator evaluator;

        public NumCacheCellHandler(FormulaEvaluator evaluator) {
            this.evaluator = evaluator;
        }

        public void onCell(Cell cell, CellWalkContext ctx) {
            double pointValue = this.getOrEvalCellValue(cell);
            if (Double.isNaN(pointValue)) {
                return;
            }
            CTNumVal point = XSSFNumberCache.this.ctNumData.addNewPt();
            point.setIdx(ctx.getOrdinalNumber());
            point.setV(NumberToTextConverter.toText((double)pointValue));
        }

        private double getOrEvalCellValue(Cell cell) {
            CellValue value;
            int cellType = cell.getCellType();
            if (cellType == 0) {
                return cell.getNumericCellValue();
            }
            if (cellType == 2 && (value = this.evaluator.evaluate(cell)).getCellType() == 0) {
                return value.getNumberValue();
            }
            return Double.NaN;
        }
    }
}

