/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.transaction;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.transaction.TransactionCoordinatorClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionImpl
implements Transaction {
    private static final Logger log = LoggerFactory.getLogger(TransactionImpl.class);
    private final PulsarClientImpl client;
    private final long transactionTimeoutMs;
    private final long txnIdLeastBits;
    private final long txnIdMostBits;
    private final AtomicLong sequenceId = new AtomicLong(0L);
    private final Set<String> producedTopics;
    private final Set<String> ackedTopics;
    private final TransactionCoordinatorClientImpl tcClient;
    private Map<ConsumerImpl<?>, Integer> cumulativeAckConsumers;
    private final ArrayList<CompletableFuture<MessageId>> sendFutureList;
    private final ArrayList<CompletableFuture<Void>> ackFutureList;

    TransactionImpl(PulsarClientImpl client, long transactionTimeoutMs, long txnIdLeastBits, long txnIdMostBits) {
        this.client = client;
        this.transactionTimeoutMs = transactionTimeoutMs;
        this.txnIdLeastBits = txnIdLeastBits;
        this.txnIdMostBits = txnIdMostBits;
        this.producedTopics = new HashSet<String>();
        this.ackedTopics = new HashSet<String>();
        this.tcClient = client.getTcClient();
        this.sendFutureList = new ArrayList();
        this.ackFutureList = new ArrayList();
    }

    public long nextSequenceId() {
        return this.sequenceId.getAndIncrement();
    }

    public synchronized CompletableFuture<Void> registerProducedTopic(String topic) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        if (this.producedTopics.add(topic)) {
            completableFuture = this.tcClient.addPublishPartitionToTxnAsync(new TxnID(this.txnIdMostBits, this.txnIdLeastBits), Lists.newArrayList((Object[])new String[]{topic}));
        } else {
            completableFuture.complete(null);
        }
        return completableFuture;
    }

    public synchronized void registerSendOp(CompletableFuture<MessageId> sendFuture) {
        this.sendFutureList.add(sendFuture);
    }

    public synchronized CompletableFuture<Void> registerAckedTopic(String topic, String subscription) {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        if (this.ackedTopics.add(topic)) {
            completableFuture = this.tcClient.addSubscriptionToTxnAsync(new TxnID(this.txnIdMostBits, this.txnIdLeastBits), topic, subscription);
        } else {
            completableFuture.complete(null);
        }
        return completableFuture;
    }

    public synchronized void registerAckOp(CompletableFuture<Void> ackFuture) {
        this.ackFutureList.add(ackFuture);
    }

    public synchronized void registerCumulativeAckConsumer(ConsumerImpl<?> consumer) {
        if (this.cumulativeAckConsumers == null) {
            this.cumulativeAckConsumers = new HashMap();
        }
        this.cumulativeAckConsumers.put(consumer, 0);
    }

    public CompletableFuture<Void> commit() {
        ArrayList sendMessageIdList = new ArrayList(this.sendFutureList.size());
        CompletableFuture<Void> commitFuture = new CompletableFuture<Void>();
        this.allOpComplete().whenComplete((v, e) -> {
            if (e != null) {
                this.abort().whenComplete((vx, ex) -> commitFuture.completeExceptionally((Throwable)e));
            } else {
                for (CompletableFuture<MessageId> future : this.sendFutureList) {
                    future.thenAccept(sendMessageIdList::add);
                }
                this.tcClient.commitAsync(new TxnID(this.txnIdMostBits, this.txnIdLeastBits), sendMessageIdList).whenComplete((vx, ex) -> {
                    if (ex != null) {
                        commitFuture.completeExceptionally((Throwable)ex);
                    } else {
                        commitFuture.complete((Void)vx);
                    }
                });
            }
        });
        return commitFuture;
    }

    public CompletableFuture<Void> abort() {
        ArrayList sendMessageIdList = new ArrayList(this.sendFutureList.size());
        CompletableFuture<Void> abortFuture = new CompletableFuture<Void>();
        this.allOpComplete().whenComplete((v, e) -> {
            if (e != null) {
                log.error(e.getMessage());
            }
            for (CompletableFuture<MessageId> future : this.sendFutureList) {
                future.thenAccept(sendMessageIdList::add);
            }
            if (this.cumulativeAckConsumers != null) {
                this.cumulativeAckConsumers.forEach((consumer, integer) -> this.cumulativeAckConsumers.putIfAbsent((ConsumerImpl<?>)consumer, consumer.clearIncomingMessagesAndGetMessageNumber()));
            }
            this.tcClient.abortAsync(new TxnID(this.txnIdMostBits, this.txnIdLeastBits), sendMessageIdList).whenComplete((vx, ex) -> {
                if (this.cumulativeAckConsumers != null) {
                    this.cumulativeAckConsumers.forEach(ConsumerImpl::increaseAvailablePermits);
                    this.cumulativeAckConsumers.clear();
                }
                if (ex != null) {
                    abortFuture.completeExceptionally((Throwable)ex);
                } else {
                    abortFuture.complete(null);
                }
            });
        });
        return abortFuture;
    }

    private CompletableFuture<Void> allOpComplete() {
        ArrayList<CompletableFuture<Object>> futureList = new ArrayList<CompletableFuture<Object>>();
        futureList.addAll(this.sendFutureList);
        futureList.addAll(this.ackFutureList);
        return CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0]));
    }

    public PulsarClientImpl getClient() {
        return this.client;
    }

    public long getTransactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public long getTxnIdLeastBits() {
        return this.txnIdLeastBits;
    }

    public long getTxnIdMostBits() {
        return this.txnIdMostBits;
    }

    public AtomicLong getSequenceId() {
        return this.sequenceId;
    }

    public Set<String> getProducedTopics() {
        return this.producedTopics;
    }

    public Set<String> getAckedTopics() {
        return this.ackedTopics;
    }

    public TransactionCoordinatorClientImpl getTcClient() {
        return this.tcClient;
    }

    public Map<ConsumerImpl<?>, Integer> getCumulativeAckConsumers() {
        return this.cumulativeAckConsumers;
    }

    public ArrayList<CompletableFuture<MessageId>> getSendFutureList() {
        return this.sendFutureList;
    }

    public ArrayList<CompletableFuture<Void>> getAckFutureList() {
        return this.ackFutureList;
    }
}

