/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.compression;

import io.airlift.compress.lz4.Lz4Compressor;
import io.airlift.compress.lz4.Lz4Decompressor;
import io.airlift.compress.lz4.Lz4RawCompressor;
import io.airlift.compress.lz4.Lz4RawDecompressor;
import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.FastThreadLocal;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.compression.CompressionCodec;

public class CompressionCodecLZ4
implements CompressionCodec {
    private static final FastThreadLocal<Lz4Compressor> LZ4_COMPRESSOR = new FastThreadLocal<Lz4Compressor>(){

        protected Lz4Compressor initialValue() throws Exception {
            return new Lz4Compressor();
        }
    };
    private static final FastThreadLocal<Lz4Decompressor> LZ4_DECOMPRESSOR = new FastThreadLocal<Lz4Decompressor>(){

        protected Lz4Decompressor initialValue() throws Exception {
            return new Lz4Decompressor();
        }
    };
    private static final FastThreadLocal<int[]> LZ4_TABLE = new FastThreadLocal<int[]>(){

        protected int[] initialValue() throws Exception {
            return new int[4096];
        }
    };

    @Override
    public ByteBuf encode(ByteBuf source) {
        int compressedLength;
        int uncompressedLength = source.readableBytes();
        int maxLength = Lz4RawCompressor.maxCompressedLength((int)uncompressedLength);
        ByteBuf target = PulsarByteBufAllocator.DEFAULT.buffer(maxLength, maxLength);
        if (source.hasMemoryAddress() && target.hasMemoryAddress()) {
            compressedLength = Lz4RawCompressor.compress(null, (long)(source.memoryAddress() + (long)source.readerIndex()), (int)source.readableBytes(), null, (long)target.memoryAddress(), (long)maxLength, (int[])((int[])LZ4_TABLE.get()));
        } else {
            ByteBuffer sourceNio = source.nioBuffer(source.readerIndex(), source.readableBytes());
            ByteBuffer targetNio = target.nioBuffer(0, maxLength);
            ((Lz4Compressor)LZ4_COMPRESSOR.get()).compress(sourceNio, targetNio);
            compressedLength = targetNio.position();
        }
        target.writerIndex(compressedLength);
        return target;
    }

    @Override
    public ByteBuf decode(ByteBuf encoded, int uncompressedLength) throws IOException {
        ByteBuf uncompressed = PulsarByteBufAllocator.DEFAULT.buffer(uncompressedLength, uncompressedLength);
        if (encoded.hasMemoryAddress() && uncompressed.hasMemoryAddress()) {
            Lz4RawDecompressor.decompress(null, (long)(encoded.memoryAddress() + (long)encoded.readerIndex()), (long)(encoded.memoryAddress() + (long)encoded.writerIndex()), null, (long)uncompressed.memoryAddress(), (long)(uncompressed.memoryAddress() + (long)uncompressedLength));
        } else {
            ByteBuffer uncompressedNio = uncompressed.nioBuffer(0, uncompressedLength);
            ByteBuffer encodedNio = encoded.nioBuffer(encoded.readerIndex(), encoded.readableBytes());
            ((Lz4Decompressor)LZ4_DECOMPRESSOR.get()).decompress(encodedNio, uncompressedNio);
        }
        uncompressed.writerIndex(uncompressedLength);
        return uncompressed;
    }
}

