/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.protocol;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.intercept.InterceptException;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.util.protobuf.ByteBufCodedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PulsarDecoder
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(PulsarDecoder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf buffer = (ByteBuf)msg;
        PulsarApi.BaseCommand cmd = null;
        PulsarApi.BaseCommand.Builder cmdBuilder = null;
        try {
            int cmdSize = (int)buffer.readUnsignedInt();
            int writerIndex = buffer.writerIndex();
            buffer.writerIndex(buffer.readerIndex() + cmdSize);
            ByteBufCodedInputStream cmdInputStream = ByteBufCodedInputStream.get(buffer);
            cmdBuilder = PulsarApi.BaseCommand.newBuilder();
            cmd = cmdBuilder.mergeFrom(cmdInputStream, null).build();
            buffer.writerIndex(writerIndex);
            cmdInputStream.recycle();
            if (log.isDebugEnabled()) {
                log.debug("[{}] Received cmd {}", (Object)ctx.channel().remoteAddress(), (Object)cmd.getType());
            }
            this.messageReceived();
            switch (cmd.getType()) {
                case PARTITIONED_METADATA: {
                    Preconditions.checkArgument((boolean)cmd.hasPartitionMetadata());
                    try {
                        this.interceptCommand(cmd);
                        this.handlePartitionMetadataRequest(cmd.getPartitionMetadata());
                        return;
                    }
                    catch (InterceptException e) {
                        ctx.writeAndFlush((Object)Commands.newPartitionMetadataResponse(this.getServerError(e.getErrorCode()), e.getMessage(), cmd.getPartitionMetadata().getRequestId()));
                        return;
                    }
                    finally {
                        cmd.getPartitionMetadata().recycle();
                    }
                }
                case PARTITIONED_METADATA_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasPartitionMetadataResponse());
                    this.handlePartitionResponse(cmd.getPartitionMetadataResponse());
                    cmd.getPartitionMetadataResponse().recycle();
                    return;
                }
                case LOOKUP: {
                    Preconditions.checkArgument((boolean)cmd.hasLookupTopic());
                    this.handleLookup(cmd.getLookupTopic());
                    cmd.getLookupTopic().recycle();
                    return;
                }
                case LOOKUP_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasLookupTopicResponse());
                    this.handleLookupResponse(cmd.getLookupTopicResponse());
                    cmd.getLookupTopicResponse().recycle();
                    return;
                }
                case ACK: {
                    Preconditions.checkArgument((boolean)cmd.hasAck());
                    this.handleAck(cmd.getAck());
                    int i = 0;
                    while (true) {
                        if (i >= cmd.getAck().getMessageIdCount()) {
                            cmd.getAck().recycle();
                            return;
                        }
                        cmd.getAck().getMessageId(i).recycle();
                        ++i;
                    }
                }
                case ACK_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasAckResponse());
                    this.handleAckResponse(cmd.getAckResponse());
                    cmd.getAckResponse().recycle();
                    return;
                }
                case CLOSE_CONSUMER: {
                    Preconditions.checkArgument((boolean)cmd.hasCloseConsumer());
                    this.safeInterceptCommand(cmd);
                    this.handleCloseConsumer(cmd.getCloseConsumer());
                    cmd.getCloseConsumer().recycle();
                    return;
                }
                case CLOSE_PRODUCER: {
                    Preconditions.checkArgument((boolean)cmd.hasCloseProducer());
                    this.safeInterceptCommand(cmd);
                    this.handleCloseProducer(cmd.getCloseProducer());
                    cmd.getCloseProducer().recycle();
                    return;
                }
                case CONNECT: {
                    Preconditions.checkArgument((boolean)cmd.hasConnect());
                    this.handleConnect(cmd.getConnect());
                    cmd.getConnect().recycle();
                    return;
                }
                case CONNECTED: {
                    Preconditions.checkArgument((boolean)cmd.hasConnected());
                    this.handleConnected(cmd.getConnected());
                    cmd.getConnected().recycle();
                    return;
                }
                case ERROR: {
                    Preconditions.checkArgument((boolean)cmd.hasError());
                    this.handleError(cmd.getError());
                    cmd.getError().recycle();
                    return;
                }
                case FLOW: {
                    Preconditions.checkArgument((boolean)cmd.hasFlow());
                    this.handleFlow(cmd.getFlow());
                    cmd.getFlow().recycle();
                    return;
                }
                case MESSAGE: {
                    Preconditions.checkArgument((boolean)cmd.hasMessage());
                    this.handleMessage(cmd.getMessage(), buffer);
                    cmd.getMessage().recycle();
                    return;
                }
                case PRODUCER: {
                    Preconditions.checkArgument((boolean)cmd.hasProducer());
                    try {
                        this.interceptCommand(cmd);
                        this.handleProducer(cmd.getProducer());
                        return;
                    }
                    catch (InterceptException e) {
                        ctx.writeAndFlush((Object)Commands.newError(cmd.getProducer().getRequestId(), this.getServerError(e.getErrorCode()), e.getMessage()));
                        return;
                    }
                    finally {
                        cmd.getProducer().recycle();
                    }
                }
                case SEND: {
                    Preconditions.checkArgument((boolean)cmd.hasSend());
                    try {
                        this.interceptCommand(cmd);
                        ByteBuf headersAndPayload = buffer.markReaderIndex();
                        this.handleSend(cmd.getSend(), headersAndPayload);
                        return;
                    }
                    catch (InterceptException e) {
                        ctx.writeAndFlush((Object)Commands.newSendError(cmd.getSend().getProducerId(), cmd.getSend().getSequenceId(), this.getServerError(e.getErrorCode()), e.getMessage()));
                        return;
                    }
                    finally {
                        cmd.getSend().recycle();
                    }
                }
                case SEND_ERROR: {
                    Preconditions.checkArgument((boolean)cmd.hasSendError());
                    this.handleSendError(cmd.getSendError());
                    cmd.getSendError().recycle();
                    return;
                }
                case SEND_RECEIPT: {
                    Preconditions.checkArgument((boolean)cmd.hasSendReceipt());
                    this.handleSendReceipt(cmd.getSendReceipt());
                    cmd.getSendReceipt().recycle();
                    return;
                }
                case SUBSCRIBE: {
                    Preconditions.checkArgument((boolean)cmd.hasSubscribe());
                    try {
                        this.interceptCommand(cmd);
                        this.handleSubscribe(cmd.getSubscribe());
                        return;
                    }
                    catch (InterceptException e) {
                        ctx.writeAndFlush((Object)Commands.newError(cmd.getSubscribe().getRequestId(), this.getServerError(e.getErrorCode()), e.getMessage()));
                        return;
                    }
                    finally {
                        cmd.getSubscribe().recycle();
                    }
                }
                case SUCCESS: {
                    Preconditions.checkArgument((boolean)cmd.hasSuccess());
                    this.handleSuccess(cmd.getSuccess());
                    cmd.getSuccess().recycle();
                    return;
                }
                case PRODUCER_SUCCESS: {
                    Preconditions.checkArgument((boolean)cmd.hasProducerSuccess());
                    this.handleProducerSuccess(cmd.getProducerSuccess());
                    cmd.getProducerSuccess().recycle();
                    return;
                }
                case UNSUBSCRIBE: {
                    Preconditions.checkArgument((boolean)cmd.hasUnsubscribe());
                    this.safeInterceptCommand(cmd);
                    this.handleUnsubscribe(cmd.getUnsubscribe());
                    cmd.getUnsubscribe().recycle();
                    return;
                }
                case SEEK: {
                    Preconditions.checkArgument((boolean)cmd.hasSeek());
                    try {
                        this.interceptCommand(cmd);
                        this.handleSeek(cmd.getSeek());
                        return;
                    }
                    catch (InterceptException e) {
                        ctx.writeAndFlush((Object)Commands.newError(cmd.getSeek().getRequestId(), this.getServerError(e.getErrorCode()), e.getMessage()));
                        return;
                    }
                    finally {
                        cmd.getSeek().recycle();
                    }
                }
                case PING: {
                    Preconditions.checkArgument((boolean)cmd.hasPing());
                    this.handlePing(cmd.getPing());
                    cmd.getPing().recycle();
                    return;
                }
                case PONG: {
                    Preconditions.checkArgument((boolean)cmd.hasPong());
                    this.handlePong(cmd.getPong());
                    cmd.getPong().recycle();
                    return;
                }
                case REDELIVER_UNACKNOWLEDGED_MESSAGES: {
                    Preconditions.checkArgument((boolean)cmd.hasRedeliverUnacknowledgedMessages());
                    this.handleRedeliverUnacknowledged(cmd.getRedeliverUnacknowledgedMessages());
                    cmd.getRedeliverUnacknowledgedMessages().recycle();
                    return;
                }
                case CONSUMER_STATS: {
                    Preconditions.checkArgument((boolean)cmd.hasConsumerStats());
                    this.handleConsumerStats(cmd.getConsumerStats());
                    cmd.getConsumerStats().recycle();
                    return;
                }
                case CONSUMER_STATS_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasConsumerStatsResponse());
                    this.handleConsumerStatsResponse(cmd.getConsumerStatsResponse());
                    cmd.getConsumerStatsResponse().recycle();
                    return;
                }
                case REACHED_END_OF_TOPIC: {
                    Preconditions.checkArgument((boolean)cmd.hasReachedEndOfTopic());
                    this.handleReachedEndOfTopic(cmd.getReachedEndOfTopic());
                    cmd.getReachedEndOfTopic().recycle();
                    return;
                }
                case GET_LAST_MESSAGE_ID: {
                    Preconditions.checkArgument((boolean)cmd.hasGetLastMessageId());
                    this.handleGetLastMessageId(cmd.getGetLastMessageId());
                    cmd.getGetLastMessageId().recycle();
                    return;
                }
                case GET_LAST_MESSAGE_ID_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasGetLastMessageIdResponse());
                    this.handleGetLastMessageIdSuccess(cmd.getGetLastMessageIdResponse());
                    cmd.getGetLastMessageIdResponse().recycle();
                    return;
                }
                case ACTIVE_CONSUMER_CHANGE: {
                    this.handleActiveConsumerChange(cmd.getActiveConsumerChange());
                    cmd.getActiveConsumerChange().recycle();
                    return;
                }
                case GET_TOPICS_OF_NAMESPACE: {
                    Preconditions.checkArgument((boolean)cmd.hasGetTopicsOfNamespace());
                    try {
                        this.interceptCommand(cmd);
                        this.handleGetTopicsOfNamespace(cmd.getGetTopicsOfNamespace());
                    }
                    catch (InterceptException e) {
                        ctx.writeAndFlush((Object)Commands.newError(cmd.getGetTopicsOfNamespace().getRequestId(), this.getServerError(e.getErrorCode()), e.getMessage()));
                    }
                    cmd.getGetTopicsOfNamespace().recycle();
                    return;
                }
                case GET_TOPICS_OF_NAMESPACE_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasGetTopicsOfNamespaceResponse());
                    this.handleGetTopicsOfNamespaceSuccess(cmd.getGetTopicsOfNamespaceResponse());
                    cmd.getGetTopicsOfNamespaceResponse().recycle();
                    return;
                }
                case GET_SCHEMA: {
                    Preconditions.checkArgument((boolean)cmd.hasGetSchema());
                    try {
                        this.interceptCommand(cmd);
                        this.handleGetSchema(cmd.getGetSchema());
                        return;
                    }
                    catch (InterceptException e) {
                        ctx.writeAndFlush((Object)Commands.newGetSchemaResponseError(cmd.getGetSchema().getRequestId(), this.getServerError(e.getErrorCode()), e.getMessage()));
                        return;
                    }
                    finally {
                        cmd.getGetSchema().recycle();
                    }
                }
                case GET_SCHEMA_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasGetSchemaResponse());
                    this.handleGetSchemaResponse(cmd.getGetSchemaResponse());
                    cmd.getGetSchemaResponse().recycle();
                    return;
                }
                case GET_OR_CREATE_SCHEMA: {
                    Preconditions.checkArgument((boolean)cmd.hasGetOrCreateSchema());
                    try {
                        this.interceptCommand(cmd);
                        this.handleGetOrCreateSchema(cmd.getGetOrCreateSchema());
                        return;
                    }
                    catch (InterceptException e) {
                        ctx.writeAndFlush((Object)Commands.newGetOrCreateSchemaResponseError(cmd.getGetOrCreateSchema().getRequestId(), this.getServerError(e.getErrorCode()), e.getMessage()));
                        return;
                    }
                    finally {
                        cmd.getGetOrCreateSchema().recycle();
                    }
                }
                case GET_OR_CREATE_SCHEMA_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasGetOrCreateSchemaResponse());
                    this.handleGetOrCreateSchemaResponse(cmd.getGetOrCreateSchemaResponse());
                    cmd.getGetOrCreateSchemaResponse().recycle();
                    return;
                }
                case AUTH_CHALLENGE: {
                    Preconditions.checkArgument((boolean)cmd.hasAuthChallenge());
                    this.handleAuthChallenge(cmd.getAuthChallenge());
                    cmd.getAuthChallenge().recycle();
                    return;
                }
                case AUTH_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasAuthResponse());
                    this.handleAuthResponse(cmd.getAuthResponse());
                    cmd.getAuthResponse().recycle();
                    return;
                }
                case NEW_TXN: {
                    Preconditions.checkArgument((boolean)cmd.hasNewTxn());
                    this.handleNewTxn(cmd.getNewTxn());
                    cmd.getNewTxn().recycle();
                    return;
                }
                case NEW_TXN_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasNewTxnResponse());
                    this.handleNewTxnResponse(cmd.getNewTxnResponse());
                    cmd.getNewTxnResponse().recycle();
                    return;
                }
                case ADD_PARTITION_TO_TXN: {
                    Preconditions.checkArgument((boolean)cmd.hasAddPartitionToTxn());
                    this.handleAddPartitionToTxn(cmd.getAddPartitionToTxn());
                    cmd.getAddPartitionToTxn().recycle();
                    return;
                }
                case ADD_PARTITION_TO_TXN_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasAddPartitionToTxnResponse());
                    this.handleAddPartitionToTxnResponse(cmd.getAddPartitionToTxnResponse());
                    cmd.getAddPartitionToTxnResponse().recycle();
                    return;
                }
                case ADD_SUBSCRIPTION_TO_TXN: {
                    Preconditions.checkArgument((boolean)cmd.hasAddSubscriptionToTxn());
                    this.handleAddSubscriptionToTxn(cmd.getAddSubscriptionToTxn());
                    cmd.getAddSubscriptionToTxn().recycle();
                    return;
                }
                case ADD_SUBSCRIPTION_TO_TXN_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasAddSubscriptionToTxnResponse());
                    this.handleAddSubscriptionToTxnResponse(cmd.getAddSubscriptionToTxnResponse());
                    cmd.getAddSubscriptionToTxnResponse().recycle();
                    return;
                }
                case END_TXN: {
                    Preconditions.checkArgument((boolean)cmd.hasEndTxn());
                    this.handleEndTxn(cmd.getEndTxn());
                    cmd.getEndTxn().recycle();
                    return;
                }
                case END_TXN_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasEndTxnResponse());
                    this.handleEndTxnResponse(cmd.getEndTxnResponse());
                    cmd.getEndTxnResponse().recycle();
                    return;
                }
                case END_TXN_ON_PARTITION: {
                    Preconditions.checkArgument((boolean)cmd.hasEndTxnOnPartition());
                    this.handleEndTxnOnPartition(cmd.getEndTxnOnPartition());
                    cmd.getEndTxnOnPartition().recycle();
                    return;
                }
                case END_TXN_ON_PARTITION_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasEndTxnOnPartitionResponse());
                    this.handleEndTxnOnPartitionResponse(cmd.getEndTxnOnPartitionResponse());
                    cmd.getEndTxnOnPartitionResponse().recycle();
                    return;
                }
                case END_TXN_ON_SUBSCRIPTION: {
                    Preconditions.checkArgument((boolean)cmd.hasEndTxnOnSubscription());
                    this.handleEndTxnOnSubscription(cmd.getEndTxnOnSubscription());
                    cmd.getEndTxnOnSubscription().recycle();
                    return;
                }
                case END_TXN_ON_SUBSCRIPTION_RESPONSE: {
                    Preconditions.checkArgument((boolean)cmd.hasEndTxnOnSubscriptionResponse());
                    this.handleEndTxnOnSubscriptionResponse(cmd.getEndTxnOnSubscriptionResponse());
                    cmd.getEndTxnOnSubscriptionResponse().recycle();
                    return;
                }
            }
            return;
        }
        finally {
            if (cmdBuilder != null) {
                cmdBuilder.recycle();
            }
            if (cmd != null) {
                cmd.recycle();
            }
            buffer.release();
        }
    }

    protected abstract void messageReceived();

    private PulsarApi.ServerError getServerError(int errorCode) {
        PulsarApi.ServerError serverError = PulsarApi.ServerError.valueOf(errorCode);
        return serverError == null ? PulsarApi.ServerError.UnknownError : serverError;
    }

    private void safeInterceptCommand(PulsarApi.BaseCommand command) {
        try {
            this.interceptCommand(command);
        }
        catch (InterceptException interceptException) {
            // empty catch block
        }
    }

    protected void interceptCommand(PulsarApi.BaseCommand command) throws InterceptException {
    }

    protected void handlePartitionMetadataRequest(PulsarApi.CommandPartitionedTopicMetadata response) {
        throw new UnsupportedOperationException();
    }

    protected void handlePartitionResponse(PulsarApi.CommandPartitionedTopicMetadataResponse response) {
        throw new UnsupportedOperationException();
    }

    protected void handleLookup(PulsarApi.CommandLookupTopic lookup) {
        throw new UnsupportedOperationException();
    }

    protected void handleLookupResponse(PulsarApi.CommandLookupTopicResponse connection) {
        throw new UnsupportedOperationException();
    }

    protected void handleConnect(PulsarApi.CommandConnect connect) {
        throw new UnsupportedOperationException();
    }

    protected void handleConnected(PulsarApi.CommandConnected connected) {
        throw new UnsupportedOperationException();
    }

    protected void handleSubscribe(PulsarApi.CommandSubscribe subscribe) {
        throw new UnsupportedOperationException();
    }

    protected void handleProducer(PulsarApi.CommandProducer producer) {
        throw new UnsupportedOperationException();
    }

    protected void handleSend(PulsarApi.CommandSend send, ByteBuf headersAndPayload) {
        throw new UnsupportedOperationException();
    }

    protected void handleSendReceipt(PulsarApi.CommandSendReceipt sendReceipt) {
        throw new UnsupportedOperationException();
    }

    protected void handleSendError(PulsarApi.CommandSendError sendError) {
        throw new UnsupportedOperationException();
    }

    protected void handleMessage(PulsarApi.CommandMessage cmdMessage, ByteBuf headersAndPayload) {
        throw new UnsupportedOperationException();
    }

    protected void handleAck(PulsarApi.CommandAck ack) {
        throw new UnsupportedOperationException();
    }

    protected void handleAckResponse(PulsarApi.CommandAckResponse ackResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleFlow(PulsarApi.CommandFlow flow) {
        throw new UnsupportedOperationException();
    }

    protected void handleRedeliverUnacknowledged(PulsarApi.CommandRedeliverUnacknowledgedMessages redeliver) {
        throw new UnsupportedOperationException();
    }

    protected void handleUnsubscribe(PulsarApi.CommandUnsubscribe unsubscribe) {
        throw new UnsupportedOperationException();
    }

    protected void handleSeek(PulsarApi.CommandSeek seek) {
        throw new UnsupportedOperationException();
    }

    protected void handleActiveConsumerChange(PulsarApi.CommandActiveConsumerChange change) {
        throw new UnsupportedOperationException();
    }

    protected void handleSuccess(PulsarApi.CommandSuccess success) {
        throw new UnsupportedOperationException();
    }

    protected void handleProducerSuccess(PulsarApi.CommandProducerSuccess success) {
        throw new UnsupportedOperationException();
    }

    protected void handleError(PulsarApi.CommandError error) {
        throw new UnsupportedOperationException();
    }

    protected void handleCloseProducer(PulsarApi.CommandCloseProducer closeProducer) {
        throw new UnsupportedOperationException();
    }

    protected void handleCloseConsumer(PulsarApi.CommandCloseConsumer closeConsumer) {
        throw new UnsupportedOperationException();
    }

    protected void handlePing(PulsarApi.CommandPing ping) {
        throw new UnsupportedOperationException();
    }

    protected void handlePong(PulsarApi.CommandPong pong) {
        throw new UnsupportedOperationException();
    }

    protected void handleConsumerStats(PulsarApi.CommandConsumerStats commandConsumerStats) {
        throw new UnsupportedOperationException();
    }

    protected void handleConsumerStatsResponse(PulsarApi.CommandConsumerStatsResponse commandConsumerStatsResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleReachedEndOfTopic(PulsarApi.CommandReachedEndOfTopic commandReachedEndOfTopic) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetLastMessageId(PulsarApi.CommandGetLastMessageId getLastMessageId) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetLastMessageIdSuccess(PulsarApi.CommandGetLastMessageIdResponse success) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetTopicsOfNamespace(PulsarApi.CommandGetTopicsOfNamespace commandGetTopicsOfNamespace) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetTopicsOfNamespaceSuccess(PulsarApi.CommandGetTopicsOfNamespaceResponse response) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetSchema(PulsarApi.CommandGetSchema commandGetSchema) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetSchemaResponse(PulsarApi.CommandGetSchemaResponse commandGetSchemaResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetOrCreateSchema(PulsarApi.CommandGetOrCreateSchema commandGetOrCreateSchema) {
        throw new UnsupportedOperationException();
    }

    protected void handleGetOrCreateSchemaResponse(PulsarApi.CommandGetOrCreateSchemaResponse commandGetOrCreateSchemaResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleAuthResponse(PulsarApi.CommandAuthResponse commandAuthResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleAuthChallenge(PulsarApi.CommandAuthChallenge commandAuthChallenge) {
        throw new UnsupportedOperationException();
    }

    protected void handleNewTxn(PulsarApi.CommandNewTxn commandNewTxn) {
        throw new UnsupportedOperationException();
    }

    protected void handleNewTxnResponse(PulsarApi.CommandNewTxnResponse commandNewTxnResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleAddPartitionToTxn(PulsarApi.CommandAddPartitionToTxn commandAddPartitionToTxn) {
        throw new UnsupportedOperationException();
    }

    protected void handleAddPartitionToTxnResponse(PulsarApi.CommandAddPartitionToTxnResponse commandAddPartitionToTxnResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleAddSubscriptionToTxn(PulsarApi.CommandAddSubscriptionToTxn commandAddSubscriptionToTxn) {
        throw new UnsupportedOperationException();
    }

    protected void handleAddSubscriptionToTxnResponse(PulsarApi.CommandAddSubscriptionToTxnResponse commandAddSubscriptionToTxnResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleEndTxn(PulsarApi.CommandEndTxn commandEndTxn) {
        throw new UnsupportedOperationException();
    }

    protected void handleEndTxnResponse(PulsarApi.CommandEndTxnResponse commandEndTxnResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleEndTxnOnPartition(PulsarApi.CommandEndTxnOnPartition commandEndTxnOnPartition) {
        throw new UnsupportedOperationException();
    }

    protected void handleEndTxnOnPartitionResponse(PulsarApi.CommandEndTxnOnPartitionResponse commandEndTxnOnPartitionResponse) {
        throw new UnsupportedOperationException();
    }

    protected void handleEndTxnOnSubscription(PulsarApi.CommandEndTxnOnSubscription commandEndTxnOnSubscription) {
        throw new UnsupportedOperationException();
    }

    protected void handleEndTxnOnSubscriptionResponse(PulsarApi.CommandEndTxnOnSubscriptionResponse commandEndTxnOnSubscriptionResponse) {
        throw new UnsupportedOperationException();
    }
}

