/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.collections;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public interface LongPairRangeSet<T extends Comparable<T>> {
    public void addOpenClosed(long var1, long var3, long var5, long var7);

    public boolean contains(long var1, long var3);

    public Range<T> rangeContaining(long var1, long var3);

    public void removeAtMost(long var1, long var3);

    public boolean isEmpty();

    public void clear();

    public Range<T> span();

    public Collection<Range<T>> asRanges();

    public void forEach(RangeProcessor<T> var1);

    public void forEach(RangeProcessor<T> var1, LongPairConsumer<? extends T> var2);

    public int size();

    public Range<T> firstRange();

    public Range<T> lastRange();

    public static class DefaultRangeSet<T extends Comparable<T>>
    implements LongPairRangeSet<T> {
        RangeSet<T> set = TreeRangeSet.create();
        private final LongPairConsumer<T> consumer;

        public DefaultRangeSet(LongPairConsumer<T> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void clear() {
            this.set.clear();
        }

        @Override
        public void addOpenClosed(long key1, long value1, long key2, long value2) {
            this.set.add(Range.openClosed((Comparable)((Comparable)this.consumer.apply(key1, value1)), (Comparable)((Comparable)this.consumer.apply(key2, value2))));
        }

        public boolean contains(T position) {
            return this.set.contains(position);
        }

        public Range<T> rangeContaining(T position) {
            return this.set.rangeContaining(position);
        }

        @Override
        public Range<T> rangeContaining(long key, long value) {
            return this.rangeContaining((Comparable)this.consumer.apply(key, value));
        }

        public void remove(Range<T> range) {
            this.set.remove(range);
        }

        @Override
        public void removeAtMost(long key, long value) {
            this.set.remove(Range.atMost((Comparable)((Comparable)this.consumer.apply(key, value))));
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public Range<T> span() {
            return this.set.span();
        }

        @Override
        public Set<Range<T>> asRanges() {
            return this.set.asRanges();
        }

        @Override
        public void forEach(RangeProcessor<T> action) {
            this.forEach(action, this.consumer);
        }

        @Override
        public void forEach(RangeProcessor<T> action, LongPairConsumer<? extends T> consumer) {
            Range range;
            Iterator iterator = this.asRanges().iterator();
            while (iterator.hasNext() && action.process(range = (Range)iterator.next())) {
            }
        }

        @Override
        public boolean contains(long key, long value) {
            return this.contains((Comparable)this.consumer.apply(key, value));
        }

        @Override
        public Range<T> firstRange() {
            return (Range)this.set.asRanges().iterator().next();
        }

        @Override
        public Range<T> lastRange() {
            if (this.set.asRanges().isEmpty()) {
                return null;
            }
            ArrayList list = Lists.newArrayList(this.set.asRanges().iterator());
            return (Range)list.get(list.size() - 1);
        }

        @Override
        public int size() {
            return this.set.asRanges().size();
        }

        public String toString() {
            return this.set.toString();
        }
    }

    public static class LongPair
    implements Comparable<LongPair> {
        public static final LongPair earliest = new LongPair(-1L, -1L);
        public static final LongPair latest = new LongPair(Integer.MAX_VALUE, Integer.MAX_VALUE);
        private long key;
        private long value;

        public LongPair(long key, long value) {
            this.key = key;
            this.value = value;
        }

        public long getKey() {
            return this.key;
        }

        public long getValue() {
            return this.value;
        }

        @Override
        public int compareTo(LongPair o) {
            return ComparisonChain.start().compare(this.key, o.getKey()).compare(this.value, o.getValue()).result();
        }

        public String toString() {
            return String.format("%d:%d", this.key, this.value);
        }
    }

    public static interface RangeProcessor<T extends Comparable<T>> {
        public boolean process(Range<T> var1);
    }

    public static interface LongPairConsumer<T> {
        public T apply(long var1, long var3);
    }
}

