/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.mysql.type;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.dbdiscovery.spi.DatabaseDiscoveryProviderAlgorithm;
import org.apache.shardingsphere.dbdiscovery.spi.ReplicaDataSourceStatus;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.infra.database.metadata.dialect.MySQLDataSourceMetaData;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.executor.kernel.ExecutorEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MGRMySQLDatabaseDiscoveryProviderAlgorithm
implements DatabaseDiscoveryProviderAlgorithm {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MGRMySQLDatabaseDiscoveryProviderAlgorithm.class);
    private static final String QUERY_PLUGIN_STATUS = "SELECT PLUGIN_STATUS FROM information_schema.PLUGINS WHERE PLUGIN_NAME='group_replication'";
    private static final String QUERY_SINGLE_PRIMARY_MODE = "SELECT VARIABLE_VALUE FROM performance_schema.global_variables WHERE VARIABLE_NAME='group_replication_single_primary_mode'";
    private static final String QUERY_GROUP_NAME = "SELECT VARIABLE_VALUE FROM performance_schema.global_variables WHERE VARIABLE_NAME='group_replication_group_name'";
    private static final String QUERY_MEMBER_LIST = "SELECT MEMBER_HOST, MEMBER_PORT, MEMBER_STATE FROM performance_schema.replication_group_members";
    private static final String QUERY_PRIMARY_DATA_SOURCE = "SELECT MEMBER_HOST, MEMBER_PORT FROM performance_schema.replication_group_members WHERE MEMBER_ID = (SELECT VARIABLE_VALUE FROM performance_schema.global_status WHERE VARIABLE_NAME = 'group_replication_primary_member')";
    private static final String QUERY_CURRENT_MEMBER_STATE = "SELECT MEMBER_STATE FROM performance_schema.replication_group_members WHERE MEMBER_HOST=? AND MEMBER_PORT=?";
    private Properties props;

    public void init(Properties props) {
        this.props = props;
    }

    public void checkEnvironment(String databaseName, Collection<DataSource> dataSources) {
        ExecutorService executorService = ExecutorEngine.createExecutorEngineWithCPUAndResources((int)dataSources.size()).getExecutorServiceManager().getExecutorService();
        LinkedList<CompletableFuture<Void>> completableFutures = new LinkedList<CompletableFuture<Void>>();
        for (DataSource dataSource : dataSources) {
            completableFutures.add(this.runAsyncCheckEnvironment(databaseName, dataSource, executorService));
        }
        CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0]));
        Iterator mgrInstancesFuture = completableFutures.stream().iterator();
        while (mgrInstancesFuture.hasNext()) {
            ((CompletableFuture)mgrInstancesFuture.next()).join();
        }
    }

    private CompletableFuture<Void> runAsyncCheckEnvironment(String databaseName, DataSource dataSource, ExecutorService executorService) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.checkSingleDatasourceEnvironment(databaseName, dataSource);
            }
            catch (SQLException ex) {
                throw new ShardingSphereException((Exception)ex);
            }
        }, executorService);
    }

    private void checkSingleDatasourceEnvironment(String databaseName, DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            this.checkPluginActive(databaseName, statement);
            this.checkSinglePrimaryMode(databaseName, statement);
            this.checkGroupName(databaseName, statement);
            this.checkMemberInstanceURL(databaseName, connection.getMetaData().getURL(), statement);
        }
    }

    private void checkPluginActive(String databaseName, Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery(QUERY_PLUGIN_STATUS);){
            Preconditions.checkState((resultSet.next() && "ACTIVE".equals(resultSet.getString("PLUGIN_STATUS")) ? 1 : 0) != 0, (String)"MGR plugin is not active in database `%s`.", (Object)databaseName);
        }
    }

    private void checkSinglePrimaryMode(String databaseName, Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery(QUERY_SINGLE_PRIMARY_MODE);){
            Preconditions.checkState((resultSet.next() && "ON".equals(resultSet.getString("VARIABLE_VALUE")) ? 1 : 0) != 0, (String)"MGR is not in single primary mode in database `%s`.", (Object)databaseName);
        }
    }

    private void checkGroupName(String databaseName, Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery(QUERY_GROUP_NAME);){
            Preconditions.checkState((resultSet.next() && this.props.getProperty("group-name", "").equals(resultSet.getString("VARIABLE_VALUE")) ? 1 : 0) != 0, (String)"Group name in MGR is not same with configured one `%s` in database `%s`.", (Object)this.props.getProperty("group-name"), (Object)databaseName);
        }
    }

    private void checkMemberInstanceURL(String databaseName, String url, Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery(QUERY_MEMBER_LIST);){
            while (resultSet.next()) {
                if (!url.contains(String.join((CharSequence)":", resultSet.getString("MEMBER_HOST"), resultSet.getString("MEMBER_PORT")))) continue;
                return;
            }
        }
        throw new ShardingSphereConfigurationException("`%s` is not in MGR replication group member in database `%s`.", new Object[]{url, databaseName});
    }

    public boolean isPrimaryInstance(DataSource dataSource) throws SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(QUERY_PRIMARY_DATA_SOURCE);){
            if (resultSet.next()) {
                MySQLDataSourceMetaData metaData = new MySQLDataSourceMetaData(connection.getMetaData().getURL());
                boolean bl = metaData.getHostname().equals(resultSet.getString("MEMBER_HOST")) && Integer.toString(metaData.getPort()).equals(resultSet.getString("MEMBER_PORT"));
                return bl;
            }
        }
        return false;
    }

    public ReplicaDataSourceStatus loadReplicaStatus(DataSource replicaDataSource) throws SQLException {
        try (Connection connection = replicaDataSource.getConnection();){
            ReplicaDataSourceStatus replicaDataSourceStatus = new ReplicaDataSourceStatus(this.isOnlineDataSource(connection, new MySQLDataSourceMetaData(connection.getMetaData().getURL())), 0L);
            return replicaDataSourceStatus;
        }
    }

    private boolean isOnlineDataSource(Connection connection, MySQLDataSourceMetaData metaData) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(QUERY_CURRENT_MEMBER_STATE);){
            boolean bl;
            block12: {
                preparedStatement.setString(1, metaData.getHostname());
                preparedStatement.setString(2, Integer.toString(metaData.getPort()));
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    boolean bl2 = bl = resultSet.next() && "ONLINE".equals(resultSet.getString("MEMBER_STATE"));
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
    }

    public String getType() {
        return "MySQL.MGR";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

