/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.encrypt.rewrite.parameter.EncryptParameterRewriter;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.QueryAssistedEncryptAlgorithm;
import org.apache.shardingsphere.infra.binder.segment.insert.values.OnDuplicateUpdateContext;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.GroupedParameterBuilder;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;

public final class EncryptInsertOnDuplicateKeyUpdateValueParameterRewriter
extends EncryptParameterRewriter<InsertStatementContext> {
    @Override
    protected boolean isNeedRewriteForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof InsertStatementContext && InsertStatementHandler.getOnDuplicateKeyColumnsSegment((InsertStatement)((InsertStatement)((InsertStatementContext)sqlStatementContext).getSqlStatement())).isPresent();
    }

    public void rewrite(ParameterBuilder parameterBuilder, InsertStatementContext insertStatementContext, List<Object> parameters) {
        String tableName = ((InsertStatement)insertStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        GroupedParameterBuilder groupedParameterBuilder = (GroupedParameterBuilder)parameterBuilder;
        OnDuplicateUpdateContext onDuplicateKeyUpdateValueContext = insertStatementContext.getOnDuplicateKeyUpdateValueContext();
        int index = 0;
        while (index < onDuplicateKeyUpdateValueContext.getValueExpressions().size()) {
            int columnIndex = index++;
            String encryptLogicColumnName = onDuplicateKeyUpdateValueContext.getColumn(columnIndex).getIdentifier().getValue();
            Optional encryptorOptional = this.getEncryptRule().findEncryptor(tableName, encryptLogicColumnName);
            encryptorOptional.ifPresent(encryptor -> {
                Object plainColumnValue = onDuplicateKeyUpdateValueContext.getValue(columnIndex);
                String cipherColumnValue = ((EncryptAlgorithm)encryptorOptional.get()).encrypt(plainColumnValue);
                groupedParameterBuilder.getGenericParameterBuilder().addReplacedParameters(columnIndex, (Object)cipherColumnValue);
                LinkedList<Object> addedParameters = new LinkedList<Object>();
                if (encryptor instanceof QueryAssistedEncryptAlgorithm) {
                    Optional assistedColumnName = this.getEncryptRule().findAssistedQueryColumn(tableName, encryptLogicColumnName);
                    Preconditions.checkArgument((boolean)assistedColumnName.isPresent(), (Object)"Can not find assisted query Column Name");
                    addedParameters.add(((QueryAssistedEncryptAlgorithm)encryptor).queryAssistedEncrypt(plainColumnValue.toString()));
                }
                if (this.getEncryptRule().findPlainColumn(tableName, encryptLogicColumnName).isPresent()) {
                    addedParameters.add(plainColumnValue);
                }
                if (!addedParameters.isEmpty()) {
                    if (!groupedParameterBuilder.getGenericParameterBuilder().getAddedIndexAndParameters().containsKey(columnIndex + 1)) {
                        groupedParameterBuilder.getGenericParameterBuilder().getAddedIndexAndParameters().put(columnIndex + 1, new LinkedList());
                    }
                    ((Collection)groupedParameterBuilder.getGenericParameterBuilder().getAddedIndexAndParameters().get(columnIndex + 1)).addAll(addedParameters);
                }
            });
        }
    }
}

