/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.insert.keygen.engine;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.insert.keygen.GeneratedKeyContext;
import org.apache.shardingsphere.infra.metadata.model.physical.model.column.PhysicalColumnMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaData;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.InsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml.InsertStatementHandler;

public final class GeneratedKeyContextEngine {
    private final InsertStatement insertStatement;
    private final PhysicalSchemaMetaData schemaMetaData;

    public Optional<GeneratedKeyContext> createGenerateKeyContext(List<String> insertColumnNames, List<List<ExpressionSegment>> valueExpressions, List<Object> parameters) {
        String tableName = this.insertStatement.getTable().getTableName().getIdentifier().getValue();
        return this.findGenerateKeyColumn(tableName).map(generateKeyColumnName -> this.containsGenerateKey(insertColumnNames, (String)generateKeyColumnName) ? this.findGeneratedKey(insertColumnNames, valueExpressions, parameters, (String)generateKeyColumnName) : new GeneratedKeyContext((String)generateKeyColumnName, true));
    }

    private Optional<String> findGenerateKeyColumn(String tableName) {
        if (!this.schemaMetaData.containsTable(tableName)) {
            return Optional.empty();
        }
        for (Map.Entry entry : this.schemaMetaData.get(tableName).getColumns().entrySet()) {
            if (!((PhysicalColumnMetaData)entry.getValue()).isGenerated()) continue;
            return Optional.of(entry.getKey());
        }
        return Optional.empty();
    }

    private boolean containsGenerateKey(List<String> insertColumnNames, String generateKeyColumnName) {
        return insertColumnNames.isEmpty() ? this.schemaMetaData.getAllColumnNames(this.insertStatement.getTable().getTableName().getIdentifier().getValue()).size() == this.getValueCountForPerGroup() : insertColumnNames.contains(generateKeyColumnName);
    }

    private int getValueCountForPerGroup() {
        if (!this.insertStatement.getValues().isEmpty()) {
            return ((InsertValuesSegment)this.insertStatement.getValues().iterator().next()).getValues().size();
        }
        Optional setAssignment = InsertStatementHandler.getSetAssignmentSegment((InsertStatement)this.insertStatement);
        if (setAssignment.isPresent()) {
            return ((SetAssignmentSegment)setAssignment.get()).getAssignments().size();
        }
        if (this.insertStatement.getInsertSelect().isPresent()) {
            return ((SubquerySegment)this.insertStatement.getInsertSelect().get()).getSelect().getProjections().getProjections().size();
        }
        return 0;
    }

    private GeneratedKeyContext findGeneratedKey(List<String> insertColumnNames, List<List<ExpressionSegment>> valueExpressions, List<Object> parameters, String generateKeyColumnName) {
        GeneratedKeyContext result = new GeneratedKeyContext(generateKeyColumnName, false);
        for (ExpressionSegment each : this.findGenerateKeyExpressions(insertColumnNames, valueExpressions, generateKeyColumnName)) {
            if (each instanceof ParameterMarkerExpressionSegment) {
                result.getGeneratedValues().add((Comparable)parameters.get(((ParameterMarkerExpressionSegment)each).getParameterMarkerIndex()));
                continue;
            }
            if (!(each instanceof LiteralExpressionSegment)) continue;
            result.getGeneratedValues().add((Comparable)((LiteralExpressionSegment)each).getLiterals());
        }
        return result;
    }

    private Collection<ExpressionSegment> findGenerateKeyExpressions(List<String> insertColumnNames, List<List<ExpressionSegment>> valueExpressions, String generateKeyColumnName) {
        LinkedList<ExpressionSegment> result = new LinkedList<ExpressionSegment>();
        for (List<ExpressionSegment> each : valueExpressions) {
            result.add(each.get(this.findGenerateKeyIndex(insertColumnNames, generateKeyColumnName.toLowerCase())));
        }
        return result;
    }

    private int findGenerateKeyIndex(List<String> insertColumnNames, String generateKeyColumnName) {
        return insertColumnNames.isEmpty() ? this.schemaMetaData.getAllColumnNames(this.insertStatement.getTable().getTableName().getIdentifier().getValue()).indexOf(generateKeyColumnName) : insertColumnNames.indexOf(generateKeyColumnName);
    }

    @Generated
    public GeneratedKeyContextEngine(InsertStatement insertStatement, PhysicalSchemaMetaData schemaMetaData) {
        this.insertStatement = insertStatement;
        this.schemaMetaData = schemaMetaData;
    }
}

