/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.select.projection.engine;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.shardingsphere.infra.binder.segment.select.groupby.GroupByContext;
import org.apache.shardingsphere.infra.binder.segment.select.orderby.OrderByContext;
import org.apache.shardingsphere.infra.binder.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.segment.select.projection.DerivedColumn;
import org.apache.shardingsphere.infra.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.infra.binder.segment.select.projection.engine.ProjectionEngine;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.DerivedProjection;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ShorthandProjection;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaData;
import org.apache.shardingsphere.sql.parser.sql.common.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.TextOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;

public final class ProjectionsContextEngine {
    private final PhysicalSchemaMetaData schemaMetaData;
    private final ProjectionEngine projectionEngine;

    public ProjectionsContextEngine(PhysicalSchemaMetaData schemaMetaData) {
        this.schemaMetaData = schemaMetaData;
        this.projectionEngine = new ProjectionEngine(schemaMetaData);
    }

    public ProjectionsContext createProjectionsContext(Collection<SimpleTableSegment> tables, ProjectionsSegment projectionsSegment, GroupByContext groupByContext, OrderByContext orderByContext) {
        Collection<Projection> projections = this.getProjections(tables, projectionsSegment);
        ProjectionsContext result = new ProjectionsContext(projectionsSegment.getStartIndex(), projectionsSegment.getStopIndex(), projectionsSegment.isDistinctRow(), projections);
        result.getProjections().addAll(this.getDerivedGroupByColumns(projections, groupByContext, tables));
        result.getProjections().addAll(this.getDerivedOrderByColumns(projections, orderByContext, tables));
        return result;
    }

    private Collection<Projection> getProjections(Collection<SimpleTableSegment> tableSegments, ProjectionsSegment projectionsSegment) {
        LinkedList<Projection> result = new LinkedList<Projection>();
        for (ProjectionSegment each : projectionsSegment.getProjections()) {
            this.projectionEngine.createProjection(tableSegments, each).ifPresent(result::add);
        }
        return result;
    }

    private Collection<Projection> getDerivedGroupByColumns(Collection<Projection> projections, GroupByContext groupByContext, Collection<SimpleTableSegment> tables) {
        return this.getDerivedOrderColumns(projections, groupByContext.getItems(), DerivedColumn.GROUP_BY_ALIAS, tables);
    }

    private Collection<Projection> getDerivedOrderByColumns(Collection<Projection> projections, OrderByContext orderByContext, Collection<SimpleTableSegment> tables) {
        return this.getDerivedOrderColumns(projections, orderByContext.getItems(), DerivedColumn.ORDER_BY_ALIAS, tables);
    }

    private Collection<Projection> getDerivedOrderColumns(Collection<Projection> projections, Collection<OrderByItem> orderItems, DerivedColumn derivedColumn, Collection<SimpleTableSegment> tables) {
        LinkedList<Projection> result = new LinkedList<Projection>();
        int derivedColumnOffset = 0;
        for (OrderByItem each : orderItems) {
            if (this.containsProjection(projections, each.getSegment(), tables)) continue;
            result.add(new DerivedProjection(((TextOrderByItemSegment)each.getSegment()).getText(), derivedColumn.getDerivedColumnAlias(derivedColumnOffset++), (SQLSegment)each.getSegment()));
        }
        return result;
    }

    private boolean containsProjection(Collection<Projection> projections, OrderByItemSegment orderByItemSegment, Collection<SimpleTableSegment> tables) {
        return orderByItemSegment instanceof IndexOrderByItemSegment || this.containsItemInShorthandProjection(projections, orderByItemSegment, tables) || this.containsProjection(projections, orderByItemSegment);
    }

    private boolean containsProjection(Collection<Projection> projections, OrderByItemSegment orderItem) {
        for (Projection each : projections) {
            if (orderItem instanceof IndexOrderByItemSegment) {
                return true;
            }
            if (!this.isSameAlias(each, (TextOrderByItemSegment)orderItem) && !this.isSameQualifiedName(each, (TextOrderByItemSegment)orderItem)) continue;
            return true;
        }
        return false;
    }

    private boolean containsItemInShorthandProjection(Collection<Projection> projections, OrderByItemSegment orderByItemSegment, Collection<SimpleTableSegment> tables) {
        return this.isUnqualifiedShorthandProjection(projections) || this.containsItemWithOwnerInShorthandProjections(projections, orderByItemSegment, tables) || this.containsItemWithoutOwnerInShorthandProjections(projections, orderByItemSegment, tables);
    }

    private boolean isUnqualifiedShorthandProjection(Collection<Projection> projections) {
        if (1 != projections.size()) {
            return false;
        }
        Projection projection = projections.iterator().next();
        return projection instanceof ShorthandProjection && !((ShorthandProjection)projection).getOwner().isPresent();
    }

    private boolean containsItemWithOwnerInShorthandProjections(Collection<Projection> projections, OrderByItemSegment orderItem, Collection<SimpleTableSegment> tables) {
        return orderItem instanceof ColumnOrderByItemSegment && ((ColumnOrderByItemSegment)orderItem).getColumn().getOwner().isPresent() && this.findShorthandProjection(projections, ((OwnerSegment)((ColumnOrderByItemSegment)orderItem).getColumn().getOwner().get()).getIdentifier().getValue(), tables).isPresent();
    }

    private Optional<ShorthandProjection> findShorthandProjection(Collection<Projection> projections, String tableNameOrAlias, Collection<SimpleTableSegment> tables) {
        SimpleTableSegment tableSegment = this.find(tableNameOrAlias, tables);
        for (Projection each : projections) {
            ShorthandProjection shorthandProjection;
            if (!(each instanceof ShorthandProjection) || !(shorthandProjection = (ShorthandProjection)each).getOwner().isPresent() || !this.find(shorthandProjection.getOwner().get(), tables).getTableName().getIdentifier().getValue().equalsIgnoreCase(tableSegment.getTableName().getIdentifier().getValue())) continue;
            return Optional.of(shorthandProjection);
        }
        return Optional.empty();
    }

    private boolean containsItemWithoutOwnerInShorthandProjections(Collection<Projection> projections, OrderByItemSegment orderItem, Collection<SimpleTableSegment> tables) {
        if (!(orderItem instanceof ColumnOrderByItemSegment)) {
            return false;
        }
        if (!((ColumnOrderByItemSegment)orderItem).getColumn().getOwner().isPresent()) {
            for (ShorthandProjection each : this.getQualifiedShorthandProjections(projections)) {
                if (!this.isSameProjection(each, (ColumnOrderByItemSegment)orderItem, tables)) continue;
                return true;
            }
        }
        return false;
    }

    private Collection<ShorthandProjection> getQualifiedShorthandProjections(Collection<Projection> projections) {
        LinkedList<ShorthandProjection> result = new LinkedList<ShorthandProjection>();
        for (Projection each : projections) {
            if (!(each instanceof ShorthandProjection) || !((ShorthandProjection)each).getOwner().isPresent()) continue;
            result.add((ShorthandProjection)each);
        }
        return result;
    }

    private boolean isSameProjection(ShorthandProjection shorthandProjection, ColumnOrderByItemSegment orderItem, Collection<SimpleTableSegment> tables) {
        Preconditions.checkState((boolean)shorthandProjection.getOwner().isPresent());
        SimpleTableSegment tableSegment = this.find(shorthandProjection.getOwner().get(), tables);
        return this.schemaMetaData.containsColumn(tableSegment.getTableName().getIdentifier().getValue(), orderItem.getColumn().getIdentifier().getValue());
    }

    private boolean isSameAlias(Projection projection, TextOrderByItemSegment orderItem) {
        return projection.getAlias().isPresent() && (SQLUtil.getExactlyValue((String)orderItem.getText()).equalsIgnoreCase(projection.getAlias().get()) || orderItem.getText().equalsIgnoreCase(projection.getExpression()));
    }

    private boolean isSameQualifiedName(Projection projection, TextOrderByItemSegment orderItem) {
        return !projection.getAlias().isPresent() && projection.getExpression().equalsIgnoreCase(orderItem.getText());
    }

    private SimpleTableSegment find(String tableNameOrAlias, Collection<SimpleTableSegment> tables) {
        for (SimpleTableSegment each : tables) {
            if (!tableNameOrAlias.equalsIgnoreCase(each.getTableName().getIdentifier().getValue()) && !tableNameOrAlias.equals(each.getAlias().orElse(null))) continue;
            return each;
        }
        throw new IllegalStateException("Can not find owner from table.");
    }
}

