/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement.ddl;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.IndexAvailable;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.AlterIndexStatementHandler;

public final class AlterIndexStatementContext
extends CommonSQLStatementContext<AlterIndexStatement>
implements TableAvailable,
IndexAvailable {
    private final TablesContext tablesContext;

    public AlterIndexStatementContext(AlterIndexStatement sqlStatement) {
        super(sqlStatement);
        SimpleTableSegment simpleTableSegment = AlterIndexStatementHandler.getSimpleTableSegment((AlterIndexStatement)sqlStatement).orElse(null);
        this.tablesContext = new TablesContext(simpleTableSegment);
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        Optional simpleTableSegment = AlterIndexStatementHandler.getSimpleTableSegment((AlterIndexStatement)((AlterIndexStatement)this.getSqlStatement()));
        return simpleTableSegment.isPresent() ? Collections.singletonList(simpleTableSegment.get()) : Collections.emptyList();
    }

    @Override
    public Collection<IndexSegment> getIndexes() {
        return ((AlterIndexStatement)this.getSqlStatement()).getIndex().isPresent() ? Collections.singletonList(((AlterIndexStatement)this.getSqlStatement()).getIndex().get()) : Collections.emptyList();
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

