/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.statement.ddl;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.type.IndexAvailable;
import org.apache.shardingsphere.infra.binder.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateTableStatement;

public final class CreateTableStatementContext
extends CommonSQLStatementContext<CreateTableStatement>
implements TableAvailable,
IndexAvailable {
    private final TablesContext tablesContext;

    public CreateTableStatementContext(CreateTableStatement sqlStatement) {
        super(sqlStatement);
        this.tablesContext = new TablesContext(sqlStatement.getTable());
    }

    @Override
    public Collection<SimpleTableSegment> getAllTables() {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        result.add(((CreateTableStatement)this.getSqlStatement()).getTable());
        for (ColumnDefinitionSegment each : ((CreateTableStatement)this.getSqlStatement()).getColumnDefinitions()) {
            result.addAll(each.getReferencedTables());
        }
        for (ColumnDefinitionSegment each : ((CreateTableStatement)this.getSqlStatement()).getConstraintDefinitions()) {
            if (!each.getReferencedTable().isPresent()) continue;
            result.add((SimpleTableSegment)each.getReferencedTable().get());
        }
        return result;
    }

    @Override
    public Collection<IndexSegment> getIndexes() {
        LinkedList<IndexSegment> result = new LinkedList<IndexSegment>();
        Collection constraintDefinitions = ((CreateTableStatement)this.getSqlStatement()).getConstraintDefinitions();
        for (ConstraintDefinitionSegment each : constraintDefinitions) {
            if (null == each.getIndexName()) continue;
            result.add(each.getIndexName());
        }
        return result;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

