/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.model.addressing;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.model.addressing.TableAddressingMetaData;
import org.apache.shardingsphere.infra.metadata.model.addressing.TableAddressingMetaDataDecorator;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaDataLoader;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.ordered.OrderedSPIRegistry;

public final class TableAddressingMetaDataLoader {
    public static TableAddressingMetaData load(DatabaseType databaseType, Map<String, DataSource> dataSourceMap, Collection<ShardingSphereRule> rules) throws SQLException {
        TableAddressingMetaData result = TableAddressingMetaDataLoader.initializeMetaData(databaseType, dataSourceMap);
        for (Map.Entry<ShardingSphereRule, TableAddressingMetaDataDecorator> entry : OrderedSPIRegistry.getRegisteredServices(rules, TableAddressingMetaDataDecorator.class).entrySet()) {
            entry.getValue().decorate(entry.getKey(), result);
        }
        return result;
    }

    private static TableAddressingMetaData initializeMetaData(DatabaseType databaseType, Map<String, DataSource> dataSourceMap) throws SQLException {
        TableAddressingMetaData result = new TableAddressingMetaData();
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            TableAddressingMetaDataLoader.appendMetaData(result, databaseType, entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static void appendMetaData(TableAddressingMetaData metaData, DatabaseType databaseType, String dataSourceName, DataSource dataSource) throws SQLException {
        for (String each : PhysicalSchemaMetaDataLoader.loadTableNames(dataSource, databaseType, Collections.emptyList())) {
            if (!metaData.getTableDataSourceNamesMapper().containsKey(each)) {
                metaData.getTableDataSourceNamesMapper().put(each, new LinkedHashSet());
            }
            metaData.getTableDataSourceNamesMapper().get(each).add(dataSourceName);
        }
    }

    @Generated
    private TableAddressingMetaDataLoader() {
    }

    static {
        ShardingSphereServiceLoader.register(TableAddressingMetaDataDecorator.class);
    }
}

