/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.model.logic;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.properties.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.datanode.DataNodes;
import org.apache.shardingsphere.infra.metadata.model.logic.LogicSchemaMetaData;
import org.apache.shardingsphere.infra.metadata.model.logic.spi.LogicMetaDataDecorator;
import org.apache.shardingsphere.infra.metadata.model.logic.spi.LogicMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaData;
import org.apache.shardingsphere.infra.metadata.model.physical.model.schema.PhysicalSchemaMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.model.physical.model.table.PhysicalTableMetaData;
import org.apache.shardingsphere.infra.rule.DataNodeRoutedRule;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.ordered.OrderedSPIRegistry;

public final class LogicSchemaMetaDataLoader {
    private final Collection<ShardingSphereRule> rules;

    public LogicSchemaMetaData load(DatabaseType databaseType, Map<String, DataSource> dataSourceMap, ConfigurationProperties props) throws SQLException {
        TreeSet<String> excludedTableNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        PhysicalSchemaMetaData configuredSchemaMetaData = new PhysicalSchemaMetaData();
        for (Map.Entry<ShardingSphereRule, LogicMetaDataLoader> entry : OrderedSPIRegistry.getRegisteredServices(this.rules, LogicMetaDataLoader.class).entrySet()) {
            PhysicalSchemaMetaData schemaMetaData = entry.getValue().load(databaseType, dataSourceMap, new DataNodes(this.rules), entry.getKey(), props, excludedTableNames);
            excludedTableNames.addAll(schemaMetaData.getAllTableNames());
            if (entry.getKey() instanceof DataNodeRoutedRule) {
                excludedTableNames.addAll(((DataNodeRoutedRule)entry.getKey()).getAllActualTables());
            }
            configuredSchemaMetaData.merge(schemaMetaData);
        }
        this.decorate(configuredSchemaMetaData);
        Map<String, Collection<String>> unConfiguredSchemaMetaDataMap = this.loadUnConfiguredSchemaMetaData(databaseType, dataSourceMap, excludedTableNames);
        return new LogicSchemaMetaData(configuredSchemaMetaData, unConfiguredSchemaMetaDataMap);
    }

    public LogicSchemaMetaData load(DatabaseType databaseType, DataSource dataSource, ConfigurationProperties props) throws SQLException {
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>(1, 1.0f);
        dataSourceMap.put("logic_db", dataSource);
        return this.load(databaseType, dataSourceMap, props);
    }

    public Optional<PhysicalTableMetaData> load(DatabaseType databaseType, Map<String, DataSource> dataSourceMap, String tableName, ConfigurationProperties props) throws SQLException {
        for (Map.Entry<ShardingSphereRule, LogicMetaDataLoader> entry : OrderedSPIRegistry.getRegisteredServices(this.rules, LogicMetaDataLoader.class).entrySet()) {
            Optional<PhysicalTableMetaData> result = entry.getValue().load(databaseType, dataSourceMap, new DataNodes(this.rules), tableName, entry.getKey(), props);
            if (!result.isPresent()) continue;
            return Optional.of(this.decorate(tableName, result.get()));
        }
        return Optional.empty();
    }

    public Optional<PhysicalTableMetaData> load(DatabaseType databaseType, DataSource dataSource, String tableName, ConfigurationProperties props) throws SQLException {
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>(1, 1.0f);
        dataSourceMap.put("logic_db", dataSource);
        return this.load(databaseType, dataSourceMap, tableName, props);
    }

    private Map<String, Collection<String>> loadUnConfiguredSchemaMetaData(DatabaseType databaseType, Map<String, DataSource> dataSourceMap, Collection<String> excludedTableNames) throws SQLException {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>(dataSourceMap.size(), 1.0f);
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            Collection<String> tableNames = PhysicalSchemaMetaDataLoader.loadTableNames(entry.getValue(), databaseType, excludedTableNames);
            if (tableNames.isEmpty()) continue;
            result.put(entry.getKey(), tableNames);
        }
        return result;
    }

    private void decorate(PhysicalSchemaMetaData schemaMetaData) {
        HashMap<String, PhysicalTableMetaData> tableMetaDataMap = new HashMap<String, PhysicalTableMetaData>(schemaMetaData.getAllTableNames().size(), 1.0f);
        Map<ShardingSphereRule, LogicMetaDataDecorator> decorators = OrderedSPIRegistry.getRegisteredServices(this.rules, LogicMetaDataDecorator.class);
        for (String each : schemaMetaData.getAllTableNames()) {
            for (Map.Entry<ShardingSphereRule, LogicMetaDataDecorator> entry : decorators.entrySet()) {
                tableMetaDataMap.put(each, entry.getValue().decorate(each, tableMetaDataMap.getOrDefault(each, schemaMetaData.get(each)), entry.getKey()));
            }
        }
        schemaMetaData.merge(new PhysicalSchemaMetaData(tableMetaDataMap));
    }

    private PhysicalTableMetaData decorate(String tableName, PhysicalTableMetaData tableMetaData) {
        Map<ShardingSphereRule, LogicMetaDataDecorator> decorators = OrderedSPIRegistry.getRegisteredServices(this.rules, LogicMetaDataDecorator.class);
        PhysicalTableMetaData result = null;
        for (Map.Entry<ShardingSphereRule, LogicMetaDataDecorator> entry : decorators.entrySet()) {
            result = entry.getValue().decorate(tableName, null == result ? tableMetaData : result, entry.getKey());
        }
        return Optional.ofNullable(result).orElse(tableMetaData);
    }

    @Generated
    public LogicSchemaMetaDataLoader(Collection<ShardingSphereRule> rules) {
        this.rules = rules;
    }

    static {
        ShardingSphereServiceLoader.register(LogicMetaDataLoader.class);
        ShardingSphereServiceLoader.register(LogicMetaDataDecorator.class);
    }
}

