/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.spi.exception.ServiceLoaderInstantiationException;

public final class ShardingSphereServiceLoader {
    private static final Map<Class<?>, Collection<Class<?>>> SERVICES = new ConcurrentHashMap();

    public static <T> void register(Class<T> service) {
        if (SERVICES.containsKey(service)) {
            return;
        }
        for (T each : ServiceLoader.load(service)) {
            ShardingSphereServiceLoader.registerServiceClass(service, each);
        }
    }

    private static <T> void registerServiceClass(Class<T> service, T instance) {
        Collection serviceClasses = SERVICES.computeIfAbsent(service, unused -> new LinkedHashSet());
        serviceClasses.add(instance.getClass());
    }

    public static <T> Collection<T> newServiceInstances(Class<T> service) {
        return SERVICES.containsKey(service) ? (Collection)SERVICES.get(service).stream().map(each -> ShardingSphereServiceLoader.newServiceInstance(each)).collect(Collectors.toList()) : Collections.emptyList();
    }

    private static Object newServiceInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new ServiceLoaderInstantiationException(clazz, ex);
        }
    }

    @Generated
    private ShardingSphereServiceLoader() {
    }
}

