/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.yaml.swapper;

import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.ordered.OrderedSPIRegistry;
import org.apache.shardingsphere.infra.yaml.config.YamlRuleConfiguration;
import org.apache.shardingsphere.infra.yaml.swapper.YamlRuleConfigurationSwapper;

public final class YamlRuleConfigurationSwapperEngine {
    public Collection<YamlRuleConfiguration> swapToYamlConfigurations(Collection<RuleConfiguration> ruleConfigurations) {
        LinkedList<YamlRuleConfiguration> result = new LinkedList<YamlRuleConfiguration>();
        for (Map.Entry<RuleConfiguration, YamlRuleConfigurationSwapper> entry : OrderedSPIRegistry.getRegisteredServices(ruleConfigurations, YamlRuleConfigurationSwapper.class).entrySet()) {
            result.add((YamlRuleConfiguration)entry.getValue().swapToYamlConfiguration(entry.getKey()));
        }
        return result;
    }

    public Collection<RuleConfiguration> swapToRuleConfigurations(Collection<YamlRuleConfiguration> yamlRuleConfigs) {
        LinkedList<RuleConfiguration> result = new LinkedList<RuleConfiguration>();
        Collection ruleConfigurationTypes = yamlRuleConfigs.stream().map(YamlRuleConfiguration::getRuleConfigurationType).collect(Collectors.toList());
        for (Map.Entry<Class<?>, YamlRuleConfigurationSwapper> entry : OrderedSPIRegistry.getRegisteredServicesByClass(ruleConfigurationTypes, YamlRuleConfigurationSwapper.class).entrySet()) {
            result.addAll(this.swapToRuleConfigurations(yamlRuleConfigs, entry.getKey(), entry.getValue()));
        }
        return result;
    }

    private Collection<RuleConfiguration> swapToRuleConfigurations(Collection<YamlRuleConfiguration> yamlRuleConfigurations, Class<?> ruleConfigurationType, YamlRuleConfigurationSwapper swapper) {
        LinkedList<RuleConfiguration> result = new LinkedList<RuleConfiguration>();
        for (YamlRuleConfiguration each : yamlRuleConfigurations) {
            if (!each.getRuleConfigurationType().equals(ruleConfigurationType)) continue;
            result.add((RuleConfiguration)swapper.swapToObject(each));
        }
        return result;
    }

    public static Map<String, Class<?>> getYamlShortcuts() {
        HashMap result = new HashMap();
        for (YamlRuleConfigurationSwapper each : ShardingSphereServiceLoader.newServiceInstances(YamlRuleConfigurationSwapper.class)) {
            Class<?> yamlRuleConfigurationClass = Class.forName(((ParameterizedType)each.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0].getTypeName());
            result.put("!" + each.getRuleTagName(), yamlRuleConfigurationClass);
        }
        return result;
    }

    static {
        ShardingSphereServiceLoader.register(YamlRuleConfigurationSwapper.class);
    }
}

