/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;

public final class ShardingSphereSchema {
    private final Map<String, TableMetaData> tables;

    public ShardingSphereSchema() {
        this.tables = new ConcurrentHashMap<String, TableMetaData>();
    }

    public ShardingSphereSchema(Map<String, TableMetaData> tables) {
        this.tables = new ConcurrentHashMap<String, TableMetaData>(tables.size(), 1.0f);
        tables.forEach((key, value) -> this.tables.put(key.toLowerCase(), (TableMetaData)value));
    }

    public Collection<String> getAllTableNames() {
        return this.tables.keySet();
    }

    public TableMetaData get(String tableName) {
        return this.tables.get(tableName.toLowerCase());
    }

    public void put(String tableName, TableMetaData tableMetaData) {
        this.tables.put(tableName.toLowerCase(), tableMetaData);
    }

    public void putAll(Map<String, TableMetaData> tableMetaDataMap) {
        for (Map.Entry<String, TableMetaData> entry : tableMetaDataMap.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void remove(String tableName) {
        this.tables.remove(tableName.toLowerCase());
    }

    public boolean containsTable(String tableName) {
        return this.tables.containsKey(tableName.toLowerCase());
    }

    public boolean containsColumn(String tableName, String columnName) {
        return this.containsTable(tableName) && this.get(tableName).getColumns().containsKey(columnName.toLowerCase());
    }

    public List<String> getAllColumnNames(String tableName) {
        return this.containsTable(tableName) ? new ArrayList<String>(this.get(tableName).getColumns().keySet()) : Collections.emptyList();
    }
}

