/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.builder.loader;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.schema.model.ColumnMetaData;

public final class ColumnMetaDataLoader {
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String TABLE_NAME = "TABLE_NAME";

    public static Collection<ColumnMetaData> load(Connection connection, String tableNamePattern, DatabaseType databaseType) throws SQLException {
        LinkedList<ColumnMetaData> result = new LinkedList<ColumnMetaData>();
        Collection<String> primaryKeys = ColumnMetaDataLoader.loadPrimaryKeys(connection, tableNamePattern);
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<Integer> columnTypes = new ArrayList<Integer>();
        ArrayList<String> columnTypeNames = new ArrayList<String>();
        ArrayList<Boolean> isPrimaryKeys = new ArrayList<Boolean>();
        ArrayList<Boolean> isCaseSensitives = new ArrayList<Boolean>();
        try (ResultSet resultSet = connection.getMetaData().getColumns(connection.getCatalog(), connection.getSchema(), tableNamePattern, "%");){
            while (resultSet.next()) {
                String tableName = resultSet.getString(TABLE_NAME);
                if (!Objects.equals(tableNamePattern, tableName)) continue;
                String columnName = resultSet.getString(COLUMN_NAME);
                columnTypes.add(resultSet.getInt(DATA_TYPE));
                columnTypeNames.add(resultSet.getString(TYPE_NAME));
                isPrimaryKeys.add(primaryKeys.contains(columnName));
                columnNames.add(columnName);
            }
        }
        var11_12 = null;
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(ColumnMetaDataLoader.generateEmptyResultSQL(tableNamePattern, databaseType));){
            for (String each : columnNames) {
                isCaseSensitives.add(resultSet.getMetaData().isCaseSensitive(resultSet.findColumn(each)));
            }
        }
        catch (Throwable throwable) {
            var11_12 = throwable;
            throw throwable;
        }
        for (int i = 0; i < columnNames.size(); ++i) {
            result.add(new ColumnMetaData((String)columnNames.get(i), (Integer)columnTypes.get(i), (Boolean)isPrimaryKeys.get(i), false, (Boolean)isCaseSensitives.get(i)));
        }
        return result;
    }

    private static String generateEmptyResultSQL(String table, DatabaseType databaseType) {
        return String.format("SELECT * FROM %s WHERE 1 != 1", databaseType.getQuoteCharacter().wrap(table));
    }

    private static Collection<String> loadPrimaryKeys(Connection connection, String table) throws SQLException {
        HashSet<String> result = new HashSet<String>();
        try (ResultSet resultSet = connection.getMetaData().getPrimaryKeys(connection.getCatalog(), connection.getSchema(), table);){
            while (resultSet.next()) {
                result.add(resultSet.getString(COLUMN_NAME));
            }
        }
        return result;
    }

    @Generated
    private ColumnMetaDataLoader() {
    }
}

