/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.builder.loader;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.schema.builder.loader.ColumnMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.schema.builder.loader.IndexMetaDataLoader;
import org.apache.shardingsphere.infra.metadata.schema.builder.loader.adapter.MetaDataLoaderConnectionAdapter;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;

public final class TableMetaDataLoader {
    public static Optional<TableMetaData> load(DataSource dataSource, String tableNamePattern, DatabaseType databaseType) throws SQLException {
        try (MetaDataLoaderConnectionAdapter connectionAdapter = new MetaDataLoaderConnectionAdapter(databaseType, dataSource.getConnection());){
            String formattedTableNamePattern = databaseType.formatTableNamePattern(tableNamePattern);
            Optional<TableMetaData> optional = TableMetaDataLoader.isTableExist(connectionAdapter, formattedTableNamePattern) ? Optional.of(new TableMetaData(ColumnMetaDataLoader.load(connectionAdapter, formattedTableNamePattern, databaseType), IndexMetaDataLoader.load(connectionAdapter, formattedTableNamePattern))) : Optional.empty();
            return optional;
        }
    }

    private static boolean isTableExist(Connection connection, String tableNamePattern) throws SQLException {
        try (ResultSet resultSet = connection.getMetaData().getTables(connection.getCatalog(), connection.getSchema(), tableNamePattern, null);){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    @Generated
    private TableMetaDataLoader() {
    }
}

