/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.schema.refresher.type;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.builder.SchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.schema.model.TableMetaData;
import org.apache.shardingsphere.infra.metadata.schema.refresher.SchemaRefresher;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.ddl.DropIndexStatementHandler;

public final class DropIndexStatementSchemaRefresher
implements SchemaRefresher<DropIndexStatement> {
    @Override
    public void refresh(ShardingSphereSchema schema, Collection<String> routeDataSourceNames, DropIndexStatement sqlStatement, SchemaBuilderMaterials materials) {
        Collection<String> indexNames = this.getIndexNames(sqlStatement);
        Optional simpleTableSegment = DropIndexStatementHandler.getSimpleTableSegment((DropIndexStatement)sqlStatement);
        String tableName = simpleTableSegment.map(tableSegment -> tableSegment.getTableName().getIdentifier().getValue()).orElse("");
        TableMetaData tableMetaData = schema.get(tableName);
        if (!Strings.isNullOrEmpty((String)tableName)) {
            for (String each : indexNames) {
                tableMetaData.getIndexes().remove(each);
            }
            return;
        }
        for (String each : indexNames) {
            Optional<String> logicTableNameOptional = this.findLogicTableName(schema, each);
            if (!logicTableNameOptional.isPresent()) continue;
            String logicTableName = logicTableNameOptional.orElse("");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)logicTableName) ? 1 : 0) != 0, (Object)"Cannot get the table name!");
            if (null == tableMetaData) {
                tableMetaData = schema.get(logicTableName);
            }
            Preconditions.checkNotNull((Object)tableMetaData, (Object)"Cannot get the table metadata!");
            tableMetaData.getIndexes().remove(each);
        }
    }

    private Collection<String> getIndexNames(DropIndexStatement dropIndexStatement) {
        return dropIndexStatement.getIndexes().stream().map(each -> each.getIdentifier().getValue()).collect(Collectors.toCollection(LinkedList::new));
    }

    private Optional<String> findLogicTableName(ShardingSphereSchema schema, String logicIndexName) {
        return schema.getAllTableNames().stream().filter(each -> schema.get((String)each).getIndexes().containsKey(logicIndexName)).findFirst();
    }
}

