/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.yaml.engine.constructor;

import java.util.HashMap;
import java.util.Map;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.yaml.engine.constructor.ShardingSphereYamlConstruct;
import org.apache.shardingsphere.infra.yaml.swapper.YamlRuleConfigurationSwapperEngine;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.nodes.Node;

public class ShardingSphereYamlConstructor
extends Constructor {
    private final Map<Class<?>, Construct> typeConstructs = new HashMap();
    private final Class<?> rootClass;

    public ShardingSphereYamlConstructor(Class<?> rootClass) {
        super(rootClass);
        ShardingSphereServiceLoader.getSingletonServiceInstances(ShardingSphereYamlConstruct.class).forEach(each -> this.typeConstructs.put(each.getType(), (Construct)each));
        YamlRuleConfigurationSwapperEngine.getYamlShortcuts().forEach((key, value) -> this.addTypeDescription(new TypeDescription(value, key)));
        this.rootClass = rootClass;
    }

    protected final Construct getConstructor(Node node) {
        return this.typeConstructs.getOrDefault(node.getType(), super.getConstructor(node));
    }

    protected Class<?> getClassForName(String className) throws ClassNotFoundException {
        if (className.equals(this.rootClass.getName())) {
            return super.getClassForName(className);
        }
        throw new IllegalArgumentException(String.format("Class is not accepted: %s", className));
    }

    static {
        ShardingSphereServiceLoader.register(ShardingSphereYamlConstruct.class);
    }
}

