/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.instance.definition;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.definition.InstanceType;
import org.apache.shardingsphere.infra.instance.utils.IpUtils;

public final class InstanceDefinition {
    private static final String DELIMITER = "@";
    private static final AtomicLong ATOMIC_LONG = new AtomicLong();
    private final InstanceType instanceType;
    private final String instanceId;
    private String ip;
    private String uniqueSign;

    public InstanceDefinition(InstanceType instanceType) {
        this.instanceType = instanceType;
        this.instanceId = new UUID(ThreadLocalRandom.current().nextLong(), ThreadLocalRandom.current().nextLong()).toString();
        this.ip = IpUtils.getIp();
        this.uniqueSign = String.join((CharSequence)"", ManagementFactory.getRuntimeMXBean().getName().split(DELIMITER)[0], String.valueOf(ATOMIC_LONG.incrementAndGet()));
    }

    public InstanceDefinition(InstanceType instanceType, Integer port) {
        this.instanceType = instanceType;
        this.instanceId = new UUID(ThreadLocalRandom.current().nextLong(), ThreadLocalRandom.current().nextLong()).toString();
        this.ip = IpUtils.getIp();
        this.uniqueSign = String.valueOf(port);
    }

    public InstanceDefinition(InstanceType instanceType, String instanceId, String attributes) {
        this.instanceType = instanceType;
        this.instanceId = instanceId;
        List attributesList = Splitter.on((String)DELIMITER).splitToList((CharSequence)attributes);
        this.ip = (String)attributesList.get(0);
        this.uniqueSign = (String)attributesList.get(1);
    }

    public InstanceDefinition(InstanceType instanceType, String instanceId) {
        this.instanceType = instanceType;
        this.instanceId = instanceId;
    }

    public String getAttributes() {
        return Joiner.on((String)DELIMITER).join((Object)this.ip, (Object)this.uniqueSign, new Object[0]);
    }

    public void setAttributes(String attributes) {
        if (!Strings.isNullOrEmpty((String)attributes) && attributes.contains(DELIMITER)) {
            List attributesList = Splitter.on((String)DELIMITER).splitToList((CharSequence)attributes);
            this.ip = (String)attributesList.get(0);
            this.uniqueSign = (String)attributesList.get(1);
        }
    }

    @Generated
    public InstanceType getInstanceType() {
        return this.instanceType;
    }

    @Generated
    public String getInstanceId() {
        return this.instanceId;
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getUniqueSign() {
        return this.uniqueSign;
    }
}

