/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.database.impl.DataSourceProvidedDatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.resource.ShardingSphereResource;
import org.apache.shardingsphere.infra.metadata.database.rule.ShardingSphereRuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterials;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.SystemSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.schema.DatabaseRulesBuilder;

public final class ShardingSphereDatabase {
    private final String name;
    private final DatabaseType protocolType;
    private final ShardingSphereResource resource;
    private final ShardingSphereRuleMetaData ruleMetaData;
    private final Map<String, ShardingSphereSchema> schemas;

    public static ShardingSphereDatabase create(String name, DatabaseType protocolType, DatabaseType storageType, DatabaseConfiguration databaseConfig, ConfigurationProperties props) throws SQLException {
        Collection<ShardingSphereRule> databaseRules = DatabaseRulesBuilder.build(name, databaseConfig, props);
        ConcurrentHashMap<String, ShardingSphereSchema> schemas = new ConcurrentHashMap<String, ShardingSphereSchema>();
        schemas.putAll(GenericSchemaBuilder.build(new GenericSchemaBuilderMaterials(protocolType, storageType, databaseConfig.getDataSources(), databaseRules, props, name)));
        schemas.putAll(SystemSchemaBuilder.build(name, protocolType));
        return ShardingSphereDatabase.create(name, protocolType, databaseConfig, databaseRules, schemas);
    }

    public static ShardingSphereDatabase create(String name, DatabaseType protocolType) throws SQLException {
        DataSourceProvidedDatabaseConfiguration databaseConfig = new DataSourceProvidedDatabaseConfiguration(new LinkedHashMap<String, DataSource>(), new LinkedList<RuleConfiguration>());
        return ShardingSphereDatabase.create(name, protocolType, databaseConfig, new LinkedList<ShardingSphereRule>(), SystemSchemaBuilder.build(name, protocolType));
    }

    private static ShardingSphereDatabase create(String name, DatabaseType protocolType, DatabaseConfiguration databaseConfig, Collection<ShardingSphereRule> rules, Map<String, ShardingSphereSchema> schemas) {
        ShardingSphereResource resource = ShardingSphereDatabase.createResource(databaseConfig.getDataSources());
        ShardingSphereRuleMetaData ruleMetaData = new ShardingSphereRuleMetaData(databaseConfig.getRuleConfigurations(), rules);
        return new ShardingSphereDatabase(name, protocolType, resource, ruleMetaData, schemas);
    }

    private static ShardingSphereResource createResource(Map<String, DataSource> dataSourceMap) {
        return new ShardingSphereResource(dataSourceMap);
    }

    public boolean isComplete() {
        return !this.ruleMetaData.getRules().isEmpty() && !this.resource.getDataSources().isEmpty();
    }

    public boolean hasDataSource() {
        return !this.resource.getDataSources().isEmpty();
    }

    @Generated
    public ShardingSphereDatabase(String name, DatabaseType protocolType, ShardingSphereResource resource, ShardingSphereRuleMetaData ruleMetaData, Map<String, ShardingSphereSchema> schemas) {
        this.name = name;
        this.protocolType = protocolType;
        this.resource = resource;
        this.ruleMetaData = ruleMetaData;
        this.schemas = schemas;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public DatabaseType getProtocolType() {
        return this.protocolType;
    }

    @Generated
    public ShardingSphereResource getResource() {
        return this.resource;
    }

    @Generated
    public ShardingSphereRuleMetaData getRuleMetaData() {
        return this.ruleMetaData;
    }

    @Generated
    public Map<String, ShardingSphereSchema> getSchemas() {
        return this.schemas;
    }
}

