/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.schema.builder;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.OpenGaussDatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.PostgreSQLDatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.SystemSchemaBuilderRule;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlTableMetaData;
import org.apache.shardingsphere.infra.yaml.schema.swapper.TableMetaDataYamlSwapper;
import org.yaml.snakeyaml.Yaml;

public final class SystemSchemaBuilder {
    public static Map<String, ShardingSphereSchema> build(String databaseName, DatabaseType databaseType) {
        LinkedHashMap<String, ShardingSphereSchema> result = new LinkedHashMap<String, ShardingSphereSchema>(databaseType.getSystemSchemas().size(), 1.0f);
        TableMetaDataYamlSwapper swapper = new TableMetaDataYamlSwapper();
        for (String each : SystemSchemaBuilder.getSystemSchemas(databaseName, databaseType)) {
            result.put(each.toLowerCase(), SystemSchemaBuilder.createSchema(SystemSchemaBuilder.getSchemaStreams(each, databaseType), swapper));
        }
        return result;
    }

    private static Collection<String> getSystemSchemas(String originalDatabaseName, DatabaseType databaseType) {
        String databaseName = databaseType instanceof PostgreSQLDatabaseType || databaseType instanceof OpenGaussDatabaseType ? "postgres" : originalDatabaseName;
        return databaseType.getSystemDatabaseSchemaMap().getOrDefault(databaseName, Collections.emptyList());
    }

    private static Collection<InputStream> getSchemaStreams(String schemaName, DatabaseType databaseType) {
        SystemSchemaBuilderRule builderRule = SystemSchemaBuilderRule.valueOf(databaseType.getType(), schemaName);
        LinkedList<InputStream> result = new LinkedList<InputStream>();
        for (String each : builderRule.getTables()) {
            result.add(SystemSchemaBuilder.class.getClassLoader().getResourceAsStream("schema/" + databaseType.getType().toLowerCase() + "/" + schemaName + "/" + each + ".yaml"));
        }
        return result;
    }

    private static ShardingSphereSchema createSchema(Collection<InputStream> schemaStreams, TableMetaDataYamlSwapper swapper) {
        LinkedHashMap<String, ShardingSphereTable> tables = new LinkedHashMap<String, ShardingSphereTable>(schemaStreams.size(), 1.0f);
        for (InputStream each : schemaStreams) {
            YamlTableMetaData metaData = (YamlTableMetaData)new Yaml().loadAs(each, YamlTableMetaData.class);
            tables.put(metaData.getName(), swapper.swapToObject(metaData));
        }
        return new ShardingSphereSchema(tables);
    }

    @Generated
    private SystemSchemaBuilder() {
    }
}

