/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rule.builder.schema;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.function.DistributedRuleConfiguration;
import org.apache.shardingsphere.infra.config.function.EnhancedRuleConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.schema.DefaultSchemaRuleConfigurationBuilder;
import org.apache.shardingsphere.infra.rule.builder.schema.DefaultSchemaRuleConfigurationBuilderFactory;
import org.apache.shardingsphere.infra.rule.builder.schema.SchemaRuleBuilder;
import org.apache.shardingsphere.infra.rule.builder.schema.SchemaRuleBuilderFactory;

public final class DatabaseRulesBuilder {
    public static Collection<ShardingSphereRule> build(String databaseName, DatabaseConfiguration databaseConfig, ConfigurationProperties props) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>();
        for (Map.Entry<RuleConfiguration, SchemaRuleBuilder> entry : DatabaseRulesBuilder.getRuleBuilderMap(databaseConfig).entrySet()) {
            result.add(entry.getValue().build(entry.getKey(), databaseName, databaseConfig.getDataSources(), result, props));
        }
        return result;
    }

    private static Map<RuleConfiguration, SchemaRuleBuilder> getRuleBuilderMap(DatabaseConfiguration databaseConfig) {
        LinkedHashMap<RuleConfiguration, SchemaRuleBuilder> result = new LinkedHashMap<RuleConfiguration, SchemaRuleBuilder>();
        result.putAll(DatabaseRulesBuilder.getDistributedRuleBuilderMap(databaseConfig.getRuleConfigurations()));
        result.putAll(DatabaseRulesBuilder.getEnhancedRuleBuilderMap(databaseConfig.getRuleConfigurations()));
        result.putAll(DatabaseRulesBuilder.getMissedDefaultRuleBuilderMap(result.values()));
        return result;
    }

    private static Map<RuleConfiguration, SchemaRuleBuilder> getDistributedRuleBuilderMap(Collection<RuleConfiguration> ruleConfigs) {
        Collection distributedRuleConfigs = ruleConfigs.stream().filter(each -> DatabaseRulesBuilder.isAssignableFrom(each, DistributedRuleConfiguration.class)).collect(Collectors.toList());
        return SchemaRuleBuilderFactory.getInstanceMap(distributedRuleConfigs, Comparator.reverseOrder());
    }

    private static Map<RuleConfiguration, SchemaRuleBuilder> getEnhancedRuleBuilderMap(Collection<RuleConfiguration> ruleConfigs) {
        Collection enhancedRuleConfigs = ruleConfigs.stream().filter(each -> DatabaseRulesBuilder.isAssignableFrom(each, EnhancedRuleConfiguration.class)).collect(Collectors.toList());
        return SchemaRuleBuilderFactory.getInstanceMap(enhancedRuleConfigs);
    }

    private static boolean isAssignableFrom(RuleConfiguration ruleConfig, Class<? extends RuleConfiguration> ruleConfigClass) {
        return Arrays.stream(ruleConfig.getClass().getInterfaces()).anyMatch(ruleConfigClass::isAssignableFrom);
    }

    private static Map<RuleConfiguration, SchemaRuleBuilder> getMissedDefaultRuleBuilderMap(Collection<SchemaRuleBuilder> configuredBuilders) {
        LinkedHashMap<RuleConfiguration, SchemaRuleBuilder> result = new LinkedHashMap<RuleConfiguration, SchemaRuleBuilder>();
        Map<SchemaRuleBuilder, DefaultSchemaRuleConfigurationBuilder> defaultBuilders = DefaultSchemaRuleConfigurationBuilderFactory.getInstances(DatabaseRulesBuilder.getMissedDefaultRuleBuilders(configuredBuilders));
        for (Map.Entry<SchemaRuleBuilder, DefaultSchemaRuleConfigurationBuilder> entry : defaultBuilders.entrySet()) {
            result.put((RuleConfiguration)entry.getValue().build(), entry.getKey());
        }
        return result;
    }

    private static Collection<SchemaRuleBuilder> getMissedDefaultRuleBuilders(Collection<SchemaRuleBuilder> configuredBuilders) {
        Collection configuredBuilderClasses = configuredBuilders.stream().map(each -> each.getClass()).collect(Collectors.toSet());
        return SchemaRuleBuilderFactory.getInstances().stream().filter(each -> !configuredBuilderClasses.contains(each.getClass())).collect(Collectors.toList());
    }

    @Generated
    private DatabaseRulesBuilder() {
    }
}

