/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.yaml.engine;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlConfiguration;
import org.apache.shardingsphere.infra.yaml.engine.constructor.ShardingSphereYamlConstructor;
import org.apache.shardingsphere.infra.yaml.engine.representer.ShardingSphereYamlRepresenter;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.representer.Representer;

public final class YamlEngine {
    public static <T extends YamlConfiguration> T unmarshal(File yamlFile, Class<T> classType) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(yamlFile);){
            YamlConfiguration yamlConfiguration;
            try (InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);){
                yamlConfiguration = (YamlConfiguration)new Yaml((BaseConstructor)new ShardingSphereYamlConstructor(classType)).loadAs((Reader)inputStreamReader, classType);
            }
            return (T)yamlConfiguration;
        }
    }

    public static <T extends YamlConfiguration> T unmarshal(byte[] yamlBytes, Class<T> classType) throws IOException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(yamlBytes);){
            YamlConfiguration yamlConfiguration = (YamlConfiguration)new Yaml((BaseConstructor)new ShardingSphereYamlConstructor(classType)).loadAs((InputStream)inputStream, classType);
            return (T)yamlConfiguration;
        }
    }

    public static <T> T unmarshal(String yamlContent, Class<T> classType) {
        return (T)new Yaml((BaseConstructor)new ShardingSphereYamlConstructor(classType)).loadAs(yamlContent, classType);
    }

    public static <T> T unmarshal(String yamlContent, Class<T> classType, boolean skipMissingProps) {
        Representer representer = new Representer();
        representer.getPropertyUtils().setSkipMissingProperties(skipMissingProps);
        return (T)new Yaml((BaseConstructor)new ShardingSphereYamlConstructor(classType), representer).loadAs(yamlContent, classType);
    }

    public static String marshal(Object value) {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setLineBreak(DumperOptions.LineBreak.getPlatformLineBreak());
        if (value instanceof Collection) {
            return new Yaml((Representer)new ShardingSphereYamlRepresenter(), dumperOptions).dumpAs(value, null, DumperOptions.FlowStyle.BLOCK);
        }
        return new Yaml((Representer)new ShardingSphereYamlRepresenter(), dumperOptions).dumpAsMap(value);
    }

    @Generated
    private YamlEngine() {
    }
}

